// ========================================================================
// Copyright 2007 Mort Bay Consulting Pty. Ltd.
// ------------------------------------------------------------------------
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at 
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//========================================================================

package org.mortbay.cometd;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;

import org.cometd.Message;
import org.mortbay.util.ajax.JSON;


public class JSONTransport extends AbstractTransport
{
    private int _responses=0;
    private PrintWriter _out;
    protected String _contentType;
    protected String _start;
    protected String _end;
    private boolean _commented;
    
    /* ------------------------------------------------------------ */
    public JSONTransport(boolean commented)
    {
        setJSONCommented(commented);
    }

    /* ------------------------------------------------------------ */
    /**
     * @return the commented
     */
    public boolean isJSONCommented()
    {
        return _commented;
    }

    /* ------------------------------------------------------------ */
    /**
     * @param commented the commented to set
     */
    public void setJSONCommented(boolean commented)
    {
        _commented=commented;
        if (commented)
        {
            _contentType="text/json-comment-filtered; charset=utf-8";
            _start="/*[";
            _end="]*/\r\n";
        }
        else
        {
            _contentType="text/json; charset=utf-8";
            _start="[";
            _end="]\r\n";
        }
    }
    
    /* ------------------------------------------------------------ */
    public synchronized void send(Message message) throws IOException
    {
        if (message!=null)
        {
            if (message.size()==0)
                throw new IllegalStateException();

            String r=(message instanceof MessageImpl)
                ?((MessageImpl)message).getJSON()
                :JSON.toString(message);
                
            ((MessageImpl)message).decRef();
            
            HttpServletResponse response=getResponse();
            
            switch(_responses)
            {
                case 0:
                    response.setStatus(200);
                    response.setContentType(_contentType);
                    _out=response.getWriter();
                    _out.write(_start);
                    _out.write(r);
                    break;
                    
                default: 
                    _out.write(',');
                    _out.write(r);
            }
            
            _responses++;
        }
    }

    /* ------------------------------------------------------------ */
    public synchronized void complete() throws IOException
    {
        if (_responses==0)
        {
            HttpServletResponse response=getResponse();
            response.setStatus(200);
            _out=response.getWriter();
            _out.write(_start);
        }
        _out.write(_end);
        _out.close();
        _responses=0;
    }

    /* ------------------------------------------------------------ */
    public boolean resumePoll()
    {
        return false;
    }
}