package org.jfree.chart.editor.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;


import org.jfree.chart.editor.*;
import org.jfree.chart.editor.GradientColorPaletteEditor;
import org.jfree.chart.plot.*;
import org.jfree.chart.*;

/**
 * A collection of tests for the 
 * {@link org.jfree.chart.editor.GradientColorPaletteEditor} class.
 */
public class GradientColorPaletteEditorTests extends TestCase {

    /**
     * Returns a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(GradientColorPaletteEditorTests.class);
    }

    /**
     * Constructs the test suite.
     *
     * @param name  the suite name.
     */
    public GradientColorPaletteEditorTests(String name) {
        super(name);
    }

    /**
     * Tests the setColoring() method.
     */
    public void testSetColoring(){

	GradientColorPaletteEditor editor = new GradientColorPaletteEditor();
	GradientColorPalette plt = new GradientColorPalette();
	editor.setColoring(plt);

	//no way to assert.
    }

    /**
     * Tests the getPanel() method.
     */
    public void testGetPanel(){

	GradientColorPaletteEditor editor = new GradientColorPaletteEditor();
	GradientColorPalette plt = new GradientColorPalette();
	plt.setLinear(false);
	plt.addKeyColor(0.5, 255, 150, 0);
	plt.addKeyColor(-0.5, 0, 255, 100);

	editor.setColoring(plt);

	//Set keyColors = plt.getKeyColors();

	JPanel panel = editor.getPanel();

	Component[] compo = panel.getComponents();
	

	// The following test has been omitted
	// because it opens JColorChooser dialogs
	// during the running of JUnit.
	
	/**for (int i=0; i < compo.length; i++){
		if (compo[i] instanceof JButton){
			JButton button = new JButton();
			button = (JButton)compo[i];
			if (button.getText().equals("Change")){
			  button.setActionCommand("SAVE_COMMAND");
			  
			  try {
				editor.actionPerformed(new ActionEvent(button, 1, "SAVE_COMMAND"));
			  } catch (Exception e) {}
			}
		}

		if (compo[i] instanceof JLabel){
			JLabel label = new JLabel();
			label = (JLabel)compo[i];
			if (label.getText().equals("Color_for_values_below"+ 0.5) ||
			    label.getText().equals("Color_for_values_below"+ 1.0) ||
			    label.getText().equals("Color_for_values_below"+ -1.0) ||
			    label.getText().equals("Color_for_values_below"+ 0.0) ||
			    label.getText().equals("Color_for_values_below"+ -0.5)){
			  try {
				editor.actionPerformed(new ActionEvent(label, 1, "SAVE_COMMAND"));
			  } catch (Exception e) {}
		 	}
			if (label.getText().equals("Color_for_values_above"+ 0.5) ||
			    label.getText().equals("Color_for_values_above"+ 1.0) ||
			    label.getText().equals("Color_for_values_above"+ -1.0) ||
			    label.getText().equals("Color_for_values_above"+ 0.0) ||
			    label.getText().equals("Color_for_values_above"+ -0.5)){
			  try {
				editor.actionPerformed(new ActionEvent(label, 1, "SAVE_COMMAND"));
			  } catch (Exception e) {}
		 	}
			if (label.getText().equals("Color_for_value"+ 0.5) ||
			    label.getText().equals("Color_for_value"+ 1.0) ||
			    label.getText().equals("Color_for_value"+ -1.0) ||
			    label.getText().equals("Color_for_value"+ 0.0) ||
			    label.getText().equals("Color_for_value"+ -0.5)){
			  try {
				editor.actionPerformed(new ActionEvent(label, 1, "SAVE_COMMAND"));
			  } catch (Exception e) {}
		 	}
		} 
	}*/


	for (int i=0; i < compo.length; i++){
		if (compo[i] instanceof JCheckBox){
			JCheckBox box = new JCheckBox();
			box = (JCheckBox)compo[i];
			if (box.getText().equals("Use logarithmic scale")){
			  box.setSelected(false);
			  editor.stateChanged(new ChangeEvent(compo[i]));
			  box.setSelected(true);
			  editor.stateChanged(new ChangeEvent(compo[i]));
			}
		}
	}

    }

}
