/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.broker.jmx.AbortSlowConsumerStrategyViewMBean;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.OpenTypeSupport;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.AbortSlowConsumerStrategy;
import org.apache.activemq.broker.region.policy.SlowConsumerEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbortSlowConsumerStrategyView
implements AbortSlowConsumerStrategyViewMBean {
    private static final Log LOG = LogFactory.getLog(AbortSlowConsumerStrategyView.class);
    private ManagedRegionBroker broker;
    private AbortSlowConsumerStrategy strategy;

    public AbortSlowConsumerStrategyView(ManagedRegionBroker managedRegionBroker, AbortSlowConsumerStrategy slowConsumerStrategy) {
        this.broker = managedRegionBroker;
        this.strategy = slowConsumerStrategy;
    }

    public long getMaxSlowCount() {
        return this.strategy.getMaxSlowCount();
    }

    public void setMaxSlowCount(long maxSlowCount) {
        this.strategy.setMaxSlowCount(maxSlowCount);
    }

    public long getMaxSlowDuration() {
        return this.strategy.getMaxSlowDuration();
    }

    public void setMaxSlowDuration(long maxSlowDuration) {
        this.strategy.setMaxSlowDuration(maxSlowDuration);
    }

    public long getCheckPeriod() {
        return this.strategy.getCheckPeriod();
    }

    public TabularData getSlowConsumers() throws OpenDataException {
        OpenTypeSupport.OpenTypeFactory factory = OpenTypeSupport.getFactory(SlowConsumerEntry.class);
        CompositeType ct = factory.getCompositeType();
        TabularType tt = new TabularType("SlowConsumers", "Table of current slow Consumers", ct, new String[]{"subscription"});
        TabularDataSupport rc = new TabularDataSupport(tt);
        boolean index = false;
        Map<Subscription, SlowConsumerEntry> slowConsumers = this.strategy.getSlowConsumers();
        for (Map.Entry<Subscription, SlowConsumerEntry> entry : slowConsumers.entrySet()) {
            entry.getValue().setSubscription(this.broker.getSubscriberObjectName(entry.getKey()));
            rc.put(OpenTypeSupport.convert(entry.getValue()));
        }
        return rc;
    }

    public void abortConsumer(ObjectName consumerToAbort) {
        Subscription sub = this.broker.getSubscriber(consumerToAbort);
        if (sub != null) {
            LOG.info("aborting consumer via jmx: " + sub.getConsumerInfo().getConsumerId());
            this.strategy.abortConsumer(sub, false);
        } else {
            LOG.warn("cannot resolve subscription matching name: " + consumerToAbort);
        }
    }

    public void abortConnection(ObjectName consumerToAbort) {
        Subscription sub = this.broker.getSubscriber(consumerToAbort);
        if (sub != null) {
            LOG.info("aborting consumer connection via jmx: " + sub.getConsumerInfo().getConsumerId().getConnectionId());
            this.strategy.abortConsumer(sub, true);
        } else {
            LOG.warn("cannot resolve subscription matching name: " + consumerToAbort);
        }
    }

    public void abortConsumer(String objectNameOfConsumerToAbort) {
        this.abortConsumer(this.toObjectName(objectNameOfConsumerToAbort));
    }

    public void abortConnection(String objectNameOfConsumerToAbort) {
        this.abortConnection(this.toObjectName(objectNameOfConsumerToAbort));
    }

    private ObjectName toObjectName(String objectName) {
        ObjectName result = null;
        try {
            result = new ObjectName(objectName);
        }
        catch (Exception e) {
            LOG.warn("cannot create subscription ObjectName to abort, from string: " + objectName);
        }
        return result;
    }
}

