/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.config;

import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.UrlTransferUtil;
import fi.csc.microarray.util.XmlUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SetupTool {
    private final File ENVIRONMENT_XML = new File("comp/conf/environment.xml");

    public static int main(String[] args) throws Exception {
        return new SetupTool().setup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setup() throws Exception {
        int n;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Chipster environment installer processing " + this.ENVIRONMENT_XML.getAbsolutePath());
        System.out.println("Please press any key to continue or Ctrl+C to abort...");
        in.readLine();
        HashMap<String, Installer> installers = new HashMap<String, Installer>();
        installers.put("application", new DummyInstaller());
        installers.put("file", new DummyInstaller());
        installers.put("r-package", new RPackageInstaller());
        installers.put("os-package", new OSPackageInstaller());
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String time = new SimpleDateFormat("kkmm").format(new Date());
        File logFile = this.createLogFile("install", date, time);
        File infoFile = this.createLogFile("extra.info", date, time);
        PrintWriter logOut = null;
        PrintWriter infoOut = null;
        FileOutputStream xmlOut = null;
        try {
            int returnCode;
            logOut = new PrintWriter(new FileOutputStream(logFile));
            infoOut = new PrintWriter(new FileOutputStream(infoFile));
            Document xml = XmlUtil.parseFile(this.ENVIRONMENT_XML);
            NodeList tasks = xml.getDocumentElement().getElementsByTagName("bundle");
            LinkedList<Element> workQueue = new LinkedList<Element>();
            for (int i = 0; i < tasks.getLength(); ++i) {
                Element bundle = (Element)tasks.item(i);
                NodeList children = bundle.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    if (!(children.item(j) instanceof Element)) continue;
                    Element element = (Element)children.item(j);
                    if (this.isInstalled(element)) {
                        logOut.println("Already installed: " + this.descibeItem(element));
                        continue;
                    }
                    workQueue.add(element);
                }
            }
            LinkedList<Element> failedItems = new LinkedList<Element>();
            LinkedList<Element> successfullItems = new LinkedList<Element>();
            while (!workQueue.isEmpty()) {
                Element element = null;
                Element requiredBundle = null;
                for (Element e : workQueue) {
                    String depends = ((Element)e.getParentNode()).getAttribute("depends");
                    if (!"".equals(depends) && !this.isInstalled(requiredBundle = XmlUtil.getChildWithAttributeValue(xml.getDocumentElement(), "name", depends))) continue;
                    element = e;
                    workQueue.remove(e);
                    break;
                }
                if (element == null) break;
                System.out.println("\nInstalling " + this.descibeItem(element) + "...");
                Installer installer = (Installer)installers.get(element.getAttribute("type"));
                if (installer == null) {
                    System.out.println("unrecognised item type: " + element.getAttribute("type"));
                    failedItems.add(element);
                    continue;
                }
                boolean ok = installer.install(element, requiredBundle, infoOut);
                if (ok) {
                    System.out.println("  Installation succesfull.");
                    logOut.println("Installed successfully: " + this.descibeItem(element));
                    element.setAttribute("installed", "true");
                    successfullItems.add(element);
                    continue;
                }
                System.out.println("  Installation FAILED.");
                logOut.println("Installation FAILED: " + this.descibeItem(element));
                failedItems.add(element);
            }
            CharArrayWriter caout = new CharArrayWriter();
            PrintWriter out = new PrintWriter(caout);
            out.println("\n\n********************\nINSTALLATION SUMMARY\n********************\n");
            if (!successfullItems.isEmpty()) {
                out.println("Installation for following items was successfull");
                for (Element e : successfullItems) {
                    out.println("  " + this.descibeItem(e));
                }
            }
            boolean requiredNotInstalled = false;
            if (!failedItems.isEmpty()) {
                out.println("Installation for following items failed");
                for (Element e : failedItems) {
                    out.println("  " + this.descibeItem(e));
                    if (!"true".equals(((Element)e.getParentNode()).getAttribute("required"))) continue;
                    requiredNotInstalled = true;
                }
            }
            if (!workQueue.isEmpty()) {
                out.println("\nFollowing items could not be installed because of unmet dependencies");
                for (Element e : workQueue) {
                    out.println("  " + this.descibeItem(e));
                    if (!"true".equals(((Element)e.getParentNode()).getAttribute("required"))) continue;
                    requiredNotInstalled = true;
                }
            }
            out.print("\nResult: ");
            if (requiredNotInstalled) {
                out.println("Required bundles were not installed. Environment is not usable.");
                returnCode = 2;
            } else if (!workQueue.isEmpty() || !failedItems.isEmpty()) {
                out.println("Some bundles were not installed, but all required bundles were. Environment is usable but not complete. ");
                returnCode = 1;
            } else {
                out.println("All bundles were installed. Environment is completely installed.");
                returnCode = 0;
            }
            out.close();
            System.out.println(caout.toString());
            System.out.println("Written installation log to " + logFile);
            System.out.println("Written additional instructions for required manual installation steps (if any) to " + infoFile);
            xmlOut = new FileOutputStream(this.ENVIRONMENT_XML);
            XmlUtil.printXml(xml, xmlOut);
            n = returnCode;
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(infoOut);
            IOUtils.closeIfPossible(logOut);
            IOUtils.closeIfPossible(xmlOut);
            throw throwable;
        }
        IOUtils.closeIfPossible(infoOut);
        IOUtils.closeIfPossible(logOut);
        IOUtils.closeIfPossible(xmlOut);
        return n;
    }

    private File createLogFile(String name, String date, String time) {
        File file = new File(name + "." + date + "." + time + ".log");
        int i = 2;
        while (file.exists()) {
            file = new File(name + "." + date + "." + time + "." + i + ".log");
            ++i;
        }
        return file;
    }

    private boolean isInstalled(Element element) {
        if ("item".equals(element.getLocalName())) {
            return "true".equals(element.getAttribute("installed"));
        }
        if ("bundle".equals(element.getLocalName())) {
            NodeList items = element.getElementsByTagName("item");
            for (int i = 0; i < items.getLength(); ++i) {
                if (this.isInstalled((Element)items.item(i))) continue;
                return false;
            }
            return true;
        }
        throw new RuntimeException("illegal XML element: " + element.getLocalName());
    }

    private String descibeItem(Element item) {
        return item.getLocalName() + " " + item.getAttribute("name") + " (in bundle " + ((Element)item.getParentNode()).getAttribute("name") + ")";
    }

    private static boolean isRPackageInstalled(String rExecutable, String packageName) throws IOException, InterruptedException {
        String buffer = SetupTool.runRCommands(rExecutable, new String[]{"if(require(\"" + packageName + "\")) { print(gsub(\"_remove this_\", \"\", paste(\"IS ALREADY INSTALLED:_remove this_\", \"" + packageName + "\"))) }"});
        return buffer.contains("IS ALREADY INSTALLED: " + packageName);
    }

    private static boolean runRInstallCommand(String rExecutable, String command) throws IOException, InterruptedException {
        return SetupTool.runRInstallCommands(rExecutable, new String[]{command});
    }

    private static boolean runRInstallCommands(String rExecutable, String[] commands) throws IOException, InterruptedException {
        String buffer = SetupTool.runRCommands(rExecutable, commands);
        return buffer.contains("DONE") && !buffer.contains("FAILED") && !buffer.contains("ERROR");
    }

    private static String runRCommands(String rExecutable, String[] commands) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(rExecutable + " --vanilla", null, new File(System.getProperty("user.dir")));
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SetupTool.startBackgroundEchoThread(process.getInputStream(), new OutputStream[]{System.out, buffer});
        SetupTool.startBackgroundEchoThread(process.getErrorStream(), new OutputStream[]{System.err, buffer});
        PrintWriter commandWriter = new PrintWriter(process.getOutputStream());
        for (String command : commands) {
            commandWriter.println(command);
        }
        commandWriter.println("quit(save=\"no\")");
        commandWriter.flush();
        process.waitFor();
        return buffer.toString();
    }

    private static void startBackgroundEchoThread(final InputStream inputStream, final OutputStream[] outs) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int i = inputStream.read();
                    while (i != -1) {
                        for (OutputStream out : outs) {
                            out.write(i);
                        }
                        i = inputStream.read();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadFile(URL url) throws JMSException, IOException, MalformedURLException, FileNotFoundException {
        File file = new File(new File(url.getFile()).getName());
        InputStream downloadStream = null;
        FileOutputStream out = null;
        file.deleteOnExit();
        try {
            downloadStream = UrlTransferUtil.downloadStream(url);
            out = new FileOutputStream(file);
            IOUtils.copy(downloadStream, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeIfPossible(downloadStream);
            IOUtils.closeIfPossible(out);
            throw throwable;
        }
        IOUtils.closeIfPossible(downloadStream);
        IOUtils.closeIfPossible(out);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadString(URL url) throws JMSException, IOException, MalformedURLException, FileNotFoundException {
        InputStream downloadStream = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            downloadStream = UrlTransferUtil.downloadStream(url);
            IOUtils.copy(downloadStream, out);
        }
        finally {
            IOUtils.closeIfPossible(downloadStream);
            IOUtils.closeIfPossible(out);
        }
        return out.toString();
    }

    private static class OSPackageInstaller
    implements Installer {
        private OSPackageInstaller() {
        }

        @Override
        public boolean install(Element item, Element dependsOnBundle, PrintWriter infoWriter) {
            String name = XmlUtil.getChildElement(item, "package-name").getTextContent();
            Element altName = XmlUtil.getChildElement(item, "alternative-package-name");
            if (altName == null) {
                infoWriter.println("Install manually OS package " + name);
            } else {
                infoWriter.println("Install manually OS package " + name + " (or alternatively " + altName.getTextContent() + ")");
            }
            infoWriter.println("");
            return true;
        }
    }

    private static class RPackageInstaller
    implements Installer {
        private RPackageInstaller() {
        }

        @Override
        public boolean install(Element item, Element dependsOnBundle, PrintWriter infoWriter) throws Exception {
            try {
                String rExecutable = this.fetchRExecutable(dependsOnBundle);
                if (item.getElementsByTagName("url").getLength() > 0) {
                    URL url = new URL(item.getElementsByTagName("url").item(0).getTextContent().trim());
                    return this.downloadAndInstall(url, rExecutable);
                }
                if (item.getElementsByTagName("repository").getLength() > 0) {
                    String repository = item.getElementsByTagName("repository").item(0).getTextContent().trim();
                    String packageName = item.getElementsByTagName("package").item(0).getTextContent().trim();
                    if (SetupTool.isRPackageInstalled(rExecutable, packageName)) {
                        return true;
                    }
                    return SetupTool.runRInstallCommand(rExecutable, "install.packages(c(\"" + packageName + "\"), repos=\"" + repository + "\")");
                }
                if (item.getElementsByTagName("default-bioconductor-packages").getLength() > 0) {
                    String mirror = item.getElementsByTagName("mirror").item(0).getTextContent().trim();
                    return SetupTool.runRInstallCommands(rExecutable, this.generateBiocCommands(new String[]{"biocLite()"}, mirror));
                }
                if (item.getElementsByTagName("bioconductor-package").getLength() > 0) {
                    String packageName = item.getElementsByTagName("bioconductor-package").item(0).getTextContent().trim();
                    String mirror = item.getElementsByTagName("mirror").item(0).getTextContent().trim();
                    if (SetupTool.isRPackageInstalled(rExecutable, packageName)) {
                        return true;
                    }
                    return SetupTool.runRInstallCommands(rExecutable, this.generateBiocCommands(new String[]{"biocLite(c(\"" + packageName + "\"))"}, mirror));
                }
                if (item.getElementsByTagName("bioconductor-repository").getLength() > 0) {
                    String repositoryName = item.getElementsByTagName("bioconductor-repository").item(0).getTextContent().trim();
                    String mirror = item.getElementsByTagName("mirror").item(0).getTextContent().trim();
                    return SetupTool.runRInstallCommands(rExecutable, this.generateBiocCommands(new String[]{"setRepositories(ind=c(" + repositoryName + "))", "install.packages(available.packages())"}, mirror));
                }
                if (item.getElementsByTagName("from-web-page").getLength() > 0) {
                    URL url = new URL(item.getElementsByTagName("from-web-page").item(0).getTextContent().trim());
                    String pageContents = SetupTool.downloadString(url);
                    Matcher matcher = Pattern.compile("href=\"([^\"]*)\"").matcher(pageContents);
                    while (matcher.find()) {
                        boolean ok;
                        String link = matcher.group(1);
                        if (!link.endsWith(".tar.gz")) continue;
                        if (!link.startsWith("http")) {
                            link = url.toString().substring(0, url.toString().lastIndexOf(47) + 1) + link;
                        }
                        if (ok = this.downloadAndInstall(new URL(link), rExecutable)) continue;
                        return false;
                    }
                    return true;
                }
                throw new RuntimeException("don't know how to run " + item.getAttribute("name"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        private String[] generateBiocCommands(String[] commands, String mirror) {
            String[] initBioc = new String[]{"source(\"http://www.bioconductor.org/biocLite.R\")", "options(\"BioC_mirror\" = c(\"Mirror\"=\"" + mirror + "\"))"};
            String[] biocCommands = new String[initBioc.length + commands.length];
            System.arraycopy(initBioc, 0, biocCommands, 0, initBioc.length);
            System.arraycopy(commands, 0, biocCommands, initBioc.length, commands.length);
            return biocCommands;
        }

        private String fetchRExecutable(Element dependsOnBundle) {
            Element rBundle = XmlUtil.getChildWithAttributeValue(dependsOnBundle, "type", "application");
            String rExecutable = ((Element)rBundle.getElementsByTagName("dir").item(0)).getTextContent() + "/bin/R";
            rExecutable = rExecutable.replaceAll("//", "/");
            return rExecutable;
        }

        private boolean downloadAndInstall(URL url, String rExecutable) throws MalformedURLException, JMSException, IOException, FileNotFoundException, InterruptedException {
            System.out.println("  Download and install package from " + url + " to " + rExecutable);
            File file = SetupTool.downloadFile(url);
            boolean ok = SetupTool.runRInstallCommand(rExecutable, "install.packages(pkgs=\"" + file.getAbsolutePath() + "\", repos=NULL)");
            file.delete();
            return ok;
        }
    }

    private static class DummyInstaller
    implements Installer {
        private DummyInstaller() {
        }

        @Override
        public boolean install(Element item, Element dependsOnBundle, PrintWriter infoWriter) {
            for (Element command : XmlUtil.getChildElements(item)) {
                if ("dir".equals(command.getNodeName())) {
                    infoWriter.println("In " + command.getTextContent() + ": ");
                    continue;
                }
                if ("comment".equals(command.getNodeName())) {
                    String comment = command.getTextContent().trim();
                    for (String line : comment.split("\n")) {
                        infoWriter.println("  " + line.trim());
                    }
                    continue;
                }
                throw new RuntimeException("unknown element in application item: " + command.getNodeName());
            }
            infoWriter.println("");
            return true;
        }
    }

    private static interface Installer {
        public boolean install(Element var1, Element var2, PrintWriter var3) throws Exception;
    }
}

