/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.ToolCategory;
import fi.csc.microarray.client.operation.ToolModule;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.messaging.TempTopicMessagingListenerBase;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

public class DescriptionMessageListener
extends TempTopicMessagingListenerBase {
    private static final Logger logger = Logger.getLogger(DescriptionMessageListener.class);
    private HashMap<String, ToolModule> modules = new LinkedHashMap<String, ToolModule>();
    private final CountDownLatch latch = new CountDownLatch(1);
    private String[] requiredModules;
    private boolean finished = false;
    private boolean[] isModuleLoaded;
    private ModuleDescriptionMessage[] messages;

    public DescriptionMessageListener(String[] requiredModules) {
        this.requiredModules = requiredModules;
        this.isModuleLoaded = new boolean[requiredModules.length];
        this.messages = new ModuleDescriptionMessage[requiredModules.length];
        Arrays.fill(this.isModuleLoaded, false);
    }

    public Collection<ToolModule> getModules() {
        return this.modules.values();
    }

    public void waitForResponse() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.warn((Object)"interrupted while waiting for descriptions message", (Throwable)e);
        }
    }

    @Override
    public void onChipsterMessage(ChipsterMessage cMsg) {
        if (this.finished) {
            return;
        }
        ModuleDescriptionMessage descriptionMsg = (ModuleDescriptionMessage)cMsg;
        for (int i = 0; i < this.requiredModules.length; ++i) {
            if (!this.requiredModules[i].equals(descriptionMsg.getModuleName()) || this.isModuleLoaded[i]) continue;
            this.isModuleLoaded[i] = true;
            this.messages[i] = descriptionMsg;
            if (!this.isAllModulesLoaded()) continue;
            for (ModuleDescriptionMessage mdMsg : this.messages) {
                try {
                    this.parseMessage(mdMsg);
                }
                catch (SADLParser.ParseException e) {
                    logger.warn((Object)"parsing descriptions message failed", (Throwable)e);
                }
            }
            this.finished = true;
            this.latch.countDown();
        }
    }

    private boolean isAllModulesLoaded() {
        for (boolean isLoaded : this.isModuleLoaded) {
            if (isLoaded) continue;
            return false;
        }
        return true;
    }

    private void parseMessage(ModuleDescriptionMessage descriptionMsg) throws SADLParser.ParseException {
        List<ModuleDescriptionMessage.Category> categories = descriptionMsg.getCategories();
        logger.debug((Object)("generating operations from " + categories.size() + " categories"));
        ToolModule module = new ToolModule(descriptionMsg.getModuleName());
        for (ModuleDescriptionMessage.Category category : categories) {
            ToolCategory toolCategory = new ToolCategory(category.getName());
            toolCategory.setColor(category.getColor());
            toolCategory.setModule(module);
            if (category.isHidden().booleanValue()) {
                module.addHiddenToolCategory(toolCategory);
            } else {
                module.addVisibleToolCategory(toolCategory);
            }
            logger.debug((Object)("added category " + toolCategory.getName()));
            for (ModuleDescriptionMessage.Tool tool : category.getTools()) {
                SADLDescription sadl = new ChipsterSADLParser().parse(tool.getDescription());
                if (module.getOperationDefinition(sadl.getName().getID()) != null) {
                    logger.warn((Object)("ignoring tool with duplicate id: " + sadl.getName().getID()));
                    Session.getSession().getApplication().showDialog("Ignoring tool with duplicate id " + sadl.getName().getID(), "This message is meant for the Chipster service administrator, who should check the tool configurations. Don't worry about it.", "", DialogInfo.Severity.INFO, false);
                    continue;
                }
                OperationDefinition newDefinition = new OperationDefinition(sadl.getName().getID(), sadl.getName().getDisplayName(), toolCategory, sadl.getComment(), true, tool.getHelpURL());
                for (SADLDescription.Input input : sadl.inputs()) {
                    if (input.getName().isNameSet()) {
                        newDefinition.addInput(input.getName().getPrefix(), input.getName().getPostfix(), input.getName().getDisplayName(), input.getComment(), input.getType(), input.isOptional());
                        continue;
                    }
                    newDefinition.addInput(input.getName(), input.getComment(), input.getType(), input.isOptional());
                }
                newDefinition.setOutputCount(sadl.outputs().size());
                for (SADLDescription.Parameter parameter : sadl.parameters()) {
                    newDefinition.addParameter(Parameter.createInstance(parameter.getName(), parameter.getType(), parameter.getSelectionOptions(), parameter.getComment(), parameter.getFrom(), parameter.getTo(), parameter.getDefaultValues(), parameter.isOptional()));
                }
            }
        }
        this.modules.put(module.getModuleName(), module);
        logger.debug((Object)"operation generation returning successfully");
    }
}

