/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.operation.OperationRecord;
import fi.csc.microarray.client.session.SessionLoader;
import fi.csc.microarray.client.session.SessionSaver;
import fi.csc.microarray.databeans.ContentChangedEvent;
import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.TypeTag;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProvider;
import fi.csc.microarray.databeans.features.Modifier;
import fi.csc.microarray.databeans.handlers.LocalFileDataBeanHandler;
import fi.csc.microarray.databeans.handlers.ZipDataBeanHandler;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.Strings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.mortbay.util.IO;

public class DataManager {
    private static final String TEMP_DIR_PREFIX = "chipster";
    private static final int MAX_FILENAME_LENGTH = 256;
    private static final Logger logger = Logger.getLogger(DataManager.class);
    public static final String ROOT_NAME = "Datasets";
    private Map<String, FeatureProvider> factories = new HashMap<String, FeatureProvider>();
    private Map<String, Modifier> modifiers = new HashMap<String, Modifier>();
    private Map<String, ContentType> contentTypes = new HashMap<String, ContentType>();
    private Map<String, String> extensionMap = new HashMap<String, String>();
    private HashMap<String, TypeTag> tagMap = new HashMap();
    private LinkedList<DataChangeListener> listeners = new LinkedList();
    private boolean eventsEnabled = false;
    private DataFolder rootFolder;
    private File repositoryRoot;
    private ZipDataBeanHandler zipDataBeanHandler = new ZipDataBeanHandler(this);
    private LocalFileDataBeanHandler localFileDataBeanHandler = new LocalFileDataBeanHandler(this);

    public DataManager() throws IOException {
        this.rootFolder = this.createFolder(ROOT_NAME);
        this.repositoryRoot = this.createRepository();
    }

    public void setRootFolder(DataFolder folder) {
        this.rootFolder = folder;
    }

    public File getRepository() {
        return this.repositoryRoot;
    }

    public DataFolder getRootFolder() {
        return this.rootFolder;
    }

    public boolean isRootFolder(DataFolder folder) {
        return this.rootFolder == folder && this.rootFolder != null;
    }

    public DataFolder createFolder(String name) {
        DataFolder folder = new DataFolder(this, name);
        return folder;
    }

    public DataFolder createFolder(DataFolder root, String name) {
        DataFolder folder = new DataFolder(this, name);
        root.addChild(folder);
        return folder;
    }

    public void addDataChangeListener(DataChangeListener listener) {
        logger.debug((Object)("adding DataChangeListener: " + listener));
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.listeners.add(listener);
    }

    public synchronized File createNewRepositoryFile(String beanName) throws IOException {
        String fileName = beanName.replaceAll("[^\\w\\.\\-_]", "");
        if (fileName.length() < 1) {
            fileName = "data";
        } else if (fileName.length() > 256) {
            fileName = fileName.substring(0, 256);
        }
        File file = new File(this.repositoryRoot, fileName);
        int indexOfDot = fileName.lastIndexOf(".");
        String newFileName = "";
        for (int i = 1; file.exists() && i < Integer.MAX_VALUE; ++i) {
            newFileName = indexOfDot < 0 ? fileName + "-" + i : fileName.substring(0, indexOfDot) + "-" + i + fileName.substring(indexOfDot, fileName.length());
            file = new File(this.repositoryRoot, newFileName);
        }
        if (!file.createNewFile()) {
            throw new IOException("Could not create file " + fileName);
        }
        file.deleteOnExit();
        return file;
    }

    private File createRepository() throws IOException {
        File tempRoot = this.getTempRoot();
        if (!tempRoot.canWrite()) {
            throw new IOException("Could not create repository directory.");
        }
        String fileName = TEMP_DIR_PREFIX;
        File repository = new File(tempRoot, fileName);
        boolean repositoryCreated = false;
        for (int i = 1; !repositoryCreated && i < 1000; ++i) {
            repositoryCreated = repository.mkdir();
            if (repositoryCreated) continue;
            repository = new File(tempRoot, fileName + "-" + i);
        }
        if (!repositoryCreated) {
            throw new IOException("Could not create repository directory.");
        }
        repository.deleteOnExit();
        return repository;
    }

    private File getTempRoot() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.canWrite() && !(tempDir = new File(System.getProperty("user.home"))).canWrite()) {
            tempDir = new File(System.getProperty("user.dir"));
        }
        return tempDir;
    }

    public void setEventsEnabled(boolean enabled) {
        this.eventsEnabled = enabled;
    }

    public void dispatchEventIfVisible(DataChangeEvent event) {
        if (event.getDataItem().getParent() != null) {
            this.dispatchEvent(event);
        }
    }

    public void dispatchEvent(DataChangeEvent event) {
        if (this.eventsEnabled) {
            for (DataChangeListener listener : this.listeners) {
                if (listener == null) {
                    logger.error((Object)"One of the DataChangeListeners listeners was null.");
                } else {
                    logger.debug((Object)("Notifying DataChangeListener " + listener.toString()));
                }
                try {
                    listener.dataChanged(event);
                }
                catch (RuntimeException e) {
                    logger.error((Object)"DataChangeEvent dispatch failed", (Throwable)e);
                }
            }
        }
    }

    public static DataBean[] wrapSource(DataBean source) {
        DataBean[] sources = null;
        sources = source != null ? new DataBean[]{source} : new DataBean[]{};
        return sources;
    }

    public ContentType guessContentType(String name) {
        String extension;
        String typeName;
        ContentType type = null;
        if (name.lastIndexOf(".") != -1 && (typeName = this.extensionMap.get(extension = name.substring(name.lastIndexOf(".") + 1, name.length()).toLowerCase())) != null) {
            type = this.contentTypes.get(typeName);
        }
        if (type == null) {
            type = this.contentTypes.get("application/octet-stream");
        }
        return type;
    }

    public ContentType guessContentType(File file) {
        return this.guessContentType(file.getName());
    }

    public ContentType getContentType(String typeName) {
        return this.contentTypes.get(typeName);
    }

    public void plugContentType(String mimeType, boolean supported, boolean binary, String description, Icon icon, String ... extensions) {
        this.contentTypes.put(mimeType, new ContentType(mimeType, supported, binary, description, icon, extensions));
        for (String extension : extensions) {
            this.extensionMap.put(extension, mimeType);
        }
    }

    public void plugModifier(String name, Modifier modifier) {
        this.modifiers.put(name, modifier);
    }

    public void plugFeatureFactory(String name, FeatureProvider plugin) {
        logger.debug((Object)("plugged " + plugin.getClass().getSimpleName() + " at " + name));
        plugin.setName(name);
        this.factories.put(name, plugin);
    }

    public Modifier fetchModifier(String modifierName) {
        return this.modifiers.get(modifierName);
    }

    public Feature fetchFeature(String featureName, DataBean bean) {
        String bestMatch = null;
        for (String feature : this.factories.keySet()) {
            if (!featureName.startsWith(feature) || bestMatch != null && feature.length() <= bestMatch.length()) continue;
            bestMatch = feature;
        }
        FeatureProvider factory = this.factories.get(bestMatch);
        if (factory == null) {
            throw new RuntimeException("no feature factory plugged in for \"" + featureName + "\" (total of " + this.factories.size() + " factories plugged)");
        }
        logger.debug((Object)("best match for " + featureName + " was " + (factory != null ? factory.getName() : factory)));
        String namePostfix = this.getNamePostfix(featureName, factory.getName());
        return factory.createFeature(namePostfix, bean);
    }

    public DataItem findDataItem(String name) {
        return this.findDataItem(name, this.getRootFolder());
    }

    private DataItem findDataItem(String name, DataItem root) {
        DataItem matchingItem = null;
        if (root.getName().equals(name)) {
            return root;
        }
        if (root instanceof DataFolder) {
            for (DataItem child : ((DataFolder)root).getChildren()) {
                matchingItem = this.findDataItem(name, child);
                if (matchingItem == null) continue;
                return matchingItem;
            }
        }
        return null;
    }

    public DataBean getDataBean(String name) {
        for (DataBean dataBean : this.databeans()) {
            if (!dataBean.getName().equals(name)) continue;
            return dataBean;
        }
        return null;
    }

    public DataBean createDataBean(String name) throws MicroarrayException {
        File contentFile;
        try {
            contentFile = this.createNewRepositoryFile(name);
        }
        catch (IOException e) {
            throw new MicroarrayException(e);
        }
        return this.createDataBean(name, DataBean.StorageMethod.LOCAL_TEMP, null, new DataBean[0], contentFile);
    }

    public DataBean createDataBean(String name, InputStream content) throws MicroarrayException {
        return this.createDataBean(name, content, null, new DataBean[0]);
    }

    public DataBean createDataBean(String name, File contentFile) throws MicroarrayException {
        return this.createDataBean(name, DataBean.StorageMethod.LOCAL_USER, null, new DataBean[0], contentFile);
    }

    public DataBean createDataBean(String name, URL url) throws MicroarrayException {
        File contentFile;
        try {
            contentFile = new File(url.toURI());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not convert " + url + " to a file");
        }
        return this.createDataBean(name, DataBean.StorageMethod.LOCAL_USER, null, new DataBean[0], contentFile);
    }

    public DataBean createDataBean(String name, File zipFile, String zipEntryName) throws MicroarrayException {
        URL url;
        try {
            url = new URL(zipFile.toURI().toURL(), "#" + zipEntryName);
        }
        catch (MalformedURLException e) {
            throw new MicroarrayException(e);
        }
        DataBean dataBean = new DataBean(name, DataBean.StorageMethod.LOCAL_SESSION, "", url, this.guessContentType(name), new Date(), new DataBean[0], null, this, this.zipDataBeanHandler);
        this.dispatchEventIfVisible(new DataItemCreatedEvent(dataBean));
        return dataBean;
    }

    public DataBean createDataBeanFromZip(String name, URL url) throws MicroarrayException {
        DataBean dataBean = new DataBean(name, DataBean.StorageMethod.LOCAL_SESSION, "", url, this.guessContentType(name), new Date(), new DataBean[0], null, this, this.zipDataBeanHandler);
        this.dispatchEventIfVisible(new DataItemCreatedEvent(dataBean));
        return dataBean;
    }

    private DataBean createDataBean(String name, InputStream content, DataFolder folder, DataBean ... sources) throws MicroarrayException {
        File contentFile;
        try {
            contentFile = this.createNewRepositoryFile(name);
            BufferedInputStream input = new BufferedInputStream(content);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(contentFile));
            IO.copy((InputStream)input, (OutputStream)output);
            ((InputStream)input).close();
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
        }
        catch (IOException ioe) {
            throw new MicroarrayException(ioe);
        }
        DataBean bean = this.createDataBean(name, DataBean.StorageMethod.LOCAL_TEMP, folder, sources, contentFile);
        return bean;
    }

    private DataBean createDataBean(String name, DataBean.StorageMethod type, DataFolder folder, DataBean[] sources, File contentFile) throws MicroarrayException {
        URL url;
        try {
            url = contentFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MicroarrayException(e);
        }
        DataBean dataBean = new DataBean(name, type, "", url, this.guessContentType(name), new Date(), sources, folder, this, this.localFileDataBeanHandler);
        this.dispatchEventIfVisible(new DataItemCreatedEvent(dataBean));
        return dataBean;
    }

    public void loadSession(File sessionFile, boolean restoreData) {
        try {
            SessionLoader sessionLoader = new SessionLoader(sessionFile, restoreData, this);
            sessionLoader.loadSession();
        }
        catch (Exception e) {
            e.printStackTrace();
            Session.getSession().getApplication().showDialog("Opening session failed.", "Unfortunately the session could not be opened properly. Please see the details for more information.", Exceptions.getStackTrace(e), DialogInfo.Severity.WARNING, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, null);
            logger.error((Object)"loading session failed", (Throwable)e);
        }
    }

    public boolean saveSession(File sessionFile) {
        SessionSaver sessionSaver = new SessionSaver(sessionFile, this);
        boolean metadataValid = false;
        try {
            metadataValid = sessionSaver.saveSession();
        }
        catch (Exception e) {
            Session.getSession().getApplication().showDialog("Saving session failed.", "Unfortunately your session could not be saved. Please see the details for more information.\n\nIf you have important unsaved datasets in this session, it might be a good idea to export such datasets using the File -> Export functionality.", Exceptions.getStackTrace(e), DialogInfo.Severity.WARNING, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, null);
            return false;
        }
        if (!metadataValid) {
            String validationDetails = sessionSaver.getValidationErrors();
            Session.getSession().getApplication().showDialog("Problem with saving the session.", "All the datasets were saved successfully, but there were troubles with saving the session information about them. This means that there may be problems when trying to open the saved session file later on.\n\nIf you have important unsaved datasets in this session, it might be a good idea to export such datasets using the File -> Export functionality.", validationDetails, DialogInfo.Severity.WARNING, true, ChipsterDialog.DetailsVisibility.DETAILS_HIDDEN, null);
            return false;
        }
        return true;
    }

    public void saveLightweightSession(File sessionFile) throws Exception {
        SessionSaver sessionSaver = new SessionSaver(sessionFile, this);
        sessionSaver.saveLightweightSession();
    }

    public void delete(DataItem data) {
        if (data instanceof DataFolder) {
            this.deleteDataFolder((DataFolder)data);
        } else {
            this.deleteDataBean((DataBean)data);
        }
    }

    public void deleteAllDataItems() {
        this.deleteDataFolder(this.getRootFolder());
    }

    private void deleteDataBean(DataBean bean) {
        for (DataBean source : this.databeans()) {
            OperationRecord operationRecord = source.getOperationRecord();
            if (operationRecord == null) continue;
            operationRecord.removeInput(bean);
        }
        for (DataBean.Link linkType : DataBean.Link.values()) {
            for (DataBean target : bean.getLinkTargets(linkType)) {
                bean.removeLink(linkType, target);
            }
            for (DataBean source : bean.getLinkSources(linkType)) {
                source.removeLink(linkType, bean);
            }
        }
        DataFolder folder = bean.getParent();
        if (folder != null) {
            folder.removeChild(bean);
        }
        bean.delete();
    }

    public List<DataBean> databeans() {
        LinkedList<DataBean> databeans = new LinkedList<DataBean>();
        for (DataFolder folder : this.folders()) {
            for (DataItem child : folder.getChildren()) {
                if (!(child instanceof DataBean)) continue;
                databeans.add((DataBean)child);
            }
        }
        return databeans;
    }

    public List<DataFolder> folders() {
        return this.folders(this.getRootFolder());
    }

    public List<DataFolder> folders(DataFolder parent) {
        LinkedList<DataFolder> folders = new LinkedList<DataFolder>();
        folders.add(parent);
        for (DataItem child : parent.getChildren()) {
            if (!(child instanceof DataFolder)) continue;
            folders.addAll(this.folders((DataFolder)child));
        }
        return folders;
    }

    public OutputStream getContentOutputStreamAndLockDataBean(DataBean bean) throws IOException {
        bean.setContentChanged(true);
        if (!bean.getStorageMethod().equals((Object)DataBean.StorageMethod.LOCAL_TEMP)) {
            this.convertToLocalTempDataBean(bean);
        }
        return bean.getHandler().getOutputStream(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContentOutputStreamAndUnlockDataBean(DataBean bean, OutputStream out) throws MicroarrayException, IOException {
        out.close();
        ContentChangedEvent cce = new ContentChangedEvent(bean);
        this.dispatchEventIfVisible(cce);
    }

    public File getLocalFile(DataBean bean) throws IOException {
        if (!(bean.getHandler() instanceof LocalFileDataBeanHandler)) {
            this.convertToLocalTempDataBean(bean);
        }
        LocalFileDataBeanHandler handler = (LocalFileDataBeanHandler)bean.getHandler();
        return handler.getFile(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToLocalTempDataBean(DataBean bean) throws IOException {
        File newFile = this.createNewRepositoryFile(bean.getName());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
        BufferedInputStream in = new BufferedInputStream(bean.getContentByteStream());
        try {
            IOUtils.copy((InputStream)in, out);
        }
        finally {
            IOUtils.closeIfPossible(in);
            IOUtils.closeIfPossible(out);
        }
        URL newURL = newFile.toURI().toURL();
        bean.setContentUrl(newURL);
        bean.setStorageMethod(DataBean.StorageMethod.LOCAL_TEMP);
        bean.setHandler(this.localFileDataBeanHandler);
        bean.setContentChanged(true);
    }

    private void deleteDataFolder(DataFolder folder) {
        Iterable<DataItem> children = folder.getChildren();
        LinkedList<DataItem> childrenToBeRemoved = new LinkedList<DataItem>();
        for (DataItem item : children) {
            childrenToBeRemoved.add(item);
        }
        for (DataItem item : childrenToBeRemoved) {
            this.delete(item);
        }
        DataFolder parent = folder.getParent();
        if (parent != null) {
            parent.removeChild(folder);
        }
    }

    private String getNamePostfix(String featureName, String factoryName) {
        if (factoryName.length() > featureName.length()) {
            return "";
        }
        String npf = featureName.substring(factoryName.length());
        if (npf.startsWith("/")) {
            return npf.substring(1);
        }
        return npf;
    }

    public void plugTypeTag(TypeTag typeTag) {
        this.tagMap.put(typeTag.getName(), typeTag);
    }

    public TypeTag getTypeTag(String name) {
        return this.tagMap.get(name);
    }

    public Iterable<File> listAllRepositories() {
        LinkedList<File> repositories = new LinkedList<File>();
        File tempRoot = this.getTempRoot();
        for (File file : tempRoot.listFiles()) {
            String postfix;
            if (!file.isDirectory() || !file.getName().startsWith(TEMP_DIR_PREFIX) || !"".equals(postfix = file.getName().substring(TEMP_DIR_PREFIX.length())) && !Strings.isIntegerNumber(postfix)) continue;
            repositories.add(file);
        }
        return repositories;
    }

    public void flushSession() {
        this.zipDataBeanHandler.closeZipFiles();
    }
}

