/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomeBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.ChunkTreeHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageAndSNPTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.GelTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.IntensityTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadpartDataProvider;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeqBlockTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeqTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.Color;

public class ReadTrackGroup
extends TrackGroup {
    private final Color histogramColor = new Color(100, 100, 100);
    private final Color fontColor = Color.black;
    protected TitleTrack titleTrack;
    protected IntensityTrack readOverview;
    protected SeqBlockTrack reads;
    protected SeqTrack seq;
    protected IntensityTrack readOverviewReversed;
    protected SeqBlockTrack readsReversed;
    protected CoverageTrack profileTrack;
    protected CoverageAndSNPTrack profileSNPTrack;
    protected GelTrack gelTrack;
    protected SeparatorTrack sepTrackReads;
    protected SeparatorTrack sepTrackSeq;
    protected SeparatorTrack sepTrackProfile;
    protected SeparatorTrack sepTrackProfileSNP;
    protected SeparatorTrack sepTrackQualityCoverage;
    protected SeparatorTrack sepTrackGel;
    private DataSource seqFile;
    private DataSource userData;
    private ReadpartDataProvider readpartProvider;
    private Class<? extends AreaRequestHandler> userDataHandler;
    private String title;
    private boolean initialised = false;

    public ReadTrackGroup(View view, DataSource userData, Class<? extends AreaRequestHandler> userDataHandler, DataSource seqFile, String title) {
        super(view);
        this.userData = userData;
        this.readpartProvider = new ReadpartDataProvider(view, userData, userDataHandler);
        this.userDataHandler = userDataHandler;
        this.seqFile = seqFile;
        this.title = title;
    }

    public void initialise() {
        this.titleTrack = new TitleTrack(this.view, this.title, Color.black);
        this.tracks.add(this.titleTrack);
        this.addReadOverviewTrack();
        this.reads = new SeqBlockTrack(this.view, this.userData, this.readpartProvider, this.userDataHandler, this.fontColor, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        this.tracks.add(this.reads);
        this.sepTrackReads = new SeparatorTrack(this.view, Color.gray, 1, 0L, Long.MAX_VALUE);
        this.sepTrackReads.setName("Reads");
        this.tracks.add(this.sepTrackReads);
        if (this.seqFile != null) {
            this.seq = new SeqTrack(this.view, this.seqFile, ChunkTreeHandlerThread.class, GenomeBrowserConstants.SHOW_REFERENCE_AT);
            this.tracks.add(this.seq);
            this.sepTrackSeq = new SeparatorTrack(this.view, Color.gray, 1, 0L, GenomeBrowserConstants.SHOW_REFERENCE_AT);
            this.sepTrackSeq.setName("Reads");
            this.tracks.add(this.sepTrackSeq);
        }
        this.addReadOverviewReversedTrack();
        this.readsReversed = new SeqBlockTrack(this.view, this.userData, this.readpartProvider, this.userDataHandler, this.fontColor, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        this.readsReversed.setStrand(Strand.REVERSED);
        this.tracks.add(this.readsReversed);
        SeparatorTrack sepTrackReads2 = new SeparatorTrack(this.view, Color.gray, 1, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        sepTrackReads2.setName("Reads");
        this.tracks.add(sepTrackReads2);
        this.profileTrack = new CoverageTrack(this.view, this.userData, this.readpartProvider, this.userDataHandler, Color.BLACK, VisualConstants.COLOR_BLUE, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        this.profileTrack.setStrand(Strand.BOTH);
        this.tracks.add(this.profileTrack);
        this.sepTrackProfile = new SeparatorTrack(this.view, Color.gray, 1, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        this.sepTrackProfile.setName("ProfileTrack");
        this.tracks.add(this.sepTrackProfile);
        this.profileSNPTrack = new CoverageAndSNPTrack(this.view, this.userData, this.readpartProvider, this.userDataHandler, this.seqFile, ChunkTreeHandlerThread.class, Color.BLACK, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        this.profileSNPTrack.setStrand(Strand.BOTH);
        this.tracks.add(this.profileSNPTrack);
        this.sepTrackProfileSNP = new SeparatorTrack(this.view, Color.gray, 1, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        this.sepTrackProfileSNP.setName("ProfileSNPTrack");
        this.tracks.add(this.sepTrackProfileSNP);
        this.gelTrack = new GelTrack(this.view, this.userData, this.readpartProvider, this.userDataHandler, Color.WHITE, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        this.gelTrack.setStrand(Strand.BOTH);
        this.tracks.add(this.gelTrack);
        this.sepTrackGel = new SeparatorTrack(this.view, Color.gray, 1, 0L, GenomeBrowserConstants.SWITCH_VIEWS_AT);
        this.sepTrackGel.setName("GelTrack");
        this.tracks.add(this.sepTrackGel);
        this.initialised = true;
    }

    protected void addReadOverviewReversedTrack() {
        this.readOverviewReversed = new IntensityTrack(this.view, this.userData, this.userDataHandler, this.histogramColor, GenomeBrowserConstants.SWITCH_VIEWS_AT, false, true);
        this.readOverviewReversed.setStrand(Strand.REVERSED);
        this.tracks.add(this.readOverviewReversed);
    }

    protected void addReadOverviewTrack() {
        this.readOverview = new IntensityTrack(this.view, this.userData, this.userDataHandler, this.histogramColor, GenomeBrowserConstants.SWITCH_VIEWS_AT, false, true);
        this.tracks.add(this.readOverview);
    }

    public void setVisibleSNP(boolean b) {
        this.check();
        if (b) {
            this.reads.enableSNPHighlight(this.seqFile, ChunkTreeHandlerThread.class);
            this.readsReversed.enableSNPHighlight(this.seqFile, ChunkTreeHandlerThread.class);
            this.profileSNPTrack.enableSNPHighlight();
        } else {
            this.reads.disableSNPHiglight(this.seqFile);
            this.readsReversed.disableSNPHiglight(this.seqFile);
            this.profileSNPTrack.disableSNPHighlight();
        }
        this.view.fireAreaRequests();
        this.view.redraw();
    }

    @Override
    public String getName() {
        this.check();
        return "Read Track Group";
    }

    @Override
    public void showOrHide(String name, boolean state) {
        this.check();
        super.showOrHide(name, state);
        if (name.equals("highlightSNP")) {
            this.setVisibleSNP(state);
        }
    }

    private void check() {
        if (!this.initialised) {
            throw new IllegalStateException("you must call initialise() after creating this object");
        }
    }
}

