/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GenomePlot;
import fi.csc.microarray.client.visualisation.methods.gbrowser.View;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadpartDataProvider;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class GelTrack
extends Track {
    private long maxBpLength;
    private long minBpLength;
    private TreeMap<Long, Long> collector = new TreeMap();
    private Color color;
    private Color BACKGROUND = Color.WHITE;
    private ReadpartDataProvider readpartProvider;

    public GelTrack(View view, DataSource file, ReadpartDataProvider readpartProvider, Class<? extends AreaRequestHandler> handler, Color color, long minBpLength, long maxBpLength) {
        super(view, file, handler);
        this.color = color;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
        this.readpartProvider = readpartProvider;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.collector.clear();
        drawables.add(new RectDrawable(new Rectangle(0, 0, this.getView().getWidth(), this.getHeight()), this.BACKGROUND, this.BACKGROUND));
        Chromosome lastChromosome = null;
        Long maxItems = 1L;
        Iterable<ReadPart> readParts = this.readpartProvider.getReadparts(this.getStrand());
        for (ReadPart element : readParts) {
            if (!element.intersects(this.getView().getBpRegion()) || !element.isVisible()) continue;
            BpCoord startBp = element.start;
            BpCoord endBp = element.end;
            lastChromosome = element.start.chr;
            int seqLength = (int)(endBp.minus(startBp) + 1L);
            Long i = element.start.bp;
            while (i <= element.start.bp + (long)seqLength) {
                if (this.collector.containsKey(i)) {
                    maxItems = Math.max(maxItems, this.collector.get(i) + 1L);
                    this.collector.put(i, this.collector.get(i) + 1L);
                } else {
                    this.collector.put(i, 1L);
                }
                Long l = i;
                Long l2 = i = Long.valueOf(i + 1L);
            }
        }
        Iterator<Long> bpLocations = this.collector.keySet().iterator();
        if (bpLocations.hasNext()) {
            Long lastBpLocation = bpLocations.next();
            float hue = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null)[0];
            while (bpLocations.hasNext()) {
                Long currentBpLocation = bpLocations.next();
                long startX = this.getView().bpToTrack(new BpCoord(lastBpLocation, lastChromosome)).intValue();
                long endX = this.getView().bpToTrack(new BpCoord(currentBpLocation, lastChromosome)).intValue();
                float lightness = this.view.parentPlot.getReadScale() == GenomePlot.ReadScale.AUTO ? (float)this.collector.get(currentBpLocation).longValue() / (float)maxItems.longValue() : Math.min((float)this.collector.get(currentBpLocation).longValue() / (float)this.view.parentPlot.getReadScale().numReads.intValue(), 1.0f);
                if (currentBpLocation - lastBpLocation == 1L) {
                    Color c = Color.getHSBColor(hue, 0.0f, 1.0f - lightness);
                    drawables.add(new RectDrawable(new Rectangle((int)startX, 0, (int)(endX - startX), this.getHeight()), c, c));
                }
                lastBpLocation = currentBpLocation;
            }
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
    }

    @Override
    public Integer getHeight() {
        if (this.isVisible()) {
            return 16;
        }
        return 0;
    }

    @Override
    public boolean isStretchable() {
        return this.isVisible();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public Map<DataSource, Set<ColumnType>> requestedData() {
        HashMap<DataSource, Set<ColumnType>> datas = new HashMap<DataSource, Set<ColumnType>>();
        datas.put(this.file, new HashSet<ColumnType>(Arrays.asList(ColumnType.ID, ColumnType.SEQUENCE, ColumnType.STRAND)));
        return datas;
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    @Override
    public String getName() {
        return "GelTrack";
    }
}

