/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.message;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;

public class BpCoordRegion
implements Comparable<BpCoordRegion> {
    public BpCoord start;
    public BpCoord end;

    public BpCoordRegion(BpCoord start, BpCoord end) {
        this.start = start;
        this.end = end;
    }

    public BpCoordRegion(Long start, Long end, Chromosome chr) {
        this.start = new BpCoord(start, chr);
        this.end = new BpCoord(end, chr);
    }

    public BpCoordRegion(Long start, Chromosome chr1, Long end, Chromosome chr2) {
        this.start = new BpCoord(start, chr1);
        this.end = new BpCoord(end, chr2);
    }

    public BpCoordRegion() {
        this(null, null);
    }

    public BpCoordRegion(BpCoordRegion bpRegion) {
        this(new BpCoord(bpRegion.start), new BpCoord(bpRegion.end));
    }

    public Long getLength() {
        return this.end.minus(this.start);
    }

    public Long getMid() {
        return this.start.plus(this.end) / 2L;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean tsvFormat) {
        if (tsvFormat) {
            return this.start.chr + "\t" + this.start.bp + "\t" + this.end.bp;
        }
        return "Region [" + this.start + " - " + this.end + "]";
    }

    public BpCoordRegion clone() throws CloneNotSupportedException {
        return new BpCoordRegion(this.start, this.end);
    }

    @Override
    public int compareTo(BpCoordRegion o) {
        int startComparison = this.start.compareTo(o.start);
        if (startComparison != 0) {
            return startComparison;
        }
        return this.end.compareTo(o.end);
    }

    public boolean equals(Object o) {
        if (o instanceof BpCoordRegion) {
            BpCoordRegion other = (BpCoordRegion)o;
            return this.start.equals(other.start) && this.end.equals(other.end);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode();
    }

    public boolean contains(BpCoord point) {
        return this.start.chr.equals(point.chr) && point.compareTo(this.start) >= 0 && point.compareTo(this.end) < 0;
    }

    public boolean intersects(BpCoordRegion other) {
        BpCoord intersectionEnd;
        BpCoord intersectionStart = this.start.max(other.start);
        return intersectionStart.compareTo(intersectionEnd = this.end.min(other.end)) <= 0;
    }

    public BpCoordRegion intersect(BpCoordRegion other) {
        if (!this.intersects(other)) {
            throw new IllegalArgumentException("regions do not intersect");
        }
        return new BpCoordRegion(this.start.max(other.start), this.end.min(other.end));
    }

    public BpCoordRegion merge(BpCoordRegion other) {
        if (!this.intersects(other)) {
            throw new IllegalArgumentException("regions do not intersect");
        }
        return new BpCoordRegion(this.start.min(other.start), this.end.max(other.end));
    }
}

