/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import fi.csc.microarray.client.operation.parameter.StringParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringInputComponent
extends ParameterInputComponent
implements CaretListener,
DocumentListener {
    private StringParameter param;
    private JTextField field;

    protected StringInputComponent(StringParameter parameter, ParameterPanel parameterPanel) {
        super(parameterPanel);
        this.param = parameter;
        this.field = new JTextField();
        this.field.setMinimumSize(ParameterInputComponent.MINIMUM_SIZE);
        this.field.setPreferredSize(ParameterInputComponent.PREFERRED_SIZE);
        this.field.setText("" + parameter.getValue());
        this.field.addCaretListener(this);
        this.field.addFocusListener(this);
        this.field.getDocument().addDocumentListener(this);
        this.add((Component)this.field, "Center");
    }

    @Override
    public Parameter getParameter() {
        return this.param;
    }

    @Override
    public boolean inputIsValid() {
        return true;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (!this.param.isOptional() && this.field.getText().equals("")) {
            String message = "Parameter " + this.param.getID() + " is required and " + "can not be empty.";
            this.getParentPanel().setMessage(message, Color.red);
        } else {
            this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
        }
    }

    private void updateParameter() {
        this.param.setValue(this.field.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateParameter();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateParameter();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateParameter();
    }

    @Override
    public JComponent getParameterComponent() {
        return this.field;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.getParentPanel().setMessage(this.param.getDescription(), Color.black);
    }
}

