/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.messaging.message.JobMessage;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ToolDescription {
    private String id;
    private String command;
    private Object implementation;
    private String displayName;
    private String comment;
    private List<InputDescription> inputFiles = new LinkedList<InputDescription>();
    private List<OutputDescription> outputFiles = new LinkedList<OutputDescription>();
    private List<ParameterDescription> parameters = new LinkedList<ParameterDescription>();
    private String sourceCode;
    private String sadl;
    private String helpURL = null;
    private AnalysisHandler handler;
    private Map<String, String> configParameters = null;
    private File toolFile = null;
    private String initialiser;
    private Date creationTime = new Date();
    private boolean updatedSinceStartup = false;

    public ToolDescription(AnalysisHandler handler) {
        this.handler = handler;
    }

    public String getCommand() {
        return this.command;
    }

    public AnalysisJob createAnalysisJob(JobMessage message, ResultCallback resultHandler) throws AnalysisException {
        return this.handler.createAnalysisJob(message, this, resultHandler);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public List<InputDescription> getInputFiles() {
        return this.inputFiles;
    }

    public List<OutputDescription> getOutputFiles() {
        return this.outputFiles;
    }

    public Iterable<ParameterDescription> getParameters() {
        return this.parameters;
    }

    public void addParameter(ParameterDescription pd) {
        this.parameters.add(pd);
    }

    public String getInitialiser() {
        return this.initialiser;
    }

    public void setInitialiser(String initialiser) {
        this.initialiser = initialiser;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setImplementation(Object implementation) {
        this.implementation = implementation;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getID() {
        return this.id;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.id;
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void addInputFile(String fileName) {
        this.inputFiles.add(new InputDescription(fileName));
    }

    public void addOutputFile(SADLDescription.Name fileName, boolean optional) {
        this.outputFiles.add(new OutputDescription(fileName, optional));
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSADL(String sadl) {
        this.sadl = sadl;
    }

    public String getSADL() {
        if (this.sadl != null) {
            return this.sadl;
        }
        throw new RuntimeException("sadl is null");
    }

    public File getToolFile() {
        return this.toolFile;
    }

    public void setToolFile(File sourceFile) {
        this.toolFile = sourceFile;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public long getCreationTime() {
        return this.creationTime.getTime();
    }

    public boolean isUptodate() {
        return this.handler.isUptodate(this);
    }

    public AnalysisHandler getHandler() {
        return this.handler;
    }

    public boolean isUpdatedSinceStartup() {
        return this.updatedSinceStartup;
    }

    public void setUpdatedSinceStartup() {
        this.updatedSinceStartup = true;
    }

    public Map<String, String> getConfigParameters() {
        return this.configParameters;
    }

    public void setConfigParameters(Map<String, String> configParameters) {
        this.configParameters = configParameters;
    }

    public void setID(String id) {
        this.id = id;
    }

    public static class InputDescription {
        private String fileName;

        public String getFileName() {
            return this.fileName;
        }

        public InputDescription(String fileName) {
            this.fileName = fileName;
        }
    }

    public static class OutputDescription {
        private SADLDescription.Name fileName;
        private boolean optional;

        public SADLDescription.Name getFileName() {
            return this.fileName;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public OutputDescription(SADLDescription.Name fileName, boolean optional) {
            this.fileName = fileName;
            this.optional = optional;
        }
    }

    public static class ParameterDescription {
        private String name;
        private String comment;
        private boolean numeric;

        public ParameterDescription(String name, String comment, boolean numeric) {
            this.name = name;
            this.comment = comment;
            this.numeric = numeric;
        }

        public boolean isNumeric() {
            return this.numeric;
        }

        public String getComment() {
            return this.comment;
        }

        public String getName() {
            return this.name;
        }
    }
}

