/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Annotation.class.toString());
    public static final Name TYPE_VALUE = new Name("Annot");
    public static final Name SUBTYPE_LINK = new Name("Link");
    public static final Name SUBTYPE_LINE = new Name("Line");
    public static final Name SUBTYPE_SQUARE = new Name("Square");
    public static final Name SUBTYPE_CIRCLE = new Name("Circle");
    public static final Name SUBTYPE_POLYGON = new Name("Polygon");
    public static final Name SUBTYPE_POLYLINE = new Name("Polyline");
    public static final Name BORDER_STYLE_KEY = new Name("BS");
    public static final Name RECTANGLE_KEY = new Name("Rect");
    public static final Name ACTION_KEY = new Name("A");
    public static final Name PARENT_PAGE_KEY = new Name("P");
    public static final Name BORDER_KEY = new Name("Border");
    public static final Name FLAG_KEY = new Name("F");
    public static final Name COLOR_KEY = new Name("C");
    public static final Name APPEARANCE_STREAM_KEY = new Name("AP");
    public static final Name APPEARANCE_STATE_KEY = new Name("AS");
    public static final Name APPEARANCE_STREAM_NORMAL_KEY = new Name("N");
    public static final Name APPEARANCE_STREAM_ROLLOVER_KEY = new Name("R");
    public static final Name APPEARANCE_STREAM_DOWN_KEY = new Name("d");
    public static final int BORDER_HORIZONTAL_CORNER_RADIUS = 0;
    public static final int BORDER_VERTICAL_CORNER_RADIUS = 1;
    public static final int BORDER_WIDTH = 2;
    public static final int BORDER_DASH = 3;
    public static final int VISIBLE_RECTANGLE = 1;
    public static final int INVISIBLE_RECTANGLE = 0;
    protected Name subtype = (Name)this.getObject(SUBTYPE_KEY);
    protected BorderStyle borderStyle;
    protected Vector<Number> border;
    protected Color color;
    protected Rectangle2D.Float userSpaceRectangle;
    protected boolean canDrawBorder = !SUBTYPE_LINE.equals(this.subtype) && !SUBTYPE_CIRCLE.equals(this.subtype) && !SUBTYPE_SQUARE.equals(this.subtype) && !SUBTYPE_POLYGON.equals(this.subtype) && !SUBTYPE_POLYLINE.equals(this.subtype);

    public static Annotation buildAnnotation(Library library, Hashtable hashTable) {
        Annotation annot = null;
        Name subtype = (Name)hashTable.get(SUBTYPE_KEY);
        if (subtype != null && subtype.equals(SUBTYPE_LINK)) {
            annot = new LinkAnnotation(library, hashTable);
        }
        if (annot == null) {
            annot = new Annotation(library, hashTable);
        }
        return annot;
    }

    public Annotation(Library l, Hashtable h) {
        super(l, h);
        Object borderObject;
        Hashtable BS = (Hashtable)this.getObject(BORDER_STYLE_KEY);
        if (BS != null) {
            this.borderStyle = new BorderStyle(this.library, BS);
        }
        if ((borderObject = this.getObject(BORDER_KEY)) != null && borderObject instanceof Vector) {
            this.border = (Vector)borderObject;
        }
        this.color = Color.black;
        Vector C = (Vector)this.getObject(COLOR_KEY);
        if (C != null && C.size() >= 3) {
            float red = ((Number)C.get(0)).floatValue();
            float green = ((Number)C.get(1)).floatValue();
            float blue = ((Number)C.get(2)).floatValue();
            red = Math.max(0.0f, Math.min(1.0f, red));
            green = Math.max(0.0f, Math.min(1.0f, green));
            blue = Math.max(0.0f, Math.min(1.0f, blue));
            this.color = new Color(red, green, blue);
        }
    }

    public String getSubType() {
        return this.library.getName(this.entries, SUBTYPE_KEY.getName());
    }

    public Rectangle2D.Float getUserSpaceRectangle() {
        Object tmp;
        if (this.userSpaceRectangle == null && (tmp = this.getObject(RECTANGLE_KEY)) instanceof Vector) {
            this.userSpaceRectangle = this.library.getRectangle(this.entries, RECTANGLE_KEY.getName());
        }
        return this.userSpaceRectangle;
    }

    public void setUserSpaceRectangle(Rectangle2D.Float rect) {
        if (this.userSpaceRectangle != null) {
            this.userSpaceRectangle = new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height);
            this.getEntries().put(RECTANGLE_KEY, PRectangle.getPRectangleVector(this.userSpaceRectangle));
        }
    }

    public Action getAction() {
        Object tmp = this.library.getDictionary(this.entries, ACTION_KEY.getName());
        if (tmp != null && tmp instanceof Hashtable) {
            Action action = Action.buildAction(this.library, (Hashtable)tmp);
            if (action != null && this.library.isReference(this.entries, ACTION_KEY.getName())) {
                action.setPObjectReference(this.library.getReference(this.entries, ACTION_KEY.getName()));
            }
            return action;
        }
        tmp = this.getObject(ACTION_KEY);
        if (tmp != null && tmp instanceof Action) {
            return (Action)tmp;
        }
        return null;
    }

    public Action addAction(Action action) {
        boolean isDestKey;
        if (action.getPObjectReference() == null) {
            logger.severe("Addition of action was rejected null Object reference " + action);
            return null;
        }
        StateManager stateManager = this.library.getStateManager();
        boolean bl = isDestKey = this.getObject(LinkAnnotation.DESTINATION_KEY) != null;
        if (this.getObject(ACTION_KEY) != null) {
            boolean isReference = this.library.isReference(this.getEntries(), ACTION_KEY.toString());
            if (isReference) {
                Action oldAction = (Action)action.getObject(ACTION_KEY);
                oldAction.setDeleted(true);
                stateManager.addChange(new PObject(oldAction, oldAction.getPObjectReference()));
            } else {
                this.getEntries().remove(ACTION_KEY);
                stateManager.addChange(new PObject(this, this.getPObjectReference()));
            }
        }
        this.getEntries().put(ACTION_KEY, action.getPObjectReference());
        stateManager.addChange(new PObject(this, this.getPObjectReference()));
        if (isDestKey && this instanceof LinkAnnotation) {
            this.getEntries().remove(LinkAnnotation.DESTINATION_KEY);
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
        }
        action.setNew(true);
        stateManager.addChange(new PObject(action, action.getPObjectReference()));
        this.library.addObject(action, action.getPObjectReference());
        return action;
    }

    public boolean deleteAction(Action action) {
        Action currentAction;
        StateManager stateManager = this.library.getStateManager();
        if (this.getObject(ACTION_KEY) != null && (currentAction = this.getAction()).similar(action)) {
            this.getEntries().remove(ACTION_KEY);
            currentAction.setDeleted(true);
            stateManager.addChange(new PObject(currentAction, currentAction.getPObjectReference()));
            stateManager.addChange(new PObject(this, this.getPObjectReference()));
            return true;
        }
        return false;
    }

    public boolean updateAction(Action action) {
        StateManager stateManager = this.library.getStateManager();
        if (this.getObject(ACTION_KEY) != null) {
            Action currentAction = this.getAction();
            if (!currentAction.similar(action)) {
                stateManager.addChange(new PObject(action, action.getPObjectReference()));
                currentAction.setDeleted(true);
                stateManager.addChange(new PObject(currentAction, currentAction.getPObjectReference()));
            }
            this.getEntries().put(ACTION_KEY, action.getPObjectReference());
            stateManager.addChange(new PObject(action, action.getPObjectReference()));
            return true;
        }
        return false;
    }

    public boolean allowScreenNormalMode() {
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return false;
        }
        return !this.getFlagNoView();
    }

    public boolean allowScreenRolloverMode() {
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return false;
        }
        if (this.getFlagNoView() && !this.getFlagToggleNoView()) {
            return false;
        }
        return !this.getFlagReadOnly();
    }

    public boolean allowScreenDownMode() {
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return false;
        }
        if (this.getFlagNoView() && !this.getFlagToggleNoView()) {
            return false;
        }
        return !this.getFlagReadOnly();
    }

    public boolean allowPrintNormalMode() {
        return this.allowScreenOrPrintRenderingOrInteraction() && this.getFlagPrint();
    }

    public boolean allowAlterProperties() {
        return !this.getFlagLocked();
    }

    public void setBorderStyle(BorderStyle borderStyle) {
        this.borderStyle = borderStyle;
        this.entries.put(BORDER_STYLE_KEY, this.borderStyle);
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public Vector<Number> getBorder() {
        return this.border;
    }

    public Annotation getParentAnnotation() {
        Annotation parent = null;
        Object ob = this.getObject("Parent");
        if (ob instanceof Reference) {
            ob = this.library.getObject((Reference)ob);
        }
        if (ob instanceof Annotation) {
            parent = (Annotation)ob;
        } else if (ob instanceof Hashtable) {
            parent = Annotation.buildAnnotation(this.library, (Hashtable)ob);
        }
        return parent;
    }

    public Page getPage() {
        Annotation annot;
        Page page = (Page)this.getObject(PARENT_PAGE_KEY);
        if (page == null && (annot = this.getParentAnnotation()) != null) {
            page = annot.getPage();
        }
        return page;
    }

    public int getLinkType() {
        if (this.borderStyle != null ? this.borderStyle.getStrokeWidth() > 0.0f : this.border != null && this.border.size() >= 3 && this.border.get(2).floatValue() > 0.0f) {
            return 1;
        }
        return 0;
    }

    public String getLineStyle() {
        if (this.borderStyle != null) {
            return this.borderStyle.getBorderStyle();
        }
        if (this.border != null) {
            if (this.border.size() > 3) {
                return "D";
            }
            if (this.border.get(2).floatValue() > 1.0f) {
                return "S";
            }
        }
        return "S";
    }

    public float getLineThickness() {
        if (this.borderStyle != null) {
            return this.borderStyle.getStrokeWidth();
        }
        if (this.border != null && this.border.size() >= 3) {
            return this.border.get(2).floatValue();
        }
        return 0.0f;
    }

    public boolean isBorder() {
        Vector borderProps;
        boolean borderWidth = false;
        Object border = this.getObject(BORDER_KEY);
        if (border != null && border instanceof Vector && (borderProps = (Vector)border).size() == 3) {
            borderWidth = ((Number)borderProps.get(2)).floatValue() > 0.0f;
        }
        return this.getBorderStyle() != null || borderWidth;
    }

    public void render(Graphics2D origG, int renderHintType, float totalRotation, float userZoom, boolean tabSelected) {
        double scaleY;
        boolean noZoom;
        if (!this.allowScreenOrPrintRenderingOrInteraction()) {
            return;
        }
        if (renderHintType == 1 && !this.allowScreenNormalMode()) {
            return;
        }
        if (renderHintType == 2 && !this.allowPrintNormalMode()) {
            return;
        }
        Rectangle2D.Float rect = this.getUserSpaceRectangle();
        AffineTransform oldAT = origG.getTransform();
        Shape oldClip = origG.getClip();
        Graphics2D g = origG;
        AffineTransform at = new AffineTransform(oldAT);
        at.translate(rect.getMinX(), rect.getMinY());
        boolean noRotate = this.getFlagNoRotate();
        if (noRotate) {
            float unRotation;
            for (unRotation = -totalRotation; unRotation < 0.0f; unRotation += 360.0f) {
            }
            while (unRotation > 360.0f) {
                unRotation -= 360.0f;
            }
            if (unRotation == -0.0f) {
                unRotation = 0.0f;
            }
            if ((double)unRotation != 0.0) {
                double radians = Math.toRadians(unRotation);
                AffineTransform rotationTransform = AffineTransform.getRotateInstance(radians);
                Point2D.Double origTopLeftCorner = new Point2D.Double(0.0, Math.abs(rect.getHeight()));
                Point2D rotatedTopLeftCorner = rotationTransform.transform(origTopLeftCorner, null);
                at.translate(origTopLeftCorner.getX() - rotatedTopLeftCorner.getX(), origTopLeftCorner.getY() - rotatedTopLeftCorner.getY());
                at.rotate(radians);
            }
        }
        if ((noZoom = this.getFlagNoZoom()) && (scaleY = Math.abs(at.getScaleY())) != 1.0) {
            double scaleX = Math.abs(at.getScaleX());
            double rectHeight = Math.abs(rect.getHeight());
            double resizedY = rectHeight * ((scaleY - 1.0) / scaleY);
            at.translate(0.0, resizedY);
            at.scale(1.0 / scaleX, 1.0 / scaleY);
        }
        g.setTransform(at);
        Shape preAppearanceStreamClip = g.getClip();
        g.clip(this.deriveDrawingRectangle());
        this.renderAppearanceStream(g);
        g.setTransform(at);
        g.setClip(preAppearanceStreamClip);
        if (tabSelected) {
            this.renderBorderTabSelected(g);
        } else {
            this.renderBorder(g);
        }
        g.setTransform(oldAT);
        g.setClip(oldClip);
    }

    protected void renderAppearanceStream(Graphics2D g) {
        Object AP = this.getObject(APPEARANCE_STREAM_KEY);
        if (AP instanceof Hashtable) {
            Object AS;
            Object N = this.library.getObject((Hashtable)AP, APPEARANCE_STREAM_NORMAL_KEY.getName());
            if (N instanceof Hashtable && (AS = this.getObject(APPEARANCE_STATE_KEY)) != null) {
                N = this.library.getObject((Hashtable)N, AS.toString());
            }
            if (N instanceof Form) {
                Form form = (Form)N;
                form.init();
                AffineTransform matrix = form.getMatrix();
                Rectangle2D bbox = form.getBBox();
                Rectangle2D tBbox = matrix.createTransformedShape(bbox).getBounds2D();
                Rectangle2D.Float rect = this.getUserSpaceRectangle();
                AffineTransform tAs = AffineTransform.getScaleInstance(((RectangularShape)rect).getWidth() / tBbox.getWidth(), ((RectangularShape)rect).getHeight() / tBbox.getHeight());
                tAs.concatenate(matrix);
                g.transform(tAs);
                Shapes shapes = form.getShapes();
                shapes.paint(g);
            }
        }
    }

    protected void renderBorder(Graphics2D g) {
        BorderStyle bs;
        Color borderColor = this.getColor();
        if (borderColor != null) {
            g.setColor(borderColor);
        }
        if ((bs = this.getBorderStyle()) != null) {
            float width = bs.getStrokeWidth();
            if (width > 0.0f && borderColor != null && this.canDrawBorder) {
                Rectangle2D.Float jrect = this.deriveBorderDrawingRectangle(width);
                if (bs.isStyleSolid()) {
                    g.setStroke(new BasicStroke(width));
                    g.draw(jrect);
                } else if (bs.isStyleDashed()) {
                    BasicStroke stroke = new BasicStroke(width, 0, 0, 10.0f, bs.getDashArray(), 0.0f);
                    g.setStroke(stroke);
                    g.draw(jrect);
                } else if (bs.isStyleBeveled()) {
                    jrect = this.deriveDrawingRectangle();
                    g.setStroke(new BasicStroke(1.0f));
                    g.setColor(BorderStyle.LIGHT);
                    Line2D.Double line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMaxY() - 1.0, jrect.getMaxX() - 2.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMinY() + 2.0, jrect.getMinX() + 1.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                    g.setColor(BorderStyle.LIGHTEST);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMaxY() - 2.0, jrect.getMaxX() - 3.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMinY() + 3.0, jrect.getMinX() + 2.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    g.setColor(BorderStyle.DARK);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMinY() + 2.0, jrect.getMaxX() - 2.0, jrect.getMinY() + 2.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMaxX() - 2.0, jrect.getMinY() + 2.0, jrect.getMaxX() - 2.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    g.setColor(BorderStyle.DARKEST);
                    line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMinY() + 1.0, jrect.getMaxX() - 1.0, jrect.getMinY() + 1.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMaxX() - 1.0, jrect.getMinY() + 1.0, jrect.getMaxX() - 1.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                } else if (bs.isStyleInset()) {
                    jrect = this.deriveDrawingRectangle();
                    g.setStroke(new BasicStroke(1.0f));
                    g.setColor(BorderStyle.DARK);
                    Line2D.Double line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMaxY() - 1.0, jrect.getMaxX() - 1.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMinX() + 1.0, jrect.getMinY() + 1.0, jrect.getMinX() + 1.0, jrect.getMaxY() - 1.0);
                    g.draw(line);
                    g.setColor(BorderStyle.DARKEST);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMaxY() - 2.0, jrect.getMaxX() - 2.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMinY() + 2.0, jrect.getMinX() + 2.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                    g.setColor(BorderStyle.LIGHTEST);
                    line = new Line2D.Double(jrect.getMinX() + 3.0, jrect.getMinY() + 2.0, jrect.getMaxX() - 2.0, jrect.getMinY() + 2.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMaxX() - 2.0, jrect.getMinY() + 2.0, jrect.getMaxX() - 2.0, jrect.getMaxY() - 3.0);
                    g.draw(line);
                    g.setColor(BorderStyle.LIGHT);
                    line = new Line2D.Double(jrect.getMinX() + 2.0, jrect.getMinY() + 1.0, jrect.getMaxX() - 1.0, jrect.getMinY() + 1.0);
                    g.draw(line);
                    line = new Line2D.Double(jrect.getMaxX() - 1.0, jrect.getMinY() + 1.0, jrect.getMaxX() - 1.0, jrect.getMaxY() - 2.0);
                    g.draw(line);
                } else if (bs.isStyleUnderline()) {
                    g.setStroke(new BasicStroke(width));
                    Line2D.Double line = new Line2D.Double(jrect.getMinX(), jrect.getMinY(), jrect.getMaxX(), jrect.getMinY());
                    g.draw(line);
                }
            }
        } else {
            Vector borderVector = (Vector)this.getObject(BORDER_KEY);
            if (borderVector != null) {
                if (borderColor != null) {
                    float horizRadius = 0.0f;
                    float vertRadius = 0.0f;
                    float width = 1.0f;
                    float[] dashArray = null;
                    if (borderVector.size() >= 1) {
                        horizRadius = ((Number)borderVector.get(0)).floatValue();
                    }
                    if (borderVector.size() >= 2) {
                        vertRadius = ((Number)borderVector.get(1)).floatValue();
                    }
                    if (borderVector.size() >= 3) {
                        width = ((Number)borderVector.get(2)).floatValue();
                    }
                    if (borderVector.size() >= 4) {
                        Object dashObj = borderVector.get(3);
                        if (dashObj instanceof Number) {
                            width = 0.0f;
                        } else if (dashObj instanceof Vector) {
                            Vector dashVector = (Vector)borderVector.get(3);
                            int sz = dashVector.size();
                            dashArray = new float[sz];
                            for (int i = 0; i < sz; ++i) {
                                Number num = (Number)dashVector.get(i);
                                dashArray[i] = num.floatValue();
                            }
                        }
                    }
                    if (width > 0.0f) {
                        Rectangle2D.Float jrect = this.deriveBorderDrawingRectangle(width);
                        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(jrect.getX(), jrect.getY(), jrect.getWidth(), jrect.getHeight(), horizRadius, vertRadius);
                        BasicStroke stroke = new BasicStroke(width, 0, 0, 10.0f, dashArray, 0.0f);
                        g.setStroke(stroke);
                        g.draw(roundRect);
                    }
                }
            } else if (borderColor != null && SUBTYPE_LINK.equals(this.subtype)) {
                float width = 1.0f;
                Rectangle2D.Float jrect = this.deriveBorderDrawingRectangle(width);
                g.setStroke(new BasicStroke(width));
                g.draw(jrect);
            }
        }
    }

    protected void renderBorderTabSelected(Graphics2D g) {
        float width = 1.0f;
        Rectangle2D.Float jrect = this.deriveBorderDrawingRectangle(width);
        g.setColor(Color.black);
        float[] dashArray = new float[]{2.0f};
        BasicStroke stroke = new BasicStroke(width, 0, 0, 10.0f, dashArray, 0.0f);
        g.setStroke(stroke);
        g.draw(jrect);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = new Color(color.getRGB());
        float[] compArray = new float[3];
        this.color.getColorComponents(compArray);
        Vector<Float> colorValues = new Vector<Float>(3);
        colorValues.add(Float.valueOf(compArray[0]));
        colorValues.add(Float.valueOf(compArray[1]));
        colorValues.add(Float.valueOf(compArray[2]));
        this.entries.put(COLOR_KEY, colorValues);
    }

    private Rectangle2D.Float deriveDrawingRectangle() {
        Rectangle2D.Float origRect = this.getUserSpaceRectangle();
        Rectangle2D.Float jrect = new Rectangle2D.Float(origRect.x, origRect.y, origRect.width, origRect.height);
        jrect.x = 0.0f;
        jrect.y = 0.0f;
        return jrect;
    }

    private Rectangle2D.Float deriveBorderDrawingRectangle(float borderWidth) {
        Rectangle2D.Float jrect = this.deriveDrawingRectangle();
        float halfBorderWidth = borderWidth / 2.0f;
        double minX = jrect.getMinX() + (double)halfBorderWidth;
        double minY = jrect.getMinY() + (double)halfBorderWidth;
        double maxX = jrect.getMaxX() - (double)halfBorderWidth;
        double maxY = jrect.getMaxY() - (double)halfBorderWidth;
        jrect.setFrameFromDiagonal(minX, minY, maxX, maxY);
        return jrect;
    }

    protected boolean allowScreenOrPrintRenderingOrInteraction() {
        if (this.getFlagHidden()) {
            return false;
        }
        return !this.getFlagInvisible() || !this.isSupportedAnnotationType();
    }

    protected boolean isSupportedAnnotationType() {
        return true;
    }

    public boolean getFlagInvisible() {
        return (this.getInt(FLAG_KEY.getName()) & 1) != 0;
    }

    public boolean getFlagHidden() {
        return (this.getInt(FLAG_KEY.getName()) & 2) != 0;
    }

    public boolean getFlagPrint() {
        return (this.getInt(FLAG_KEY.getName()) & 4) != 0;
    }

    public boolean getFlagNoZoom() {
        return (this.getInt(FLAG_KEY.getName()) & 8) != 0;
    }

    public boolean getFlagNoRotate() {
        return (this.getInt(FLAG_KEY.getName()) & 0x10) != 0;
    }

    public boolean getFlagNoView() {
        return (this.getInt(FLAG_KEY.getName()) & 0x20) != 0;
    }

    public boolean getFlagReadOnly() {
        return (this.getInt(FLAG_KEY.getName()) & 0x40) != 0;
    }

    public boolean getFlagLocked() {
        return (this.getInt(FLAG_KEY.getName()) & 0x80) != 0;
    }

    public boolean getFlagToggleNoView() {
        return (this.getInt(FLAG_KEY.getName()) & 0x100) != 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ANNOTATION= {");
        Enumeration keys = this.entries.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = this.entries.get(key);
            sb.append(key.toString());
            sb.append('=');
            if (value == null) {
                sb.append("null");
            } else if (value instanceof StringObject) {
                sb.append(((StringObject)value).getDecryptedLiteralString(this.library.securityManager));
            } else {
                sb.append(value.toString());
            }
            sb.append(',');
        }
        sb.append('}');
        if (this.getPObjectReference() != null) {
            sb.append("  ");
            sb.append(this.getPObjectReference());
        }
        for (int i = sb.length() - 1; i >= 0; --i) {
            if (sb.charAt(i) >= ' ' && sb.charAt(i) < '\u007f') continue;
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }
}

