/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.parser.Ajax;
import org.emboss.jemboss.programs.RunEmbossApplication2;
import org.emboss.jemboss.server.AppendToLogFileThread;

public class JembossAuthServer {
    private String tmproot = new String("/data/sandbox/");
    private final String logFile = new String(this.tmproot + "/jemboss.log");
    private final String errorLog = new String(this.tmproot + "/jemboss_error.log");
    private final String fs = new String(System.getProperty("file.separator"));
    private final String ps = new String(System.getProperty("path.separator"));
    private final String ls = System.getProperty("line.separator");
    final JembossParams jp = new JembossParams();
    final String plplot = this.jp.getPlplot();
    final String embossData = this.jp.getEmbossData();
    final String embossBin = this.jp.getEmbossBin();
    final String embossPath = this.embossBin + this.ps + this.jp.getEmbossPath();
    private final String[] env = new String[]{"PATH=" + this.embossPath, "PLPLOT_LIB=" + this.plplot, "EMBOSS_DATA=" + this.embossData};
    private final String environ = "PATH=" + this.embossPath + " " + "PLPLOT_LIB=" + this.plplot + " " + "EMBOSS_DATA=" + this.embossData + " " + this.jp.getEmbossEnvironment();

    public Vector show_acd(String string) {
        Vector<String> vector = new Vector<String>(4);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = new String(this.jp.getAcdDirToParse() + string + ".acd");
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("#") || string3.equals("")) continue;
                string3 = string3.trim();
                string3 = string3.replace('}', ')');
                stringBuffer.append(string3 + "\n");
            }
        }
        catch (IOException iOException) {
            this.appendToLogFile("Cannot open EMBOSS acd file " + string2, this.errorLog);
        }
        vector.add("status");
        vector.add("0");
        vector.add("acd");
        vector.add(stringBuffer.toString());
        return vector;
    }

    public Vector getWossname() {
        String[] stringArray = this.jp.getEmbossEnvironmentArray(this.env);
        Vector<String> vector = new Vector<String>(4);
        String string = new String(this.embossBin + "wossname -colon -gui -auto");
        RunEmbossApplication2 runEmbossApplication2 = new RunEmbossApplication2(string, stringArray, null);
        runEmbossApplication2.waitFor();
        vector.add("status");
        vector.add(runEmbossApplication2.getStatus());
        vector.add("wossname");
        vector.add(runEmbossApplication2.getProcessStdout());
        return vector;
    }

    public Vector show_help(String string) {
        String[] stringArray = this.jp.getEmbossEnvironmentArray(this.env);
        String string2 = this.embossBin.concat("tfm " + string + " -html -nomore");
        RunEmbossApplication2 runEmbossApplication2 = new RunEmbossApplication2(string2, stringArray, null);
        runEmbossApplication2.waitFor();
        String string3 = runEmbossApplication2.getProcessStdout();
        if (string3.equals("")) {
            string3 = "No help available for this application.";
        }
        Vector<String> vector = new Vector<String>(2);
        vector.add("helptext");
        vector.add(string3);
        return vector;
    }

    public Vector call_ajax(String string, String string2, String string3, byte[] byArray) {
        Ajax ajax = new Ajax();
        Vector<Object> vector = new Vector<Object>(8);
        if (!this.verifyUser(ajax, string3, byArray, vector)) {
            vector.trimToSize();
            return vector;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string.startsWith(this.fs)) {
            int n = string.lastIndexOf(this.fs);
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + 1).trim();
            boolean bl3 = ajax.listFiles(string3, byArray, this.environ, string4);
            if (!bl3) {
                return this.returnError(ajax, "listFiles error in call_ajax");
            }
            if (ajax.getOutStd().indexOf(string5 + "\n") > -1) {
                bl2 = true;
            }
        }
        String string6 = null;
        if (!(string.indexOf(":") >= 0 && string.indexOf("\n") <= 0 || bl2)) {
            try {
                string6 = this.tmproot + this.fs + string3 + this.fs + ".jembosstmp";
                boolean bl4 = ajax.putFile(string3, byArray, this.environ, string6, string.getBytes());
                if (!bl4) {
                    return this.returnError(ajax, "putFile error in call_ajax");
                }
                bl = true;
            }
            catch (Exception exception) {
                this.appendToLogFile("Exception: call_ajax creating " + string6, this.errorLog);
                vector.add("status");
                vector.add("1");
                vector.trimToSize();
                return vector;
            }
        } else {
            string6 = string;
        }
        if (bl2 || bl || string6.indexOf(":") > 0) {
            boolean bl5 = false;
            try {
                bl5 = string2.startsWith("seqset") ? ajax.seqsetAttrib(string3, byArray, this.environ, string6) : ajax.seqAttrib(string3, byArray, this.environ, string6);
                if (!bl5) {
                    return this.returnError(ajax, "seqAttrib or seqsetAttrib error");
                }
            }
            catch (Exception exception) {
                this.appendToLogFile("Exception: call_ajax status not ok", this.errorLog);
                vector.add("status");
                vector.add("1");
                vector.trimToSize();
                return vector;
            }
        }
        if (bl) {
            ajax.delFile(string3, byArray, this.environ, string6);
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        vector.add("length");
        vector.add(new Integer(ajax.length_soap));
        vector.add("protein");
        vector.add(new Boolean(ajax.protein_soap));
        vector.add("weight");
        vector.add(new Float(ajax.weight_soap));
        vector.add("status");
        vector.add("0");
        return vector;
    }

    public Vector call_ajax(String string, String string2) {
        Object object;
        boolean bl = false;
        String string3 = null;
        File file = null;
        Vector<Object> vector = new Vector<Object>(8);
        if (!(string.indexOf(":") >= 0 && string.indexOf("\n") <= 0 || new File(string).exists())) {
            bl = true;
            try {
                File file2 = new File(this.tmproot);
                file = File.createTempFile("tmp", ".jembosstmp", file2);
                object = new PrintWriter(new FileWriter(file));
                ((PrintWriter)object).println(string);
                ((PrintWriter)object).close();
                string3 = new String(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                this.appendToLogFile("IOException: call_ajax creating tmp.jembosstmp", this.errorLog);
                vector.add("status");
                vector.add("1");
                vector.trimToSize();
                return vector;
            }
        } else {
            string3 = string;
        }
        boolean bl2 = false;
        object = null;
        if (new File(string3).exists() || string3.indexOf(":") > 0) {
            try {
                object = new Ajax();
                bl2 = string2.startsWith("seqset") ? object.seqsetType(string3) : object.seqType(string3);
            }
            catch (Exception exception) {
                this.appendToLogFile("Exception: call_ajax status not ok", this.errorLog);
                vector.add("status");
                vector.add("1");
                vector.trimToSize();
                return vector;
            }
        }
        if (bl2) {
            vector.add("length");
            vector.add(new Integer(Ajax.length));
            vector.add("protein");
            vector.add(new Boolean(Ajax.protein));
            vector.add("weight");
            vector.add(new Float(Ajax.weight));
            vector.add("status");
            vector.add("0");
        } else {
            this.appendToLogFile("Error: call_ajax status not ok", this.errorLog);
            vector.add("status");
            vector.add("1");
            vector.trimToSize();
        }
        if (bl) {
            file.delete();
        }
        return vector;
    }

    public Vector show_db() {
        int n;
        String[] stringArray = this.jp.getEmbossEnvironmentArray(this.env);
        Vector<String> vector = new Vector<String>(8);
        String string = new String(this.embossBin + "showdb -auto");
        RunEmbossApplication2 runEmbossApplication2 = new RunEmbossApplication2(string, stringArray, null);
        runEmbossApplication2.waitFor();
        vector.add("status");
        vector.add(runEmbossApplication2.getStatus());
        if (!runEmbossApplication2.getStatus().equals("0")) {
            vector.trimToSize();
            return vector;
        }
        vector.add("showdb");
        vector.add(runEmbossApplication2.getProcessStdout());
        String[] stringArray2 = new File(this.embossData).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                return !file2.isDirectory();
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuffer.append(stringArray2[n] + "\n");
        }
        vector.add("matrices");
        vector.add(stringBuffer.toString());
        stringArray2 = new File(this.embossData + this.fs + "CODONS").list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                return !file2.isDirectory();
            }
        });
        stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuffer.append(stringArray2[n] + "\n");
        }
        vector.add("codons");
        vector.add(stringBuffer.toString());
        return vector;
    }

    public synchronized Vector run_prog(String string, String string2, Vector vector, String string3, byte[] byArray) {
        String string4;
        this.tmproot = this.tmproot.concat(string3 + this.fs);
        Ajax ajax = new Ajax();
        Vector vector2 = new Vector(6, 1);
        if (!this.verifyUser(ajax, string3, byArray, vector2)) {
            return vector2;
        }
        if (string.indexOf(";") > -1) {
            String string5 = new String("ERROR: Disallowed command syntax " + string);
            this.appendToLogFile(string5, this.errorLog);
            vector2.add("msg");
            vector2.add(string5);
            vector2.add("status");
            vector2.add("1");
            vector2.trimToSize();
            return vector2;
        }
        int n = string.indexOf(" stdout ");
        if (n > -1) {
            String string6 = string.substring(0, n + 7);
            string4 = string.substring(n + 8);
            string = string6.concat("file ");
            string = string.concat(string4);
        }
        boolean bl = false;
        try {
            ajax.setErrStd();
            bl = ajax.listDirs(string3, byArray, this.environ, this.tmproot);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            try {
                ajax.setErrStd();
                bl = ajax.makeDir(string3, byArray, this.environ, this.tmproot);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                this.appendToLogFile("Created directory " + this.tmproot, this.errorLog);
            } else {
                string4 = new String("Failed to create dir " + this.tmproot + "\nSTDERR :" + ajax.getErrStd());
                this.appendToLogFile(string4, this.errorLog);
                vector2.add("msg");
                vector2.add(string4);
                vector2.add("status");
                vector2.add("1");
                vector2.trimToSize();
                return vector2;
            }
        }
        string4 = string.substring(0, string.indexOf(" "));
        Random random = new Random();
        String string7 = new Date().toString();
        string7 = string7.replace(':', '_');
        String string8 = new String(this.tmproot + string4 + "_" + string7.replace(' ', '_') + "_" + random.nextInt(99999));
        try {
            ajax.setErrStd();
            bl = ajax.makeDir(string3, byArray, this.environ, string8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            return this.returnError(ajax, "run_prog failed to create dir " + string8);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EMBOSS run details for ");
        stringBuffer.append(string4);
        stringBuffer.append(this.ls);
        stringBuffer.append(this.ls);
        stringBuffer.append("Parameters Used: ");
        stringBuffer.append(string);
        stringBuffer.append(this.ls);
        stringBuffer.append("Started: ");
        stringBuffer.append(string7);
        stringBuffer.append(this.ls);
        stringBuffer.append(this.ls);
        stringBuffer.append("Input files:");
        stringBuffer.append(this.ls);
        Vector<String> vector3 = new Vector<String>();
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            String string9 = (String)object.nextElement();
            vector3.add(string9);
            stringBuffer.append(string8);
            stringBuffer.append(this.fs);
            stringBuffer.append(string9);
            stringBuffer.append(this.ls);
            bl = false;
            try {
                ajax.setErrStd();
                bl = ajax.putFile(string3, byArray, this.environ, new String(string8 + this.fs + string9), (byte[])object.nextElement());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) continue;
            return this.returnError(ajax, "Failed to make file " + string8 + this.fs + string9);
        }
        bl = false;
        try {
            ajax.setErrStd();
            bl = ajax.putFile(string3, byArray, this.environ, new String(string8 + this.fs + ".desc"), stringBuffer.toString().getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            return this.returnError(ajax, "Failed to make file " + string8 + this.fs + ".desc");
        }
        new AppendToLogFileThread(string2 + " " + string7 + " " + string, this.logFile, true).start();
        vector2.add("cmd");
        vector2.add(string);
        vector2.add("status");
        vector2.add("0");
        object = new File(string8);
        if (string2.toLowerCase().indexOf("interactive") > -1) {
            bl = true;
            try {
                ajax.setErrStd();
                bl = ajax.forkEmboss(string3, byArray, this.environ, string, string8);
            }
            catch (Exception exception) {
                // empty catch block
            }
            vector2.add("msg");
            vector2.add(ajax.getErrStd());
            try {
                ajax.setErrStd();
                bl = ajax.putFile(string3, byArray, this.environ, new String(string8 + this.fs + ".finished"), new Date().toString().getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                return this.returnError(ajax, "putFile error in run_prog");
            }
            vector2 = this.loadFilesContent(ajax, string3, byArray, (File)object, string8, vector2, vector3);
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
        } else {
            boolean bl2 = ajax.forkBatch(string3, byArray, this.environ, string, string8);
            vector2.add("msg");
            vector2.add("");
            vector2.add("job_submitted");
            vector2.add("Job " + ((File)object).getName() + "submitted.");
            vector2.add("jobid");
            vector2.add(((File)object).getName());
            vector2.add("description");
            vector2.add(stringBuffer + this.ls + "Application pending" + this.ls);
        }
        return vector2;
    }

    private String quoteMe(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals(" ")) continue;
            stringBuffer.append("\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" ");
        }
        return stringBuffer.toString();
    }

    private void runAsPBSBatch(Ajax ajax, String string, byte[] byArray, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#PBS -j oe\n");
        stringBuffer.append("#PBS -S /bin/sh\n");
        stringBuffer.append(this.environ.replace(' ', '\n'));
        stringBuffer.append("\nexport PATH\n");
        stringBuffer.append("export PLPLOT_LIB\n");
        stringBuffer.append("export EMBOSS_DATA\n");
        stringBuffer.append("cd " + string2 + "\n" + string3 + "\n");
        stringBuffer.append("date > " + string2 + "/.finished\n");
        String string4 = new String(string2 + this.fs + ".scriptfile");
        boolean bl = false;
        try {
            bl = ajax.putFile(string, byArray, this.environ, string4, stringBuffer.toString().getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            this.appendToLogFile("Failed to make file " + string2 + this.fs + ".scriptfile\n" + "STDERR " + ajax.getErrStd() + "\n" + "STDOUT " + ajax.getOutStd(), this.errorLog);
        }
        boolean bl2 = true;
        try {
            String string5 = "/hgmp/local/openpbs/bin/qsub " + string4;
            bl2 = ajax.forkEmboss(string, byArray, this.environ, string5, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl2 || !ajax.getErrStd().equals("")) {
            this.appendToLogFile("Fork batch process failed " + string3, this.errorLog);
        }
    }

    private void runAsGNQSBatch(Ajax ajax, String string, byte[] byArray, String string2, String string3) {
        String string4 = "#QSUB -q jemboss-queue\n";
        string4 = string4.concat("#QSUB -s /bin/sh\n");
        string4 = string4.concat("#QSUB -eo -o report.nqs\n");
        string4 = string4.concat(this.environ.replace(' ', '\n'));
        string4 = string4.concat("\nexport PATH\n");
        string4 = string4.concat("export PLPLOT_LIB\n");
        string4 = string4.concat("export EMBOSS_DATA\n");
        string4 = string4.concat("cd " + string2 + "\n" + string3 + "\n");
        string4 = string4.concat("date > " + string2 + "/.finished\n");
        String string5 = new String(string2 + this.fs + ".scriptfile");
        boolean bl = false;
        try {
            bl = ajax.putFile(string, byArray, this.environ, string5, string4.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            this.appendToLogFile("Failed to make file " + string2 + this.fs + ".scriptfile", this.errorLog);
            this.appendToLogFile("STDERR " + ajax.getErrStd(), this.errorLog);
            this.appendToLogFile("STDOUT " + ajax.getOutStd(), this.errorLog);
        }
        boolean bl2 = true;
        try {
            String string6 = "/hgmp/local/nqs/bin/qsub " + string5;
            bl2 = ajax.forkEmboss(string, byArray, this.environ, string6, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl2 || !ajax.getErrStd().equals("")) {
            this.appendToLogFile("Fork batch process failed " + string3, this.errorLog);
        }
    }

    private void runAsBatch(Ajax ajax, String string, byte[] byArray, String string2, String string3) {
        String string4 = "#!/bin/sh\n";
        string4 = string4.concat(this.environ.replace(' ', '\n'));
        string4 = string4.concat("\nexport PATH\n");
        string4 = string4.concat("export PLPLOT_LIB\n");
        string4 = string4.concat("export EMBOSS_DATA\n");
        string4 = string4.concat("cd " + string2 + "\n" + string3 + "\n");
        string4 = string4.concat("date > " + string2 + "/.finished\n");
        boolean bl = false;
        try {
            bl = ajax.putFile(string, byArray, this.environ, new String(string2 + this.fs + ".scriptfile"), string4.getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            this.appendToLogFile("Failed to make file " + string2 + this.fs + ".scriptfile", this.errorLog);
            this.appendToLogFile("STDERR " + ajax.getErrStd(), this.errorLog);
            this.appendToLogFile("STDOUT " + ajax.getOutStd(), this.errorLog);
        }
        boolean bl2 = true;
        try {
            String string5 = "/bin/batchQueue.sh " + string2 + "/.scriptfile ";
            bl2 = ajax.forkEmboss(string, byArray, this.environ, string5, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl2 || !ajax.getErrStd().equals("")) {
            this.appendToLogFile("Fork batch process failed " + string3, this.errorLog);
        }
    }

    public Vector show_saved_results(String string, String string2, String string3, byte[] byArray) {
        Object object;
        Ajax ajax = new Ajax();
        Vector vector = new Vector();
        if (!this.verifyUser(ajax, string3, byArray, vector)) {
            return vector;
        }
        string = this.tmproot.concat(string3 + this.fs + string);
        if (string2.equals("")) {
            object = new File(string);
            vector = this.loadFilesContent(ajax, string3, byArray, (File)object, string, vector, null);
        } else {
            object = null;
            try {
                object = ajax.getFile(string3, byArray, this.environ, string + this.fs + string2);
                vector.add(string2);
                vector.add(new String((byte[])object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        vector.add("status");
        vector.add("0");
        vector.add("msg");
        vector.add("OK");
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return vector;
    }

    public Vector save_project_file(String string, String string2, String string3, String string4, byte[] byArray) {
        Ajax ajax = new Ajax();
        Vector<String> vector = new Vector<String>(4);
        if (!this.verifyUser(ajax, string4, byArray, vector)) {
            vector.trimToSize();
            return vector;
        }
        String string5 = this.tmproot + this.fs + string4 + this.fs + string + this.fs + string2;
        boolean bl = ajax.putFile(string4, byArray, this.environ, string5, string3.getBytes());
        vector.add("status");
        vector.add("0");
        vector.add("msg");
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        if (!bl) {
            return this.returnError(ajax, "Failed to save file " + string5);
        }
        vector.add("OK");
        return vector;
    }

    public Vector delete_saved_results(String string, String string2, String string3, byte[] byArray) {
        Ajax ajax = new Ajax();
        Vector<String> vector = new Vector<String>(4);
        if (!this.verifyUser(ajax, string3, byArray, vector)) {
            vector.trimToSize();
            return vector;
        }
        this.tmproot = this.tmproot.concat(string3 + this.fs);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = this.tmproot.concat(stringTokenizer.nextToken());
            boolean bl = ajax.delDir(string3, byArray, this.environ, string4);
            if (bl && ajax.getErrStd().equals("")) continue;
            return this.returnError(ajax, "Failed deletion of directory " + string4);
        }
        vector.add("status");
        vector.add("0");
        vector.add("msg");
        vector.add("Results deleted successfully.");
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return vector;
    }

    public Vector list_saved_results(String string, byte[] byArray) {
        Ajax ajax = new Ajax();
        Vector<String> vector = new Vector<String>();
        if (!this.verifyUser(ajax, string, byArray, vector)) {
            return vector;
        }
        this.tmproot = this.tmproot.concat(string + this.fs);
        vector.add("status");
        vector.add("0");
        vector.add("msg");
        vector.add("OK");
        ajax.setErrStd();
        boolean bl = ajax.listDirs(string, byArray, this.environ, this.tmproot);
        String string2 = ajax.getOutStd();
        int n = 0;
        int n2 = 0;
        while ((n2 = string2.indexOf("\n", n)) > -1) {
            String string3 = string2.substring(n, n2);
            n = n2 + 1;
            vector.add(string3);
            byte[] byArray2 = ajax.getFile(string, byArray, this.environ, this.tmproot + string3 + this.fs + ".desc");
            vector.add(new String(byArray2));
            if (ajax.getFileok() == 1) continue;
            this.appendToLogFile("Calling getFile : " + this.tmproot + string3 + this.fs + ".desc\n" + "STDERR " + ajax.getErrStd() + "\n" + "STDOUT " + ajax.getOutStd(), this.errorLog);
        }
        vector.add("list");
        vector.add(string2);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToLogFile(String string, String string2) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string2, true));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            System.out.println("Error writing to log file " + this.logFile);
            exception.printStackTrace();
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Vector loadFilesContent(Ajax ajax, String string, byte[] byArray, File file, String string2, Vector vector, Vector vector2) {
        boolean bl = false;
        try {
            bl = ajax.listFiles(string, byArray, this.environ, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            this.appendToLogFile("Failed loadFilesContent\nSTDERR " + ajax.getErrStd() + "\n" + "STDOUT " + ajax.getOutStd(), this.errorLog);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(ajax.getOutStd(), "\n");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (vector2 != null && vector2.contains(string3)) continue;
            byte[] byArray2 = null;
            try {
                byArray2 = ajax.getFile(string, byArray, this.environ, string2 + this.fs + string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ajax.getFileok() == 1) {
                vector.add(string3);
                vector.add(byArray2);
                continue;
            }
            this.appendToLogFile("Cannot getFile " + string2 + this.fs + string3, this.errorLog);
        }
        return vector;
    }

    public Vector update_result_status(String string, String string2, Vector vector, String string3, byte[] byArray) {
        Ajax ajax = new Ajax();
        Vector<String> vector2 = new Vector<String>();
        if (!this.verifyUser(ajax, string3, byArray, vector2)) {
            return vector2;
        }
        this.tmproot = this.tmproot.concat(string3 + this.fs);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            enumeration.nextElement();
            try {
                ajax.getFile(string3, byArray, this.environ, this.tmproot + string4 + this.fs + ".finished");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ajax.getErrStd().indexOf("stat error") == -1 && ajax.getFileok() == 1) {
                vector2.add(string4);
                vector2.add("complete");
                byte[] byArray2 = ajax.getFile(string3, byArray, this.environ, this.tmproot + this.fs + string4 + this.fs + ".desc");
                if (ajax.getFileok() != 1) continue;
                vector2.add(string4 + "-description");
                vector2.add(new String(byArray2));
                continue;
            }
            vector2.add(string4);
            vector2.add("pending");
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return vector2;
    }

    private boolean verifyUser(Ajax ajax, String string, byte[] byArray, Vector vector) {
        if (string == null || byArray == null) {
            vector.add("msg");
            vector.add("Failed Authorisation ");
            vector.add("status");
            vector.add("1");
            return false;
        }
        boolean bl = false;
        try {
            bl = ajax.userAuth(string, byArray, this.environ);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            this.appendToLogFile("Failed Authorisation " + string + "\n" + "STDERR " + ajax.getErrStd(), this.errorLog);
            vector.add("msg");
            vector.add("Failed Authorisation " + string);
            vector.add("status");
            vector.add("1");
            return false;
        }
        return true;
    }

    private Vector returnError(Ajax ajax, String string) {
        this.appendToLogFile("STDERR " + ajax.getErrStd() + "\n" + "STDOUT " + ajax.getOutStd() + "\n" + "MSG    " + string, this.errorLog);
        Vector<String> vector = new Vector<String>(4);
        vector.add("msg");
        vector.add(ajax.getErrStd());
        vector.add("status");
        vector.add("1");
        return vector;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

