/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debug
implements InterceptStrategy {
    private final Debugger debugger;

    public Debug(Debugger debugger) {
        this.debugger = debugger;
    }

    @Override
    public Processor wrapProcessorInInterceptors(CamelContext context, final ProcessorDefinition<?> definition, final Processor target, Processor nextTarget) throws Exception {
        return new DelegateAsyncProcessor(target){

            public boolean process(final Exchange exchange, final AsyncCallback callback) {
                Debug.this.debugger.beforeProcess(exchange, target, definition);
                final StopWatch watch = new StopWatch();
                return super.process(exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                        long diff = watch.stop();
                        Debug.this.debugger.afterProcess(exchange, processor, definition, diff);
                        callback.done(doneSync);
                    }
                });
            }

            public String toString() {
                return "Debug[" + target + "]";
            }
        };
    }
}

