/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileIdempotentRepository
implements IdempotentRepository<String> {
    private static final transient Log LOG = LogFactory.getLog(FileIdempotentRepository.class);
    private static final String STORE_DELIMITER = "\n";
    private Map<String, Object> cache;
    private File fileStore;
    private long maxFileStoreSize = 1024000L;
    private AtomicBoolean init = new AtomicBoolean();

    public FileIdempotentRepository() {
        this.cache = new LRUCache<String, Object>(1000);
    }

    public FileIdempotentRepository(File fileStore, Map<String, Object> set) {
        this.fileStore = fileStore;
        this.cache = set;
    }

    public static IdempotentRepository<String> fileIdempotentRepository(File fileStore) {
        return FileIdempotentRepository.fileIdempotentRepository(fileStore, 1000);
    }

    public static IdempotentRepository<String> fileIdempotentRepository(File fileStore, int cacheSize) {
        return FileIdempotentRepository.fileIdempotentRepository(fileStore, new LRUCache<String, Object>(cacheSize));
    }

    public static IdempotentRepository<String> fileIdempotentRepository(File fileStore, int cacheSize, long maxFileStoreSize) {
        FileIdempotentRepository repository = new FileIdempotentRepository(fileStore, new LRUCache<String, Object>(cacheSize));
        repository.setMaxFileStoreSize(maxFileStoreSize);
        return repository;
    }

    public static IdempotentRepository<String> fileIdempotentRepository(File store, Map<String, Object> cache) {
        return new FileIdempotentRepository(store, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String messageId) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.init.compareAndSet(false, true)) {
                this.loadStore();
            }
            if (this.cache.containsKey(messageId)) {
                return false;
            }
            this.cache.put(messageId, messageId);
            if (this.fileStore.length() < this.maxFileStoreSize) {
                this.appendToStore(messageId);
            } else {
                this.trunkStore();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String key) {
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.init.compareAndSet(false, true)) {
                this.loadStore();
            }
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) {
        boolean answer;
        Map<String, Object> map = this.cache;
        synchronized (map) {
            if (this.init.compareAndSet(false, true)) {
                this.loadStore();
            }
            answer = this.cache.remove(key) != null;
            this.trunkStore();
        }
        return answer;
    }

    @Override
    public boolean confirm(String key) {
        return true;
    }

    public File getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(File fileStore) {
        this.fileStore = fileStore;
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    public void setCache(Map<String, Object> cache) {
        this.cache = cache;
    }

    public long getMaxFileStoreSize() {
        return this.maxFileStoreSize;
    }

    public void setMaxFileStoreSize(long maxFileStoreSize) {
        this.maxFileStoreSize = maxFileStoreSize;
    }

    public void setCacheSize(int size) {
        if (this.cache != null) {
            this.cache.clear();
        }
        this.cache = new LRUCache<String, Object>(size);
    }

    protected void appendToStore(String messageId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Appending " + messageId + " to idempotent filestore: " + this.fileStore));
        }
        FileOutputStream fos = null;
        try {
            if (!this.fileStore.exists()) {
                this.fileStore.createNewFile();
            }
            fos = new FileOutputStream(this.fileStore, true);
            fos.write(messageId.getBytes());
            fos.write(STORE_DELIMITER.getBytes());
        }
        catch (IOException e) {
            try {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            catch (Throwable throwable) {
                IOHelper.close(fos, "Appending to file idempotent repository", LOG);
                throw throwable;
            }
        }
        IOHelper.close(fos, "Appending to file idempotent repository", LOG);
    }

    protected void trunkStore() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Trunking idempotent filestore: " + this.fileStore));
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.fileStore);
            for (String key : this.cache.keySet()) {
                fos.write(key.getBytes());
                fos.write(STORE_DELIMITER.getBytes());
            }
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        finally {
            IOHelper.close(fos, "Trunking file idempotent repository", LOG);
        }
    }

    protected void loadStore() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Loading to 1st level cache from idempotent filestore: " + this.fileStore));
        }
        if (!this.fileStore.exists()) {
            return;
        }
        this.cache.clear();
        Scanner scanner = null;
        try {
            scanner = new Scanner(this.fileStore);
            scanner.useDelimiter(STORE_DELIMITER);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                this.cache.put(line, line);
            }
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + this.cache.size() + " to the 1st level cache from idempotent filestore: " + this.fileStore));
        }
    }
}

