/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.FailOverLoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="failover")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FailoverLoadBalancerDefinition
extends LoadBalancerDefinition {
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlAttribute
    private Boolean roundRobin = Boolean.FALSE;
    @XmlAttribute
    private Integer maximumFailoverAttempts;

    @Override
    protected LoadBalancer createLoadBalancer(RouteContext routeContext) {
        FailOverLoadBalancer answer;
        if (!this.exceptions.isEmpty()) {
            ArrayList classes = new ArrayList();
            for (String name : this.exceptions) {
                Class<?> type = routeContext.getCamelContext().getClassResolver().resolveClass(name);
                if (type == null) {
                    throw new IllegalArgumentException("Cannot find class: " + name + " in the classpath");
                }
                classes.add(type);
            }
            answer = new FailOverLoadBalancer(classes);
        } else {
            answer = new FailOverLoadBalancer();
        }
        if (this.getMaximumFailoverAttempts() != null) {
            answer.setMaximumFailoverAttempts(this.getMaximumFailoverAttempts());
        }
        if (this.isRoundRobin() != null) {
            answer.setRoundRobin(this.isRoundRobin());
        }
        return answer;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public Boolean isRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(Boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public Integer getMaximumFailoverAttempts() {
        return this.maximumFailoverAttempts;
    }

    public void setMaximumFailoverAttempts(Integer maximumFailoverAttempts) {
        this.maximumFailoverAttempts = maximumFailoverAttempts;
    }

    public String toString() {
        return "FailoverLoadBalancer";
    }
}

