# ANALYSIS Visualisation/"Volcano plot from existing results" (Plots a Volcano plot from results of a statistical
# test. A suitable output for this tool can be generated by running a two-group or a several-group statistical test
# or a linear model using empiricalBayes.)
# INPUT GENE_EXPRS normalized.tsv OUTPUT volcanoP.pdf
# PARAMETER fold.change.column COLUMN_SEL (Column that contains the fold change values)
# PARAMETER p.value.column COLUMN_SEL (Column that contains the p-values)
# PARAMETER image.width INTEGER FROM 200 TO 3200 DEFAULT 600 (Width of the plotted network image)
# PARAMETER image.height INTEGER FROM 200 TO 3200 DEFAULT 600 (Height of the plotted network image)


# Volcano plot from existing results
# JTT 8.11.2007
# modified MG 21.9.2009

# Parameter settings (default) for testing purposes
#fold.change.column<-"FC"
#p.value.column<-"p.adjusted"
#image.width<-600
#image.height<-600

# Renaming variables
w<-image.width
h<-image.height

# Loads the normalized data
file<-c("normalized.tsv")
dat<-read.table(file, header=T, sep="\t", row.names=1)

# Sanity checks
if(fold.change.column=="empty") {
   stop("CHIPSTER-NOTE: You haven't selected a column for fold change! Tool cannot be executed.")
}
if(p.value.column=="empty") {
   stop("CHIPSTER-NOTE: You haven't selected a column for p-value! Tool cannot be executed.")
}
if(sum(grep("p.adjusted", colnames(dat)))==0) {
   stop("CHIPSTER-NOTE: You don't have any P-value columns in the dataset! Please run some statistical test first.")
}

# Extracts the data
expression<-dat[,grep(fold.change.column, colnames(dat))]
pvalues<-dat[,grep(p.value.column, colnames(dat))]

# Plotting
pdf(file="volcanoP.pdf", width=w/72, height=h/72)
plot(expression, -log10(pvalues), xlim=c(-max(expression), max(expression)), main="Volcano plot", pch=19, xlab="log2 (fold change)", ylab="-log10 (p)")
dev.off()

