/* ======================================================================= 
 * A visualisation library extension for JFreeChart. Please see JFreeChart
 * for further information.
 * =======================================================================
 * Copyright (C) 2006  University of Helsinki, Department of Computer Science
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * -----------------------------
 * Contact:  ohtu@cs.helsinki.fi
 * -----------------------------
 *
 */

package org.jfree.chart.entity;

import org.jfree.chart.entity.ChartEntity;
import java.awt.Shape;

/**
 * A chart entity for heatmapblocks used in {@link org.jfree.chart.plot.HCPlot}.
 * @author  viski project
 */
public class HeatMapBlockEntity extends ChartEntity {

    /** The row this entity is at in the data matrix. */
    private int row;
    /** The column this entity is at in the data matrix. */
    private int column;


    /**
     * Creates a new entity.
     *
     * @param area  the area.
     * @param toolTipText  the tool tip text.
     * @param urlText  the URL text for HTML imagemaps.
     * @param row  the row.
     * @param column  the column.
     */
    public HeatMapBlockEntity(Shape area, 
                         String toolTipText, 
                         String urlText,
			 int row,
			 int column) {

        super(area, toolTipText, urlText);
	this.row = row;
	this.column = column;

    }

    /**
     * Returns the row of an entity.
     *
     * @return  The row.
     */
    public int getRow() {

	return this.row;

    }

    /**
     * Returns the column of an entity.
     *
     * @return  The column.
     */    
    public int getColumn() {

	return this.column;

    }

}
