/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileUtil {
    private static final transient Log LOG = LogFactory.getLog(FileUtil.class);
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;

    private FileUtil() {
    }

    public static String normalizePath(String path) {
        if (path != null && FileUtil.isWindows() && path.indexOf(47) >= 0) {
            return path.replace('/', '\\');
        }
        return path;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtil.createTempFile(prefix, suffix, null);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        File parent;
        File file = parent = parentDir == null ? FileUtil.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "camel";
        } else if (prefix.length() < 3) {
            prefix = prefix + "camel";
        }
        parent.mkdirs();
        return File.createTempFile(prefix, suffix, parent);
    }

    public static String stripLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static String stripFirstLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static String stripTrailingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.endsWith("/") || name.endsWith(File.separator)) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static String stripPath(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        if (pos == -1) {
            pos = name.lastIndexOf(File.separator);
        }
        if (pos != -1) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static String stripExt(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    public static String onlyPath(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(47);
        if (pos == -1) {
            pos = name.lastIndexOf(File.separator);
        }
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return null;
    }

    public static String compactPath(String path) {
        String[] parts;
        if (path == null) {
            return null;
        }
        if (path.indexOf("..") == -1) {
            return path;
        }
        if (path.indexOf(File.separator) == -1) {
            return path;
        }
        Stack<String> stack = new Stack<String>();
        String separatorRegex = File.separator;
        if (FileUtil.isWindows()) {
            separatorRegex = "\\\\";
        }
        for (String part : parts = path.split(separatorRegex)) {
            if (part.equals("..") && !stack.isEmpty()) {
                stack.pop();
                continue;
            }
            stack.push(part);
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = stack.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(File.separator);
        }
        return sb.toString();
    }

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s = System.getProperty("java.io.tmpdir");
        File checkExists = new File(s);
        if (!checkExists.exists()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
        }
        Random ran = new Random();
        int x = ran.nextInt(1000000);
        File f = new File(s, "camel-tmp-" + x);
        while (!f.mkdir()) {
            x = ran.nextInt(1000000);
            f = new File(s, "camel-tmp-" + x);
        }
        defaultTempDir = f;
        Thread hook = new Thread(){

            public void run() {
                FileUtil.removeDir(defaultTempDir);
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
        return defaultTempDir;
    }

    private static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (String s : list) {
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtil.removeDir(f);
                continue;
            }
            FileUtil.delete(f);
        }
        FileUtil.delete(d);
    }

    private static void delete(File f) {
        if (!f.delete()) {
            if (FileUtil.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    public static boolean renameFile(File from, File to) {
        int count;
        if (!from.exists()) {
            return false;
        }
        boolean renamed = false;
        for (count = 0; !renamed && count < 3; ++count) {
            if (LOG.isDebugEnabled() && count > 0) {
                LOG.debug((Object)("Retrying attempt " + count + " to rename file from: " + from + " to: " + to));
            }
            if ((renamed = from.renameTo(to)) || count <= 0) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (LOG.isDebugEnabled() && count > 0) {
            LOG.debug((Object)("Tried " + count + " to rename file: " + from + " to: " + to + " with result: " + renamed));
        }
        return renamed;
    }

    public static boolean deleteFile(File file) {
        int count;
        if (!file.exists()) {
            return false;
        }
        boolean deleted = false;
        for (count = 0; !deleted && count < 3; ++count) {
            if (LOG.isDebugEnabled() && count > 0) {
                LOG.debug((Object)("Retrying attempt " + count + " to delete file: " + file));
            }
            if ((deleted = file.delete()) || count <= 0) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (LOG.isDebugEnabled() && count > 0) {
            LOG.debug((Object)("Tried " + count + " to delete file: " + file + " with result: " + deleted));
        }
        return deleted;
    }

    public static boolean isAbsolute(File file) {
        String path;
        if (FileUtil.isWindows() && (path = file.getPath()).startsWith(File.separator)) {
            return true;
        }
        return file.isAbsolute();
    }
}

