/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.StringUtils;

public class ClassUtils {
    private static final boolean ALLOW_ALL;
    private static final HashSet ALLOWED_CLASS_NAMES;
    private static final String[] ALLOWED_CLASS_NAME_PREFIXES;

    private ClassUtils() {
    }

    public static Class loadSystemClass(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public static Class loadUserClass(String string) throws SQLException {
        if (!ALLOW_ALL && !ALLOWED_CLASS_NAMES.contains(string)) {
            boolean bl = false;
            for (int i = 0; i < ALLOWED_CLASS_NAME_PREFIXES.length; ++i) {
                String string2 = ALLOWED_CLASS_NAME_PREFIXES[i];
                if (!string.startsWith(string2)) continue;
                bl = true;
            }
            if (!bl) {
                throw Message.getSQLException(90134, string);
            }
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Message.getSQLException(90086, new String[]{string}, classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw Message.getSQLException(90086, new String[]{string}, noClassDefFoundError);
        }
    }

    static {
        ALLOWED_CLASS_NAMES = new HashSet();
        String string = SysProperties.ALLOWED_CLASSES;
        String[] stringArray = StringUtils.arraySplit(string, ',', true);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("*")) {
                bl = true;
                continue;
            }
            if (string2.endsWith("*")) {
                arrayList.add(string2.substring(0, string2.length() - 1));
                continue;
            }
            ALLOWED_CLASS_NAMES.add(string2);
        }
        ALLOW_ALL = bl;
        ALLOWED_CLASS_NAME_PREFIXES = new String[arrayList.size()];
        arrayList.toArray(ALLOWED_CLASS_NAME_PREFIXES);
    }
}

