/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.apache.activemq.MessageAvailableListener;
import org.apache.activemq.web.AjaxWebClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.continuation.Continuation;

public class AjaxListener
implements MessageAvailableListener {
    private static final Log LOG = LogFactory.getLog(AjaxListener.class);
    private long maximumReadTimeout;
    private AjaxWebClient client;
    private long lastAccess;
    private Continuation continuation;

    AjaxListener(AjaxWebClient client, long maximumReadTimeout) {
        this.client = client;
        this.maximumReadTimeout = maximumReadTimeout;
    }

    public void access() {
        this.lastAccess = System.currentTimeMillis();
    }

    public synchronized void setContinuation(Continuation continuation) {
        this.continuation = continuation;
    }

    public synchronized void onMessageAvailable(MessageConsumer consumer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("message for " + consumer + "continuation=" + this.continuation));
        }
        if (this.continuation != null) {
            try {
                Message message = consumer.receive(10L);
                this.continuation.setAttribute("message", (Object)message);
                this.continuation.setAttribute("consumer", (Object)consumer);
            }
            catch (Exception e) {
                LOG.error((Object)("Error receiving message " + e), (Throwable)e);
            }
            this.continuation.resume();
        } else if (System.currentTimeMillis() - this.lastAccess > 2L * this.maximumReadTimeout) {
            new Thread(){

                public void run() {
                    AjaxListener.this.client.closeConsumers();
                }
            }.start();
        }
    }
}

