/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class AdvancedStringTokenizer
implements Iterable<String>,
Iterator<String> {
    private List<String> tokens = new LinkedList<String>();
    int index = -1;
    private int inputStringLength;

    public AdvancedStringTokenizer(String string) {
        this(string, true, false, " \t\n\r\f");
    }

    public AdvancedStringTokenizer(String string, boolean trim, boolean groupHyphenated) {
        this(string, trim, groupHyphenated, " \t\n\r\f");
    }

    public AdvancedStringTokenizer(String string, boolean trim, boolean groupHyphenated, String delim) {
        StringTokenizer st = new StringTokenizer(string, delim);
        this.inputStringLength = string.length();
        while (st.hasMoreTokens()) {
            String token = trim ? st.nextToken().trim() : st.nextToken();
            this.tokens.add(token);
        }
        if (groupHyphenated) {
            List<String> originalTokens = this.tokens;
            this.tokens = new LinkedList<String>();
            for (int i = 0; i < originalTokens.size(); ++i) {
                if (!originalTokens.get(i).startsWith("\"")) {
                    this.tokens.add(originalTokens.get(i));
                    continue;
                }
                String groupedToken = "";
                while (!originalTokens.get(i).endsWith("\"")) {
                    groupedToken = groupedToken + originalTokens.get(i) + " ";
                    ++i;
                }
                groupedToken = groupedToken + originalTokens.get(i);
                this.tokens.add(groupedToken.substring(1, groupedToken.length() - 1));
            }
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.tokens.size();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new RuntimeException("tokeniser error: no tokens left (there were " + this.tokens.size() + " tokens in input string of length " + this.inputStringLength + ")");
        }
        return this.tokens.get(++this.index);
    }

    public String peek() {
        return this.tokens.get(this.index + 1);
    }

    public String current() {
        return this.tokens.get(this.index);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

