/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.config;

import fi.csc.microarray.config.ConfigTool;
import fi.csc.microarray.util.IOUtils;
import fi.csc.microarray.util.Strings;
import fi.csc.microarray.util.XmlUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpgradeTool {
    private LinkedList<Operation> operations = new LinkedList();

    public void upgrade(File pathToOld, int fromMajor, int toMajor) throws Exception {
        boolean needConfigure = false;
        if (fromMajor == 2 && toMajor == 3) {
            System.out.println("Upgrading from version 1.2.x to version 1.3.x");
            this.createOperationsFrom12xTo13x(pathToOld);
        } else if (fromMajor == 3 && toMajor == 4) {
            System.out.println("Upgrading from version 1.3.x to version 1.4.x");
            this.createOperationsFrom13xTo14x(pathToOld);
        } else if (fromMajor == 4 && toMajor == 4) {
            System.out.println("Migrating from version 1.4.x to version 1.4.x");
            needConfigure = true;
            this.createOperationsFrom13xTo14x(pathToOld);
        } else {
            throw new IllegalArgumentException("unknown major version " + toMajor);
        }
        for (Operation operation : this.operations) {
            System.out.println(operation.describeExecution(operation.file, operation.parameter));
        }
        System.out.println("");
        ConfigTool.verifyChanges(new BufferedReader(new InputStreamReader(System.in)));
        for (Operation operation : this.operations) {
            try {
                operation.execute(operation.file, operation.parameter);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\nError occurred, continuing anyway...");
            }
        }
        System.out.println("\nAll changes successfully written!");
        if (needConfigure) {
            System.out.println("\nYou need to configure the new installation (run configure.sh)");
        }
        System.out.println("\nYou need to regenerate server passwords (run genpasswd.sh)");
    }

    public void createOperationsFrom13xTo14x(File pathToOld) throws SAXException, IOException, ParserConfigurationException {
        for (String componentDir : ConfigTool.getComponentDirsWithConfig()) {
            if (!new File(pathToOld, componentDir).exists()) continue;
            File componentDir13x = new File(pathToOld, componentDir);
            File componentDir14x = new File(componentDir);
            if (!componentDir14x.exists()) {
                throw new RuntimeException(componentDir14x.getAbsolutePath() + " not found, must be run inside complete 1.4.x installation");
            }
            File logsDir13x = new File(componentDir13x, "logs");
            File confDir13x = new File(componentDir13x, "conf");
            File securityDir13x = new File(componentDir13x, "security");
            File webroot13x = new File(componentDir13x, "web-root");
            File logsDir14x = new File(componentDir14x, "logs");
            File confDir14x = new File(componentDir14x, "conf");
            File securityDir14x = new File(componentDir14x, "security");
            File webroot14x = new File(componentDir14x, "web-root");
            this.copyToNewDir(logsDir13x, logsDir14x, "chipster.log", "messages.log", "jobs.log", "security.log", "status.log");
            this.copyToNewDir(securityDir13x, securityDir14x, "keystore.ks", "users");
            this.copyToNewDir(confDir13x, confDir14x, "chipster-config.xml");
            this.copyToNewDir(webroot13x, webroot14x, "chipster.jnlp", "chipster-config.xml");
        }
    }

    public void createOperationsFrom12xTo13x(File pathToOld) throws SAXException, IOException, ParserConfigurationException {
        for (String componentDir : ConfigTool.getComponentDirsWithConfig()) {
            if (!new File(pathToOld, componentDir).exists()) continue;
            File componentDir12x = new File(pathToOld, componentDir);
            File componentDir13x = new File(componentDir);
            if (!componentDir13x.exists()) {
                throw new RuntimeException(componentDir13x.getAbsolutePath() + " not found, must be run inside complete 1.3.x installation");
            }
            File workDir12x = new File(componentDir12x, "nami-work-files");
            File logsDir13x = new File(componentDir13x, "logs");
            File confDir13x = new File(componentDir13x, "conf");
            File securityDir13x = new File(componentDir13x, "security");
            this.copyToNewDir(workDir12x, logsDir13x, "messages.log", "jobs.log", "security.log", "status.log");
            this.delayedCopy(new File(workDir12x, "nami.log"), new File(logsDir13x, "chipster.log"));
            this.copyToNewDir(workDir12x, securityDir13x, "keystore.ks", "users");
            this.delayedUsersUpgrade(new File(securityDir13x, "users"), new File(workDir12x, "users"));
            this.delayedCopy(new File(workDir12x, "nami-config.xml"), new File(confDir13x, "chipster-config.xml"));
            this.delayedConfigPurge(new File(confDir13x, "chipster-config.xml"), new File(workDir12x, "nami-config.xml"), componentDir);
            if (componentDir.equals("comp")) {
                this.delayedRCommandCopy(new File(workDir12x, "nami-config.xml"), new File(confDir13x, "runtimes.xml"));
            }
            if (!componentDir.equals("webstart")) continue;
            this.delayedCopy(new File(componentDir12x, "web-content" + File.separator + "chipster.jnlp"), new File(componentDir13x, "web-root" + File.separator + "chipster.jnlp"));
            this.delayedJnlpUpgrade(new File(componentDir13x, "web-root" + File.separator + "chipster.jnlp"), new File(componentDir12x, "web-content" + File.separator + "chipster.jnlp"));
            this.delayedCopy(new File(workDir12x, "nami-config.xml"), new File(componentDir13x, "web-root" + File.separator + "chipster-config.xml"));
            this.delayedConfigPurge(new File(componentDir13x, "web-root" + File.separator + "chipster-config.xml"), new File(workDir12x, "nami-config.xml"), "client");
        }
    }

    private void copyToNewDir(File oldDir, File newDir, String ... files) {
        for (String file : files) {
            File from = new File(oldDir, file);
            File to = new File(newDir, file);
            this.delayedCopy(from, to);
        }
    }

    private void delayedCopy(File from, File to) {
        if (from.exists()) {
            this.operations.add(new Operation(from, to){

                @Override
                public String describeExecution(File file, Object parameter) {
                    return "Copy " + file + " to " + parameter;
                }

                @Override
                public void execute(File file, Object parameter) {
                    try {
                        IOUtils.copy(file, (File)parameter);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private void delayedUsersUpgrade(File fileAfterUpgrade, File filebeforeUpgrade) {
        if (filebeforeUpgrade.exists()) {
            this.operations.add(new Operation(fileAfterUpgrade, null){

                @Override
                public String describeExecution(File file, Object parameter) {
                    return "Updgrade file format in " + file + " (add empty expiration dates if needed)";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(File file, Object parameter) {
                    block8: {
                        BufferedReader in = null;
                        FileOutputStream overwriteOut = null;
                        try {
                            StringWriter stringWriter = new StringWriter();
                            BufferedWriter out = new BufferedWriter(stringWriter);
                            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                            boolean needOverwrite = false;
                            String line = in.readLine();
                            while (line != null) {
                                if (line.split(":").length == 3) {
                                    String newLine;
                                    int commentSep = line.lastIndexOf(58);
                                    line = newLine = line.substring(0, commentSep) + ":" + line.substring(commentSep);
                                    needOverwrite = true;
                                }
                                out.write(line + "\n");
                                line = in.readLine();
                            }
                            out.close();
                            if (needOverwrite) {
                                overwriteOut = new FileOutputStream(file);
                                IOUtils.copy(new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes()), overwriteOut);
                            }
                            IOUtils.closeIfPossible(in);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            System.out.println("Warning: could not upgrade users file " + file.getAbsolutePath());
                            break block8;
                        }
                        finally {
                            IOUtils.closeIfPossible(in);
                            IOUtils.closeIfPossible(overwriteOut);
                        }
                        IOUtils.closeIfPossible(overwriteOut);
                    }
                }
            });
        }
    }

    private void delayedRCommandCopy(File originalConfig, File newRuntimesConfig) throws SAXException, IOException, ParserConfigurationException {
        if (originalConfig.exists()) {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(originalConfig)));
            Document configXml = XmlUtil.parseReader(in);
            IOUtils.closeIfPossible(in);
            String rCommand = null;
            NodeList entries = configXml.getDocumentElement().getElementsByTagName("entry");
            for (int i = 0; i < entries.getLength(); ++i) {
                Element entry = (Element)entries.item(i);
                if (!"RCommand".equals(entry.getAttribute("entryKey"))) continue;
                rCommand = entry.getElementsByTagName("value").item(0).getTextContent();
                break;
            }
            if (rCommand == null) {
                System.out.println("Warning: configuration file was missing R command: " + originalConfig.getAbsolutePath());
                return;
            }
            this.operations.add(new Operation(newRuntimesConfig, rCommand){

                @Override
                public String describeExecution(File file, Object parameter) {
                    return "Copy R command from old configuration to " + file;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(File file, Object parameter) {
                    BufferedReader in = null;
                    FileOutputStream overwriteOut = null;
                    try {
                        StringWriter stringWriter = new StringWriter();
                        BufferedWriter out = new BufferedWriter(stringWriter);
                        in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                        Document document = XmlUtil.parseReader(in);
                        IOUtils.closeIfPossible(in);
                        Element runtimesElement = (Element)document.getElementsByTagName("runtimes").item(0);
                        for (Element runtimeElement : XmlUtil.getChildElements(runtimesElement, "runtime")) {
                            String runtimeName = XmlUtil.getChildElement(runtimeElement, "name").getTextContent();
                            if (!runtimeName.equals("R-2.12")) continue;
                            Element handlerElement = XmlUtil.getChildElement(runtimeElement, "handler");
                            for (Element parameterElement : XmlUtil.getChildElements(handlerElement, "parameter")) {
                                String paramName = XmlUtil.getChildElement(parameterElement, "name").getTextContent();
                                if (!paramName.equals("command")) continue;
                                Element commandValueElement = XmlUtil.getChildElement(parameterElement, "value");
                                commandValueElement.setTextContent((String)parameter);
                            }
                        }
                        XmlUtil.printXml(document, out);
                        out.close();
                        overwriteOut = new FileOutputStream(file);
                        IOUtils.copy(new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes()), overwriteOut);
                        IOUtils.closeIfPossible(overwriteOut);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Warning: could not upgrade runtimes configuration file " + file.getAbsolutePath());
                    }
                    finally {
                        IOUtils.closeIfPossible(overwriteOut);
                    }
                }
            });
        }
    }

    private void delayedConfigPurge(File fileAfterUpgrade, File filebeforeUpgrade, String componentDir) {
        if (filebeforeUpgrade.exists()) {
            this.operations.add(new Operation(fileAfterUpgrade, componentDir){

                @Override
                public String describeExecution(File file, Object parameter) {
                    return "Upgrade and purge " + file + " (update entry names and leave only those modules needed for " + parameter + ")";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(File file, Object parameter) {
                    BufferedReader in = null;
                    FileOutputStream overwriteOut = null;
                    try {
                        String oldName;
                        Element entry;
                        int i;
                        Element module;
                        StringWriter stringWriter = new StringWriter();
                        BufferedWriter out = new BufferedWriter(stringWriter);
                        in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                        Document originalDocument = XmlUtil.parseReader(in);
                        IOUtils.closeIfPossible(in);
                        Document newDocument = XmlUtil.newDocument();
                        newDocument.appendChild(newDocument.createElement("configuration"));
                        newDocument.getDocumentElement().setAttribute("content-version", "3");
                        this.moveModule("messaging", originalDocument, "messaging", newDocument);
                        this.moveModule("security", originalDocument, "security", newDocument);
                        if ("comp".equals(parameter)) {
                            this.moveModule("analyser", originalDocument, "comp", newDocument);
                        } else if ("frontend".equals(parameter)) {
                            this.moveModule("frontend", originalDocument, "filebroker", newDocument);
                            this.moveModule("filebroker", originalDocument, "filebroker", newDocument);
                        } else if ("fileserver".equals(parameter)) {
                            module = (Element)newDocument.getDocumentElement().appendChild(newDocument.createElement("configuration-module"));
                            module.setAttribute("moduleId", "filebroker");
                            this.addEntry(module, newDocument, "port", "8080");
                            this.addEntry(module, newDocument, "url", "http://" + InetAddress.getLocalHost().getHostName());
                            this.changeEntry(newDocument, "username", "filebroker");
                        } else if ("webstart".equals(parameter)) {
                            module = (Element)newDocument.getDocumentElement().appendChild(newDocument.createElement("configuration-module"));
                            module.setAttribute("moduleId", "webstart");
                            this.addEntry(module, newDocument, "port", "8081");
                        } else if ("manager".equals(parameter)) {
                            module = (Element)newDocument.getDocumentElement().appendChild(newDocument.createElement("configuration-module"));
                            module.setAttribute("moduleId", "manager");
                            this.addEntry(module, newDocument, "web-console-port", "8082");
                        } else {
                            this.moveModuleIfExists((String)parameter, originalDocument, (String)parameter, newDocument);
                        }
                        String[] obsolete = new String[]{"filebroker_urls", "RCommand"};
                        NodeList entries = newDocument.getElementsByTagName("entry");
                        for (i = 0; i < entries.getLength(); ++i) {
                            entry = (Element)entries.item(i);
                            oldName = entry.getAttribute("entryKey");
                            if (!Strings.isAnyOf(oldName, false, obsolete)) continue;
                            entry.getParentNode().removeChild(entry);
                        }
                        entries = newDocument.getElementsByTagName("entry");
                        for (i = 0; i < entries.getLength(); ++i) {
                            entry = (Element)entries.item(i);
                            oldName = entry.getAttribute("entryKey");
                            oldName = oldName.replace('_', '-');
                            String newName = "";
                            for (int c = 0; c < oldName.length(); ++c) {
                                char character = oldName.charAt(c);
                                if (Character.isUpperCase(character)) {
                                    newName = newName + '-';
                                    newName = newName + Character.toLowerCase(character);
                                    continue;
                                }
                                newName = newName + character;
                            }
                            if (newName.startsWith("-")) {
                                newName = newName.substring(1);
                            }
                            entry.setAttribute("entryKey", newName);
                        }
                        XmlUtil.printXml(newDocument, out);
                        out.close();
                        overwriteOut = new FileOutputStream(file);
                        IOUtils.copy(new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes()), overwriteOut);
                        IOUtils.closeIfPossible(overwriteOut);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Warning: could not upgrade configuration file " + file.getAbsolutePath());
                    }
                    finally {
                        IOUtils.closeIfPossible(overwriteOut);
                    }
                }

                private void changeEntry(Document document, String name, String value) {
                    NodeList entries = document.getDocumentElement().getElementsByTagName("entry");
                    for (int i = 0; i < entries.getLength(); ++i) {
                        Element entry = (Element)entries.item(i);
                        if (!name.equals(entry.getAttribute("entryKey"))) continue;
                        Element valueElement = (Element)entry.getElementsByTagName("value").item(0);
                        valueElement.setTextContent(value);
                        return;
                    }
                    throw new IllegalArgumentException("entry " + name + " not found");
                }

                private void addEntry(Element module, Document document, String name, String value) {
                    Element entry = (Element)module.appendChild(document.createElement("entry"));
                    entry.setAttribute("entryKey", name);
                    Element valueElement = (Element)entry.appendChild(document.createElement("value"));
                    valueElement.setTextContent(value);
                }

                private void moveModuleIfExists(String originalModule, Document originalDocument, String newModule, Document newDocument) {
                    try {
                        this.moveModule(originalModule, originalDocument, newModule, newDocument);
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }

                private void moveModule(String originalModule, Document originalDocument, String newModule, Document newDocument) {
                    NodeList modules = originalDocument.getElementsByTagName("configuration-module");
                    for (int i = 0; i < modules.getLength(); ++i) {
                        Element module = (Element)modules.item(i);
                        if (!originalModule.equals(module.getAttribute("moduleId"))) continue;
                        Element importedElement = (Element)newDocument.importNode(module, true);
                        newDocument.getDocumentElement().appendChild(importedElement);
                        importedElement.setAttribute("moduleId", newModule);
                        return;
                    }
                    throw new IllegalArgumentException("module " + originalModule + " was not found from config");
                }
            });
        }
    }

    private void delayedJnlpUpgrade(File fileAfterUpgrade, File filebeforeUpgrade) {
        if (filebeforeUpgrade.exists()) {
            this.operations.add(new Operation(fileAfterUpgrade, null){

                @Override
                public String describeExecution(File file, Object parameter) {
                    return "Upgrade " + file + " (change configuration passing mechanism to 1.3.x URL based)";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(File file, Object parameter) {
                    BufferedReader in = null;
                    FileOutputStream overwriteOut = null;
                    try {
                        StringWriter stringWriter = new StringWriter();
                        BufferedWriter out = new BufferedWriter(stringWriter);
                        in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                        Document document = XmlUtil.parseReader(in);
                        IOUtils.closeIfPossible(in);
                        Element applicationDesc = (Element)document.getElementsByTagName("application-desc").item(0);
                        while (applicationDesc.getElementsByTagName("argument").getLength() > 0) {
                            applicationDesc.removeChild(applicationDesc.getElementsByTagName("argument").item(0));
                        }
                        this.addArgument(document, applicationDesc, "client");
                        this.addArgument(document, applicationDesc, "-config");
                        this.addArgument(document, applicationDesc, document.getDocumentElement().getAttribute("codebase") + "/chipster-config.xml");
                        XmlUtil.printXml(document, out);
                        out.close();
                        overwriteOut = new FileOutputStream(file);
                        IOUtils.copy(new ByteArrayInputStream(stringWriter.getBuffer().toString().getBytes()), overwriteOut);
                        IOUtils.closeIfPossible(overwriteOut);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("Warning: could not upgrade jnlp file " + file.getAbsolutePath());
                    }
                    finally {
                        IOUtils.closeIfPossible(overwriteOut);
                    }
                }

                private void addArgument(Document document, Element applicationDesc, String value) {
                    Node node = applicationDesc.appendChild(document.createElement("argument"));
                    node.setTextContent(value);
                }
            });
        }
    }

    private static abstract class Operation {
        private File file;
        private Object parameter;

        public Operation(File file, Object parameter) {
            this.file = file;
            this.parameter = parameter;
        }

        public abstract void execute(File var1, Object var2);

        public abstract String describeExecution(File var1, Object var2);
    }
}

