/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.config;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class DirectoryLayout {
    public static final String BIN_DIR = "bin";
    public static final String LOGS_DIR = "logs";
    public static final String SECURITY_DIR = "security";
    public static final String CONF_DIR = "conf";
    public static final String WEB_ROOT = "web-root";
    private static final String DEBUG_BASE_DIR = "debug-base-dir";
    private static final String CONF_DIR_SYSTEM_PROPERTY = "chipster_conf_dir";
    private static final String LOGS_DIR_SYSTEM_PROPERTY = "chipster_logs_dir";
    private static final String SECURITY_DIR_SYSTEM_PROPERTY = "chipster_security_dir";
    private Type type;
    private Configuration configuration = null;
    private boolean hasConfig;
    private static DirectoryLayout instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryLayout initialiseServerLayout(List<String> specificModules) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        Class<DirectoryLayout> clazz = DirectoryLayout.class;
        synchronized (DirectoryLayout.class) {
            if (instance != null) {
                throw new IllegalStateException("already initialised");
            }
            LinkedList<String> configModules = new LinkedList<String>();
            configModules.addAll(Arrays.asList("messaging", SECURITY_DIR));
            configModules.addAll(specificModules);
            instance = new DirectoryLayout(Type.SERVER, null, configModules, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryLayout initialiseUnitTestLayout() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        Class<DirectoryLayout> clazz = DirectoryLayout.class;
        synchronized (DirectoryLayout.class) {
            if (instance != null) {
                throw new IllegalStateException("already initialised");
            }
            instance = new DirectoryLayout(Type.CLIENT, null, Arrays.asList("messaging", SECURITY_DIR), false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static DirectoryLayout initialiseClientLayout() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        return DirectoryLayout.initialiseClientLayout(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryLayout initialiseClientLayout(String configURL) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        Class<DirectoryLayout> clazz = DirectoryLayout.class;
        synchronized (DirectoryLayout.class) {
            if (instance != null) {
                throw new IllegalStateException("already initialised");
            }
            instance = new DirectoryLayout(Type.CLIENT, configURL, Arrays.asList("messaging", SECURITY_DIR, "client"), true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryLayout getInstance() {
        Class<DirectoryLayout> clazz = DirectoryLayout.class;
        synchronized (DirectoryLayout.class) {
            if (instance == null) {
                throw new IllegalStateException("not initialised");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DirectoryLayout(Type type, String configURL, List<String> configModules, boolean hasConfig) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        this.type = type;
        this.hasConfig = hasConfig;
        System.setProperty(LOGS_DIR_SYSTEM_PROPERTY, this.getLogsDir().getAbsolutePath());
        System.setProperty(SECURITY_DIR_SYSTEM_PROPERTY, this.getSecurityDir().getAbsolutePath());
        if (hasConfig) {
            System.setProperty(CONF_DIR_SYSTEM_PROPERTY, this.getConfDir().getAbsolutePath());
            this.configuration = configURL == null ? new Configuration(this.getConfDir(), configModules) : new Configuration(new URL(configURL), configModules);
        }
    }

    public File getConfDir() throws IOException {
        this.checkConfiguration();
        return this.check(new File(this.getBaseDir(), CONF_DIR));
    }

    public File getSecurityDir() throws IOException {
        return this.check(new File(this.getBaseDir(), SECURITY_DIR));
    }

    private File getLogsDir() throws IOException {
        return this.check(new File(this.getBaseDir(), LOGS_DIR));
    }

    public File getFileRoot() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        if (this.type == Type.SERVER) {
            File fileRoot = new File(this.getBaseDir(), this.configuration.getString("filebroker", "file-root-path"));
            return this.initialise(fileRoot);
        }
        throw new UnsupportedOperationException();
    }

    public File getCustomScriptsDir() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        if (this.type == Type.SERVER) {
            File customScriptsDir = new File(this.getBaseDir(), this.configuration.getString("comp", "custom-scripts-dir"));
            return this.initialise(customScriptsDir);
        }
        throw new UnsupportedOperationException();
    }

    public File getBackupDir() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        if (this.type == Type.SERVER) {
            File backupDir = new File(this.getBaseDir(), this.configuration.getString("manager", "backup-dir"));
            return this.initialise(backupDir);
        }
        throw new UnsupportedOperationException();
    }

    public File getJobsDataDirBase(String id) throws IOException, ConfigurationLoader.IllegalConfigurationException {
        if (this.type == Type.SERVER) {
            File jobsDataDir = new File(this.getBaseDir(), this.configuration.getString("comp", "work-dir"));
            return this.initialise(new File(jobsDataDir, id));
        }
        throw new UnsupportedOperationException();
    }

    public File getUserDataDir() throws IOException {
        if (this.type == Type.CLIENT) {
            File dir = null;
            File home = new File(System.getProperty("user.home"));
            dir = new File(home, "My Documents").exists() ? new File(home, "My Documents") : (new File(home, "Documents").exists() ? new File(home, "Documents") : home);
            return dir;
        }
        throw new IllegalStateException("not supported for type SERVER");
    }

    private File getClientSettingsDir() throws IOException {
        File dir = null;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            dir = new File(System.getProperty("user.home"), "Library" + File.separator + "Application Support");
        } else if (osName.startsWith("Windows")) {
            dir = new File(System.getProperty("user.home"), "Local Settings" + File.separator + "Application Data");
        }
        if (dir != null) {
            dir = new File(dir, "Chipster");
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                dir = null;
            }
        }
        if (dir == null) {
            dir = new File(System.getProperty("user.home"), ".chipster");
        }
        return this.check(dir);
    }

    private File getBaseDir() throws IOException {
        if (this.type == Type.CLIENT) {
            return this.getClientSettingsDir();
        }
        File baseDir = new File(System.getProperty("user.dir"));
        File debugRoot = new File(baseDir, DEBUG_BASE_DIR);
        if (debugRoot.exists()) {
            baseDir = debugRoot;
        }
        return baseDir;
    }

    private File check(File dir) throws IOException {
        if (!dir.exists()) {
            if (this.type == Type.CLIENT) {
                this.initialise(dir);
            } else {
                throw new IOException("directory " + dir.getAbsolutePath() + " does not exist");
            }
        }
        return dir;
    }

    private File initialise(File dir) throws IOException {
        dir.mkdirs();
        return dir;
    }

    public Configuration getConfiguration() {
        this.checkConfiguration();
        return this.configuration;
    }

    private void checkConfiguration() {
        if (!this.hasConfig) {
            throw new IllegalStateException("directory layout has no configuration");
        }
    }

    public static enum Type {
        CLIENT,
        SERVER;

    }
}

