/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.commons.management.basic;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.fusesource.commons.management.ManagementStrategy;
import org.fusesource.commons.management.Statistic;
import org.fusesource.commons.management.basic.StatisticImpl;

public abstract class AbstractManagementStrategy
implements ManagementStrategy {
    public static final String DEFAULT_DOMAIN = "org.fusesource";
    private boolean usePlatformMBeanServer = true;
    private String mbeanServerDefaultDomain = "org.fusesource";
    private MBeanServer mbeanServer;
    private LogManager logManager = LogManager.getLogManager();

    public void manageObject(Object managedObject) throws Exception {
        ObjectName name = this.getManagedObjectName(managedObject, null, ObjectName.class);
        if (name != null) {
            this.manageNamedObject(managedObject, name);
        }
    }

    public void unmanageObject(Object managedObject) throws Exception {
        ObjectName name = this.getManagedObjectName(managedObject, null, ObjectName.class);
        if (name != null) {
            this.unmanageNamedObject(name);
        }
    }

    public void notify(EventObject event) throws Exception {
        Logger logger = this.logManager.getLogger(event.getClass().getName());
        if (logger != null && logger.isLoggable(Level.FINE)) {
            logger.fine(event.getSource() + ": " + event.toString());
        }
    }

    public Statistic createStatistic(String name, Object owner, Statistic.UpdateMode updateMode) {
        return new StatisticImpl(updateMode);
    }

    public synchronized MBeanServer getMbeanServer() {
        if (this.mbeanServer == null) {
            ArrayList<MBeanServer> mbeanServers;
            this.mbeanServer = this.usePlatformMBeanServer ? ManagementFactory.getPlatformMBeanServer() : ((mbeanServers = MBeanServerFactory.findMBeanServer(this.mbeanServerDefaultDomain)).size() == 0 ? MBeanServerFactory.createMBeanServer(this.mbeanServerDefaultDomain) : (MBeanServer)mbeanServers.get(0));
        }
        return this.mbeanServer;
    }

    public synchronized void setMbeanServer(MBeanServer mbeanServer) {
        if (this.mbeanServer != null) {
            throw new IllegalStateException("MBeanServer has already been set");
        }
        if (mbeanServer == null) {
            throw new IllegalArgumentException("MBeanServer cannot be null");
        }
        this.mbeanServer = mbeanServer;
    }

    public boolean getUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public void setUsePlatformMBeanServer(boolean usePlatformMBeanServer) {
        this.usePlatformMBeanServer = usePlatformMBeanServer;
    }

    public String getMbeanServerDefaultDomain() {
        return this.mbeanServerDefaultDomain;
    }

    public void setMbeanServerDefaultDomain(String mbeanServerDefaultDomain) {
        this.mbeanServerDefaultDomain = mbeanServerDefaultDomain;
    }
}

