/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.webstart;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.MemUtil;
import java.util.Arrays;
import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class WebstartJettyServer
implements ShutdownCallback {
    private static Logger logger;
    private Server jettyInstance;

    public static void main(String[] args) throws Exception {
        System.setProperty("DEBUG", "true");
        WebstartJettyServer server = new WebstartJettyServer();
        server.start();
        server.jettyInstance.join();
    }

    public void start() {
        try {
            DirectoryLayout.initialiseServerLayout(Arrays.asList("webstart"));
            Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
            logger = Logger.getLogger(WebstartJettyServer.class);
            if (logger.isDebugEnabled()) {
                System.setProperty("DEBUG", "true");
            }
            this.jettyInstance = new Server();
            this.jettyInstance.setThreadPool((ThreadPool)new QueuedThreadPool());
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setServer(this.jettyInstance);
            connector.setPort(configuration.getInt("webstart", "port"));
            this.jettyInstance.setConnectors(new Connector[]{connector});
            Context wsRoot = new Context((HandlerContainer)this.jettyInstance, "/", false, false);
            wsRoot.setResourceBase("web-root/");
            wsRoot.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            this.jettyInstance.start();
            KeepAliveShutdownHandler.init(this);
            logger.info((Object)("webstart is up and running [" + ApplicationConstants.NAMI_VERSION + "]"));
            logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e, (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.jettyInstance.isRunning();
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        logger.info((Object)"shutting down");
    }
}

