/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.module.chipster;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.description.VVSADLSyntax;
import fi.csc.microarray.exception.MicroarrayException;

public class ChipsterInputTypes {
    public static final VVSADLSyntax.InputType CDNA = new VVSADLSyntax.InputType(){

        @Override
        public String getName() {
            return "CDNA";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.queryFeatures("/column/sample").exists();
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final VVSADLSyntax.InputType AFFY = new VVSADLSyntax.InputType(){

        @Override
        public String getName() {
            return "AFFY";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.isContentTypeCompatitible("application/cel");
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final VVSADLSyntax.InputType GENE_EXPRS = new VVSADLSyntax.InputType(){

        @Override
        public String getName() {
            return "GENE_EXPRS";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            try {
                Table chips = dataBean.queryFeatures("/column/chip.*").asTable();
                return chips != null && chips.getColumnCount() > 0;
            }
            catch (MicroarrayException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final VVSADLSyntax.InputType GENELIST = new VVSADLSyntax.InputType(){

        @Override
        public String getName() {
            return "GENELIST";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.queryFeatures("/identifier").exists();
        }

        @Override
        public boolean isMetadata() {
            return false;
        }
    };
    public static final VVSADLSyntax.InputType PHENODATA = new VVSADLSyntax.InputType(){

        @Override
        public String getName() {
            return "PHENODATA";
        }

        @Override
        public boolean isTypeOf(DataBean dataBean) {
            return dataBean.queryFeatures("/phenodata").exists();
        }

        @Override
        public boolean isMetadata() {
            return true;
        }
    };

    public static boolean hasRawType(DataBean data) {
        return AFFY.isTypeOf(data) || CDNA.isTypeOf(data);
    }
}

