/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging.message;

import fi.csc.microarray.messaging.message.NamiMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import org.apache.log4j.Logger;

public abstract class ParameterMessage
extends NamiMessage {
    private static final Logger logger = Logger.getLogger(ParameterMessage.class);
    private static final String KEY_PARAMETER = "parameter";
    private static final String KEY_NAMED_PARAMETER_KEY = "named-parameter-key";
    private static final String KEY_NAMED_PARAMETER_VALUE = "named-parameter-value";
    public static final String PARAMETER_AS_ID = "as-id";
    public static final String PARAMETER_JOB_ID = "job-id";
    public static final String PARAMETER_USE_COMPRESSION = "use-compression";
    private List<String> parameters = new LinkedList<String>();
    private HashMap<String, String> namedParameters = new HashMap();

    public ParameterMessage() {
    }

    public ParameterMessage(List<String> parameters) {
        if (parameters != null) {
            this.parameters.addAll(parameters);
        }
    }

    protected List<String> getParameters() {
        return this.parameters;
    }

    public void addParameter(String parameter) {
        this.parameters.add(parameter);
    }

    public void addNamedParameter(String key, String value) {
        this.namedParameters.put(key, value);
    }

    public String getNamedParameter(String key) {
        return this.namedParameters.get(key);
    }

    public Set<String> getParameterNames() {
        return this.namedParameters.keySet();
    }

    @Override
    public void unmarshal(MapMessage from) throws JMSException {
        super.unmarshal(from);
        this.parameters = new ArrayList<String>();
        int i = 0;
        while (from.itemExists(KEY_PARAMETER + i)) {
            String input = from.getString(KEY_PARAMETER + i);
            logger.debug((Object)("parameter " + KEY_PARAMETER + i + " is " + new String(input)));
            this.parameters.add(input);
            ++i;
        }
        int i2 = 0;
        while (from.itemExists(KEY_NAMED_PARAMETER_KEY + i2)) {
            String key = from.getString(KEY_NAMED_PARAMETER_KEY + i2);
            String value = from.getString(KEY_NAMED_PARAMETER_VALUE + i2);
            logger.debug((Object)("Unmarshalled named parameter: " + key + " = " + value));
            this.namedParameters.put(key, value);
            ++i2;
        }
    }

    @Override
    public void marshal(MapMessage to) throws JMSException {
        super.marshal(to);
        int i = 0;
        for (String parameter : this.parameters) {
            logger.debug((Object)("populated map message with parameter" + i + ": " + new String(parameter)));
            to.setString(KEY_PARAMETER + i, parameter);
            ++i;
        }
        logger.debug((Object)("Marshalling named parameters: " + this.namedParameters.keySet()));
        int j = 0;
        for (String key : this.namedParameters.keySet()) {
            to.setString(KEY_NAMED_PARAMETER_KEY + j, key);
            to.setString(KEY_NAMED_PARAMETER_VALUE + j, this.namedParameters.get(key));
            ++j;
        }
    }
}

