/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.databeans.ContentType;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataChangeEvent;
import fi.csc.microarray.databeans.DataChangeListener;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.features.Feature;
import fi.csc.microarray.databeans.features.FeatureProvider;
import fi.csc.microarray.databeans.features.Modifier;
import fi.csc.microarray.exception.MicroarrayException;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public abstract class DataManagerBase
implements DataManager {
    private static final Logger logger = Logger.getLogger(DataManagerBase.class);
    private Map<String, FeatureProvider> factories = new HashMap<String, FeatureProvider>();
    private Map<String, Modifier> modifiers = new HashMap<String, Modifier>();
    private Map<String, ContentType> contentTypes = new HashMap<String, ContentType>();
    private Map<String, String> extensionMap = new HashMap<String, String>();
    private LinkedList<DataChangeListener> listeners = new LinkedList();
    private boolean eventsEnabled = false;

    @Override
    public void addDataChangeListener(DataChangeListener listener) {
        logger.debug((Object)("adding DataChangeListener: " + listener));
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void setEventsEnabled(boolean enabled) {
        this.eventsEnabled = enabled;
    }

    @Override
    public void close() {
    }

    public void dispatchEventIfVisible(DataChangeEvent event) {
        if (event.getDataItem().getParent() != null) {
            this.dispatchEvent(event);
        }
    }

    public void dispatchEvent(DataChangeEvent event) {
        if (this.eventsEnabled) {
            for (DataChangeListener listener : this.listeners) {
                if (listener == null) {
                    logger.error((Object)"One of the DataChangeListeners listeners was null.");
                } else {
                    logger.debug((Object)("Notifying DataChangeListener " + listener.toString()));
                }
                try {
                    listener.dataChanged(event);
                }
                catch (RuntimeException e) {
                    logger.error((Object)"DataChangeEvent dispatch failed", (Throwable)e);
                }
            }
        }
    }

    public DataBean createDataBean(String name, DataFolder parent, DataBean source) throws MicroarrayException {
        return this.createDataBean(name, parent, DataManagerBase.wrapSource(source));
    }

    public static DataBean[] wrapSource(DataBean source) {
        DataBean[] sources = null;
        sources = source != null ? new DataBean[]{source} : new DataBean[]{};
        return sources;
    }

    @Override
    public void plugContentType(String mimeType, boolean supported, boolean binary, String description, Icon icon, String ... extensions) {
        this.contentTypes.put(mimeType, new ContentType(mimeType, supported, binary, description, icon, extensions));
        for (String extension : extensions) {
            this.extensionMap.put(extension, mimeType);
        }
    }

    @Override
    public void plugModifier(String name, Modifier modifier) {
        this.modifiers.put(name, modifier);
    }

    @Override
    public void plugFeatureFactory(String name, FeatureProvider plugin) {
        logger.debug((Object)("plugged " + plugin.getClass().getSimpleName() + " at " + name));
        plugin.setName(name);
        this.factories.put(name, plugin);
    }

    @Override
    public Modifier fetchModifier(String modifierName) {
        return this.modifiers.get(modifierName);
    }

    @Override
    public Feature fetchFeature(String featureName, DataBean bean) {
        String bestMatch = null;
        for (String feature : this.factories.keySet()) {
            if (!featureName.startsWith(feature) || bestMatch != null && feature.length() <= bestMatch.length()) continue;
            bestMatch = feature;
        }
        FeatureProvider factory = this.factories.get(bestMatch);
        if (factory == null) {
            throw new RuntimeException("no feature factory plugged in for \"" + featureName + "\" (total of " + this.factories.size() + " factories plugged)");
        }
        logger.debug((Object)("best match for " + featureName + " was " + (factory != null ? factory.getName() : factory)));
        String namePostfix = this.getNamePostfix(featureName, factory.getName());
        return factory.createFeature(namePostfix, bean);
    }

    @Override
    public ContentType guessContentType(String name) {
        String extension;
        String typeName;
        ContentType type = null;
        if (name.lastIndexOf(".") != -1 && (typeName = this.extensionMap.get(extension = name.substring(name.lastIndexOf(".") + 1, name.length()).toLowerCase())) != null) {
            type = this.contentTypes.get(typeName);
        }
        if (type == null) {
            type = this.contentTypes.get("application/octet-stream");
        }
        return type;
    }

    @Override
    public ContentType guessContentType(File file) {
        return this.guessContentType(file.getName());
    }

    @Override
    public ContentType getContentType(String typeName) {
        return this.contentTypes.get(typeName);
    }

    @Override
    public DataItem findDataItem(String name) {
        return this.findDataItem(name, this.getRootFolder());
    }

    private DataItem findDataItem(String name, DataItem root) {
        DataItem matchingItem = null;
        if (root.getName().equals(name)) {
            return root;
        }
        if (root instanceof DataFolder) {
            for (DataItem child : ((DataFolder)root).getChildren()) {
                matchingItem = this.findDataItem(name, child);
                if (matchingItem == null) continue;
                return matchingItem;
            }
        }
        return null;
    }

    private String getNamePostfix(String featureName, String factoryName) {
        if (factoryName.length() > featureName.length()) {
            return "";
        }
        String npf = featureName.substring(factoryName.length());
        if (npf.startsWith("/")) {
            return npf.substring(1);
        }
        return npf;
    }
}

