/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.config;

import fi.csc.microarray.config.SetupTool;
import fi.csc.microarray.config.UpgradeTool;
import fi.csc.microarray.util.XmlUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigTool {
    static final String CURRENT_R_VERSION = "R-2.12";
    private final String brokerDir = "activemq";
    private final String webstartDir = "webstart";
    private static final String[] componentDirsWithConfig = new String[]{"comp", "auth", "fileserver", "manager", "client", "webstart"};
    private String[][] configs = new String[][]{{"message broker (ActiveMQ) host", "myhost.mydomain"}, {"message broker protocol", "tcp"}, {"message broker port", "61616"}, {"file broker host", "myhost.mydomain"}, {"file broker port", "8080"}, {"URL of Web Start files", "http://myhost.mydomain"}, {"Web Start www-server port", "8081"}, {"manager www-console port", "8082"}, {"R-2.12.x command", "/opt/chipster/tools/R-2.12.0/"}, {"max. simultanous jobs (more recommended when compute service on separate node)", "3"}};
    private final int KEY_INDEX = 0;
    private final int VAL_INDEX = 1;
    private final int BROKER_HOST_INDEX = 0;
    private final int BROKER_PROTOCOL_INDEX = 1;
    private final int BROKER_PORT_INDEX = 2;
    private final int FILEBROKER_HOST_INDEX = 3;
    private final int FILEBROKER_PORT_INDEX = 4;
    private final int WS_CODEBASE_INDEX = 5;
    private final int WS_PORT = 6;
    private final int MANAGER_PORT = 7;
    private final int R_COMMAND_INDEX = 8;
    private final int MAX_JOBS_INDEX = 9;
    private String[][] passwords = new String[][]{{"comp", ""}, {"auth", ""}, {"filebroker", ""}, {"manager", ""}};
    private HashMap<String, Document> documentsToWrite = new HashMap();

    public ConfigTool() throws ParserConfigurationException {
        System.out.println("Chipster ConfigTool");
        System.out.println("");
        System.out.println("No changes are written before you verify them");
        System.out.println("");
    }

    public static void main(String[] args) throws Exception {
        ConfigTool configTool = new ConfigTool();
        UpgradeTool upgradeTool = new UpgradeTool();
        SetupTool setupTool = new SetupTool();
        if (args.length == 0) {
            ConfigTool.fail();
        } else if ("configure".equals(args[0])) {
            configTool.configure();
        } else if ("genpasswd".equals(args[0])) {
            configTool.genpasswd();
        } else if ("setup".equals(args[0])) {
            setupTool.setup();
        } else if (args[0].startsWith("upgrade")) {
            String[] parts = args[0].split("_");
            int fromMajor = Integer.parseInt(parts[1]);
            int toMajor = Integer.parseInt(parts[2]);
            if (args.length > 1) {
                upgradeTool.upgrade(new File(args[1]), fromMajor, toMajor);
            } else {
                System.out.println("Please specify location of the old installation directory as an argument (e.g., \"./upgrade.sh /opt/chipster-1.2.3\")");
            }
        } else {
            ConfigTool.fail();
        }
    }

    private static void fail() {
        System.out.println("Illegal arguments! Please specify one of: configure, genpasswd, setup, upgrade_<major version number of source>_<major version number of target>");
    }

    private void genpasswd() throws Exception {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            for (int i = 0; i < this.passwords.length; ++i) {
                this.passwords[i][1] = UUID.randomUUID().toString();
            }
            for (String componentDir : ConfigTool.getComponentDirsWithConfig()) {
                if (!new File(componentDir).exists()) continue;
                File configFile = new File(componentDir + File.separator + "conf" + File.separator + "chipster-config.xml");
                this.updateChipsterConfigFilePasswords(configFile);
            }
            File activemqConfigFile = new File("activemq" + File.separator + "conf" + File.separator + "activemq.xml");
            if (activemqConfigFile.exists()) {
                this.updateActivemqConfigFilePasswords(activemqConfigFile);
            }
            ConfigTool.verifyChanges(in);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("\nQuitting, no changes written to disk!");
            return;
        }
        this.writeChangesToDisk();
    }

    private void writeChangesToDisk() throws TransformerException, UnsupportedEncodingException, FileNotFoundException {
        for (String file : this.documentsToWrite.keySet()) {
            System.out.println("Writing changes to " + file + "...");
            XmlUtil.printXml(this.documentsToWrite.get(file), new OutputStreamWriter(new FileOutputStream(file)));
        }
        System.out.println("\nAll changes successfully written!");
    }

    public static void verifyChanges(BufferedReader in) throws Exception {
        ConfigTool.verifyChanges(in, "Please verify changes. Should changes be written to disk");
    }

    public static void verifyChanges(BufferedReader in, String question) throws Exception {
        System.out.println(question + " [yes/no]?");
        String answer = in.readLine();
        if (!"yes".equals(answer)) {
            throw new Exception("User decided to abort");
        }
    }

    public void configure() throws Exception {
        try {
            File wsConfigFile;
            File activemqConfigFile;
            File runtimesConfigFile;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                String host;
                this.configs[0][1] = host = InetAddress.getLocalHost().getHostName();
                this.configs[3][1] = host;
                this.configs[5][1] = "http://" + host + ":8081";
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            for (int i = 0; i < this.configs.length; ++i) {
                System.out.println("Please specify " + this.configs[i][0] + " [" + this.configs[i][1] + "]: ");
                String line = in.readLine();
                if (line.trim().equals("")) continue;
                this.configs[i][1] = line;
            }
            for (String componentDir : ConfigTool.getComponentDirsWithConfig()) {
                if (!new File(componentDir).exists()) continue;
                File configFile = new File(componentDir + File.separator + "conf" + File.separator + "chipster-config.xml");
                this.updateChipsterConfigFile(configFile);
            }
            File wsClientConfigFile = new File("webstart" + File.separator + "web-root" + File.separator + "chipster-config.xml");
            if (wsClientConfigFile.exists()) {
                this.updateChipsterConfigFile(wsClientConfigFile);
            }
            if ((runtimesConfigFile = new File("comp" + File.separator + "conf" + File.separator + "runtimes.xml")).exists()) {
                this.updateRuntimesConfigFile(runtimesConfigFile);
            }
            if ((activemqConfigFile = new File("activemq" + File.separator + "conf" + File.separator + "activemq.xml")).exists()) {
                this.updateActivemqConfigFile(activemqConfigFile);
            }
            if ((wsConfigFile = new File("webstart" + File.separator + "web-root" + File.separator + "chipster.jnlp")).exists()) {
                this.updateWsConfigFile(wsConfigFile);
            }
            ConfigTool.verifyChanges(in);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println("\nQuitting, no changes written to disk!");
            return;
        }
        this.writeChangesToDisk();
    }

    private void updateActivemqConfigFile(File configFile) throws Exception {
        Document doc = this.openForUpdating("ActiveMQ", configFile);
        Element broker = (Element)doc.getDocumentElement().getElementsByTagName("broker").item(0);
        Element transportConnectors = (Element)broker.getElementsByTagName("transportConnectors").item(0);
        Element transportConnector = (Element)transportConnectors.getElementsByTagName("transportConnector").item(0);
        String uri = this.configs[1][1] + "://" + this.configs[0][1] + ":" + this.configs[2][1];
        this.updateElementAttribute(transportConnector, "uri", uri);
        this.writeLater(configFile, doc);
    }

    private void updateWsConfigFile(File configFile) throws Exception {
        Document doc = this.openForUpdating("Web Start", configFile);
        Element jnlp = doc.getDocumentElement();
        this.updateElementAttribute(jnlp, "codebase", this.configs[5][1]);
        Element applicationDesc = (Element)jnlp.getElementsByTagName("application-desc").item(0);
        NodeList arguments = applicationDesc.getElementsByTagName("argument");
        Element lastArgument = (Element)arguments.item(arguments.getLength() - 1);
        String url = "http://" + this.configs[0][1] + ":" + this.configs[6][1] + "/" + "chipster-config.xml";
        this.updateElementValue(lastArgument, "configuration URL (for Web Start)", url);
        this.writeLater(configFile, doc);
    }

    private void updateActivemqConfigFilePasswords(File configFile) throws Exception {
        Document doc = this.openForUpdating("ActiveMQ", configFile);
        Element broker = (Element)doc.getDocumentElement().getElementsByTagName("broker").item(0);
        NodeList users = ((Element)((Element)((Element)broker.getElementsByTagName("plugins").item(0)).getElementsByTagName("simpleAuthenticationPlugin").item(0)).getElementsByTagName("users").item(0)).getElementsByTagName("authenticationUser");
        block0: for (int i = 0; i < users.getLength(); ++i) {
            for (int p = 0; p < this.passwords.length; ++p) {
                Element user = (Element)users.item(i);
                if (!user.getAttribute("username").equals(this.passwords[p][0])) continue;
                this.updateElementAttribute(user, "password for " + this.passwords[p][0], "password", this.passwords[p][1]);
                continue block0;
            }
        }
        this.writeLater(configFile, doc);
    }

    private void updateChipsterConfigFilePasswords(File configFile) throws Exception {
        Document doc = this.openForUpdating("Chipster", configFile);
        Element securityModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "security");
        Element usernameElement = XmlUtil.getChildWithAttributeValue(securityModule, "entryKey", "username");
        String username = ((Element)usernameElement.getElementsByTagName("value").item(0)).getTextContent();
        for (int i = 0; i < this.passwords.length; ++i) {
            if (!username.equals(this.passwords[i][0])) continue;
            this.updateConfigEntryValue(securityModule, "password", this.passwords[i][1]);
            break;
        }
        this.writeLater(configFile, doc);
    }

    private void updateChipsterConfigFile(File configFile) throws Exception {
        Element managerModule;
        Element webstartModule;
        Element analyserModule;
        Document doc = this.openForUpdating("Chipster", configFile);
        Element messagingModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "messaging");
        this.updateConfigEntryValue(messagingModule, "broker-host", this.configs[0][1]);
        this.updateConfigEntryValue(messagingModule, "broker-protocol", this.configs[1][1]);
        this.updateConfigEntryValue(messagingModule, "broker-port", this.configs[2][1]);
        Element filebrokerModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "filebroker");
        if (filebrokerModule != null) {
            this.updateConfigEntryValue(filebrokerModule, "port", this.configs[4][1]);
            this.updateConfigEntryValue(filebrokerModule, "url", this.createFilebrokerUrl());
        }
        if ((analyserModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "comp")) != null) {
            this.updateConfigEntryValue(analyserModule, "max-jobs", this.configs[9][1]);
        }
        if ((webstartModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "webstart")) != null) {
            this.updateConfigEntryValue(webstartModule, "port", this.configs[6][1]);
        }
        if ((managerModule = XmlUtil.getChildWithAttributeValue(doc.getDocumentElement(), "moduleId", "manager")) != null) {
            this.updateConfigEntryValue(managerModule, "web-console-port", this.configs[7][1]);
        }
        this.writeLater(configFile, doc);
    }

    private void updateRuntimesConfigFile(File configFile) throws Exception {
        boolean ok = false;
        Document doc = this.openForUpdating("Runtimes", configFile);
        Element runtimesElement = (Element)doc.getElementsByTagName("runtimes").item(0);
        for (Element runtimeElement : XmlUtil.getChildElements(runtimesElement, "runtime")) {
            String runtimeName = XmlUtil.getChildElement(runtimeElement, "name").getTextContent();
            if (!runtimeName.equals(CURRENT_R_VERSION)) continue;
            Element handlerElement = XmlUtil.getChildElement(runtimeElement, "handler");
            for (Element parameterElement : XmlUtil.getChildElements(handlerElement, "parameter")) {
                String paramName = XmlUtil.getChildElement(parameterElement, "name").getTextContent();
                if (!paramName.equals("command")) continue;
                Element commandValueElement = XmlUtil.getChildElement(parameterElement, "value");
                this.updateElementValue(commandValueElement, "R-2.6.1 command", this.configs[8][1]);
                ok = true;
            }
        }
        if (!ok) {
            throw new RuntimeException("Could not update R-2.6.1 command to runtimes.xml");
        }
        this.writeLater(configFile, doc);
    }

    private String createFilebrokerUrl() {
        return "http://" + this.configs[3][1];
    }

    private void updateConfigEntryValue(Element module, String name, String newValue) {
        Element entry = XmlUtil.getChildWithAttributeValue(module, "entryKey", name);
        Element value = (Element)entry.getElementsByTagName("value").item(0);
        this.updateElementValue(value, name, newValue);
    }

    private void updateElementValue(Element element, String logicalName, String newValue) {
        System.out.println("  changing " + logicalName + ": " + element.getTextContent() + " -> " + newValue);
        element.setTextContent(newValue);
    }

    private void updateElementAttribute(Element element, String attrName, String attrValue) {
        this.updateElementAttribute(element, attrName, attrName, attrValue);
    }

    private void updateElementAttribute(Element element, String logicalName, String attrName, String attrValue) {
        System.out.println("  changing " + logicalName + ": " + element.getAttribute(attrName) + " -> " + attrValue);
        element.setAttribute(attrName, attrValue);
    }

    private void writeLater(File configFile, Document doc) throws TransformerException, UnsupportedEncodingException, FileNotFoundException {
        this.documentsToWrite.put(configFile.getAbsolutePath(), doc);
        System.out.println("");
    }

    private Document openForUpdating(String name, File configFile) throws SAXException, IOException, ParserConfigurationException {
        System.out.println("Updating " + name + " config in " + configFile.getAbsolutePath());
        Document doc = XmlUtil.parseFile(configFile);
        return doc;
    }

    public static String[] getComponentDirsWithConfig() {
        return componentDirsWithConfig;
    }
}

