/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.workflow;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class WorkflowWriter {
    private LinkedList<String> writeWarnings = new LinkedList();
    private HashMap<DataBean, String> resultIdMap;
    private boolean used = false;

    public static String generateVersionHeaderLine() {
        return "// VERSION BSH/2 (do not remove this)\n";
    }

    public synchronized StringBuffer writeWorkflow(DataBean root) throws IOException {
        if (this.used) {
            throw new IllegalStateException("writer cannot be reused");
        }
        this.resultIdMap = new HashMap();
        StringBuffer script = new StringBuffer("");
        this.generateHeader(script, root);
        this.generateRecursively(script, root);
        this.used = true;
        return script;
    }

    private void generateRecursively(StringBuffer script, DataBean bean) {
        HashSet<Operation> operations = new HashSet<Operation>();
        for (DataBean derived : bean.getLinkSources(DataBean.Link.DERIVATION)) {
            operations.add(derived.getOperation());
        }
        for (Operation operation : operations) {
            LinkedList<DataBean> results = new LinkedList<DataBean>();
            for (DataBean derived : bean.getLinkSources(DataBean.Link.DERIVATION)) {
                if (derived.getOperation() != operation) continue;
                results.add(derived);
            }
            this.generateStep(script, operation, results);
        }
        for (DataBean derived : bean.getLinkSources(DataBean.Link.DERIVATION)) {
            this.generateRecursively(script, derived);
        }
    }

    private void generateStep(StringBuffer script, Operation operation, LinkedList<DataBean> results) {
        if (operation.getBindings() == null) {
            this.writeWarnings.add("Operation " + operation.getDefinition().getFullName() + " was skipped.");
            return;
        }
        StringBuffer dataString = new StringBuffer("\ndatas = new WfDataBean[] {\n");
        boolean first = true;
        for (Operation.DataBinding binding : operation.getBindings()) {
            if (binding.getInputType() == ChipsterInputTypes.PHENODATA) continue;
            if (!first) {
                dataString.append(",\n");
            } else {
                first = false;
            }
            String name = this.resultIdMap.get(binding.getData());
            if (name == null) {
                this.writeWarnings.add("Operation " + operation.getDefinition().getFullName() + " was skipped because it combines multiple workflow branches.");
                return;
            }
            dataString.append("  " + name);
        }
        dataString.append("\n};\n");
        script.append(dataString);
        script.append("op = new WfOperation(app.locateOperationDefinition(\"" + operation.getCategoryName() + "\", \"" + operation.getName() + "\"), datas);\n");
        for (Parameter parameter : operation.getParameters()) {
            script.append("op.setParameter(\"" + parameter.getName() + "\", " + parameter.getValueAsJava() + ");\n");
        }
        int resultCount = operation.getDefinition().getOutputCount();
        script.append("opBlocker = new WfResultBlocker(" + resultCount + ");\n");
        script.append("op.setResultListener(opBlocker);\n");
        script.append("app.executeOperation(op);\n");
        script.append("opBlocker.blockUntilDone();\n");
        int i = -1;
        for (DataBean result : results) {
            String name = "data" + this.resultIdMap.size();
            this.resultIdMap.put(result, name);
            script.append(name + " = opBlocker.getWorkflowResults().get(" + ++i + ");\n");
        }
    }

    private void generateHeader(StringBuffer script, DataBean root) {
        script.append(WorkflowWriter.generateVersionHeaderLine());
        script.append("/* \n  BeanShell workflow script for " + ApplicationConstants.APPLICATION_TITLE + "\n" + "  Generated by " + System.getProperty("user.name") + " at " + new Date().toString() + "\n" + "*/\n");
        script.append("\n");
        script.append("import fi.csc.microarray.client.workflow.api.*;\n");
        script.append("\n");
        script.append("data0 = app.getSelectionManager().getSelectedDataBean();\n");
        this.resultIdMap.put(root, "data0");
    }

    public List<String> writeWarnings() {
        return this.writeWarnings;
    }
}

