/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;

public class TsvSorter {
    private static final int col = 7;
    private static long startTime = -1L;

    public static void main(String[] args) throws Exception {
        long s = System.currentTimeMillis();
        TsvSorter.externalSort("u_filtered.txt", "sorted.txt");
        System.out.println(System.currentTimeMillis() - s);
    }

    private static void showProgress(String message) {
        if (startTime != -1L) {
            System.out.println((System.currentTimeMillis() - startTime) / 1000L + " s");
        }
        startTime = System.currentTimeMillis();
        System.out.println(message);
    }

    private static void externalSort(String infile, String outfile) {
        try {
            BufferedReader initReader = new BufferedReader(new FileReader(infile));
            ArrayList<Row> rowBatch = new ArrayList<Row>(500000);
            boolean quit = false;
            int numFiles = 0;
            while (!quit) {
                String line;
                TsvSorter.showProgress("Reading...");
                for (int size = 0; size < 200000000; size += line.length()) {
                    line = initReader.readLine();
                    if (line == null) {
                        quit = true;
                        break;
                    }
                    rowBatch.add(new Row(line));
                }
                TsvSorter.showProgress("Sorting...");
                Collections.sort(rowBatch);
                TsvSorter.showProgress("Writing...");
                FileWriter fw = new FileWriter(infile + "_chunk" + numFiles);
                BufferedWriter bw = new BufferedWriter(fw);
                for (int i = 0; i < rowBatch.size(); ++i) {
                    bw.append(((Row)rowBatch.get((int)i)).line + "\n");
                }
                bw.close();
                ++numFiles;
                rowBatch.clear();
            }
            TsvSorter.showProgress("Merging...");
            TsvSorter.mergeFiles(infile, outfile, numFiles);
            TsvSorter.showProgress("DONE");
            initReader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static void mergeFiles(String inputFilePath, String outputFilePath, int numChunkFiles) {
        try {
            int i;
            ArrayList<BufferedReader> mergefbr = new ArrayList<BufferedReader>();
            ArrayList<Row> filerows = new ArrayList<Row>();
            FileWriter fw = new FileWriter(outputFilePath);
            BufferedWriter bw = new BufferedWriter(fw);
            boolean someFileStillHasRows = false;
            for (int i2 = 0; i2 < numChunkFiles; ++i2) {
                mergefbr.add(new BufferedReader(new FileReader(inputFilePath + "_chunk" + i2)));
                String line = ((BufferedReader)mergefbr.get(i2)).readLine();
                if (line != null) {
                    filerows.add(new Row(line));
                    someFileStillHasRows = true;
                    continue;
                }
                filerows.add(null);
            }
            while (someFileStillHasRows) {
                int i3;
                Row min;
                int minIndex = 0;
                Row row = (Row)filerows.get(0);
                if (row != null) {
                    min = row;
                    minIndex = 0;
                } else {
                    min = null;
                    minIndex = -1;
                }
                for (i3 = 1; i3 < filerows.size(); ++i3) {
                    row = (Row)filerows.get(i3);
                    if (min != null) {
                        if (row == null || row.compareTo(min) >= 0) continue;
                        minIndex = i3;
                        min = (Row)filerows.get(i3);
                        continue;
                    }
                    if (row == null) continue;
                    min = row;
                    minIndex = i3;
                }
                if (minIndex < 0) {
                    someFileStillHasRows = false;
                } else {
                    bw.append(((Row)filerows.get((int)minIndex)).line + "\n");
                    String line = ((BufferedReader)mergefbr.get(minIndex)).readLine();
                    if (line != null) {
                        filerows.set(minIndex, new Row(line));
                    } else {
                        filerows.set(minIndex, null);
                    }
                }
                for (i3 = 0; i3 < filerows.size(); ++i3) {
                    someFileStillHasRows = false;
                    if (filerows.get(i3) == null) continue;
                    if (minIndex < 0) {
                        System.out.println("mindex lt 0 and found row not null" + filerows.get(i3));
                        System.exit(-1);
                    }
                    someFileStillHasRows = true;
                    break;
                }
                if (someFileStillHasRows) continue;
                for (i3 = 0; i3 < filerows.size(); ++i3) {
                    String line;
                    if (filerows.get(i3) != null || (line = ((BufferedReader)mergefbr.get(i3)).readLine()) == null) continue;
                    someFileStillHasRows = true;
                    filerows.set(i3, new Row(line));
                }
            }
            bw.close();
            fw.close();
            for (i = 0; i < mergefbr.size(); ++i) {
                ((BufferedReader)mergefbr.get(i)).close();
            }
            for (i = 0; i < numChunkFiles; ++i) {
                File f = new File(inputFilePath + "_chunk" + i);
                f.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static class Row
    implements Comparable<Row> {
        public String line;
        public Long pos;

        public Row(String line) {
            this.line = line;
            String posStr = line.split("\t")[7];
            this.pos = posStr.equals("") ? Long.valueOf(-1L) : Long.valueOf(Long.parseLong(posStr));
        }

        @Override
        public int compareTo(Row other) {
            return this.pos.compareTo(other.pos);
        }
    }
}

