/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;

public class TsvGenerator {
    private static long rows = (long)Math.pow(10.0, 7.0);

    public static void main(String[] args) {
        System.out.println("File generating started");
        Long start = System.currentTimeMillis();
        File file = new File("tsv.tsv");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            Random rand = new Random();
            writer.write(" \tchip.microarray001\tannotation\tdescription\n");
            int i = 0;
            while ((long)i < rows) {
                String id = "" + i;
                String value = "" + TsvGenerator.calcY(i);
                String strand = rand.nextBoolean() ? "+" : "-";
                String seq = "";
                block9: for (int j = 0; j < 16; ++j) {
                    int r = rand.nextInt(4);
                    switch (r) {
                        case 0: {
                            seq = seq + "A";
                            continue block9;
                        }
                        case 1: {
                            seq = seq + "T";
                            continue block9;
                        }
                        case 2: {
                            seq = seq + "G";
                            continue block9;
                        }
                        case 3: {
                            seq = seq + "C";
                        }
                    }
                }
                writer.write(id + "\t" + value + "\t" + strand + "\t" + seq + "\n");
                if (i % 10000 == 0) {
                    System.out.println(i);
                }
                ++i;
            }
            writer.flush();
            writer.close();
            System.out.println("DONE in " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String fillWithSpaces(String orig, int length) {
        String spaces = "                            ";
        return orig + spaces.substring(0, length - orig.length());
    }

    private static float calcY(int x) {
        float value = 0.0f;
        for (float factor = (float)(rows / 3L); factor > 3.0f; factor /= 2.0f) {
            value = (float)((double)value + Math.sin((float)x / factor) * Math.log(factor));
        }
        return value;
    }
}

