/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.track;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class CytobandTrack
extends Track {
    private static final int THICKNESS = 10;
    private static final int MARGIN = 2;
    private Collection<RegionContent> bands = new TreeSet<RegionContent>();
    List<Integer> occupiedSpace = new ArrayList<Integer>();
    private boolean showText;

    public Band getBand(String id) {
        for (Band band : Band.values()) {
            if (!band.getId().equals(id)) continue;
            return band;
        }
        return null;
    }

    public CytobandTrack(View view, File file, Class<? extends AreaRequestHandler> handler, ReadInstructions<?> readInstructions, boolean showText) {
        super(view, file, handler, readInstructions);
        this.showText = showText;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        if (this.bands != null) {
            boolean firstGap = true;
            for (RegionContent bandRegion : this.bands) {
                Band band = this.getBand((String)bandRegion.values.get((Object)Content.VALUE));
                String text = (String)bandRegion.values.get((Object)Content.ID);
                if (text == null) {
                    text = "";
                }
                if (band.getColor() != null) {
                    RectDrawable box = this.createDrawable(bandRegion.region.start, bandRegion.region.end, band.color);
                    drawables.add(box);
                    if (this.showText) {
                        int CHAR_WIDTH = 7;
                        int textSpace = 0;
                        textSpace = box.x >= 0 ? box.width : box.width + box.x;
                        if (textSpace > text.length() * 7) {
                            int textX = Math.max(0, box.x);
                            drawables.add(new TextDrawable(textX, box.y - 2, text, Color.black));
                        }
                    }
                    firstGap = true;
                    continue;
                }
                if (band != Band.GAP) continue;
                int y = this.getMaxHeight() - 12;
                int sideX = this.getView().bpToTrack(bandRegion.region.end);
                int cornerX = this.getView().bpToTrack(bandRegion.region.start);
                if (firstGap) {
                    int tmp = sideX;
                    sideX = cornerX;
                    cornerX = tmp;
                    firstGap = false;
                }
                drawables.add(new LineDrawable(sideX, y, cornerX, y + 5, Color.black));
                drawables.add(new LineDrawable(sideX, y + 10, cornerX, y + 5, Color.black));
            }
        }
        return drawables;
    }

    private RectDrawable createDrawable(long startBp, long endBp, Color c) {
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        rect.y = this.getMaxHeight() - 12;
        rect.height = 10;
        return new RectDrawable(rect, c, Color.black);
    }

    @Override
    public void processAreaResult(AreaResult<RegionContent> areaResult) {
        this.bands.add((RegionContent)areaResult.content);
        this.getView().redraw();
    }

    @Override
    public void updateData() {
        super.updateData();
    }

    @Override
    public int getMaxHeight() {
        return this.showText ? 40 : 20;
    }

    @Override
    public Collection<Content> getDefaultContents() {
        return Arrays.asList(Content.VALUE, Content.ID);
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    static enum Band {
        WHITE("gneg", Color.white),
        LIGHT_GRAY("gpos25", Color.lightGray),
        MID_GRAY("gpos50", Color.gray),
        DARK_GRAY("gpos75", Color.darkGray),
        BLACK("gpos100", Color.black),
        GAP("acen", null),
        OTHER("gvar", Color.white);

        private String id;
        private Color color;

        private Band(String id, Color color) {
            this.id = id;
            this.color = color;
        }

        public String getId() {
            return this.id;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

