/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.ByteChunk;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.FileDefinition;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;

public class TsvChunkParser
extends ChunkParser {
    public static final long NEXT = -1L;
    private String[] line;
    private Iterator<String> lineIterator;
    private BufferedReader input;

    public TsvChunkParser(FileDefinition fileDef) {
        super(fileDef);
    }

    @Override
    public float getFloat(long pos) {
        return new Float(this.getString(pos)).floatValue();
    }

    @Override
    public long getLong(long pos) {
        return new Long(this.getString(pos));
    }

    @Override
    public long getPosition(long readIndex, Content rec) {
        if (readIndex == -1L) {
            return this.fileDef.indexOf(rec);
        }
        throw new UnsupportedOperationException("Only iterative use supported");
    }

    public long getNextFieldPosition() {
        return -1L;
    }

    @Override
    public long getReadCount() {
        throw new UnsupportedOperationException("Only iterative use supported");
    }

    @Override
    public String getString(long pos) {
        if (pos == -1L) {
            return this.getNextString();
        }
        return this.getField(pos);
    }

    private String getField(long pos) {
        if (this.line == null) {
            this.readNextLine();
        }
        return this.line[(int)pos];
    }

    private String getNextString() {
        if (this.lineIterator == null || !this.lineIterator.hasNext()) {
            this.readNextLine();
        }
        return this.lineIterator.next();
    }

    public boolean readNextLine() {
        if (this.input == null) {
            this.input = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.chunk.content)));
        }
        try {
            String line = this.input.readLine();
            if (line != null) {
                this.line = line.split("\t");
                this.lineIterator = Arrays.asList(this.line).iterator();
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void setChunk(ByteChunk chunk) {
        super.setChunk(chunk);
        this.input = null;
        this.line = null;
        this.lineIterator = null;
    }

    @Override
    public ChunkParser clone() {
        return new TsvChunkParser(this.fileDef);
    }
}

