/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.ByteChunk;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Conciser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;

public class SeqLengthIntensityConciser
implements Conciser<Float> {
    @Override
    public Float concise(ByteChunk chunk, ChunkParser parser) {
        Content start = Content.BP_START;
        Content seq = Content.SEQUENCE;
        long total = 0L;
        long minBp = -1L;
        long maxBp = -1L;
        parser.setChunk(chunk);
        long rowCount = parser.getReadCount();
        int i = 0;
        while ((long)i < rowCount) {
            long startBp = parser.getLong((long)i + chunk.readIndex, start);
            long length = parser.getString((long)i + chunk.readIndex, seq).trim().length();
            total += length;
            if (i == 0) {
                minBp = startBp;
            }
            if ((long)i == rowCount - 1L) {
                maxBp = startBp;
            }
            ++i;
        }
        return Float.valueOf((float)total / (float)(maxBp - minBp));
    }

    @Override
    public Region getRegion(ChunkParser parser, long readIndex) {
        long startBp = parser.getLong(readIndex, Content.BP_START);
        long length = parser.getString(readIndex, Content.SEQUENCE).trim().length();
        return new Region(startBp, startBp + length);
    }
}

