/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.ByteChunk;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.TreeThread;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.FileResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.FsfStatus;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import java.util.Map;

public class TreeNode<T> {
    private static final long RESOLUTION = 256L;
    private TreeThread<T> tree;
    public T concisedValue;
    public Region nodeBpRegion;
    public Region nodeRows;
    private TreeNode<T> left;
    private TreeNode<T> right;
    private TreeNode<T> parent;
    private boolean requestDistributor = false;
    private Region subtreeRows;
    private int maxChildCount;
    private ReadInstructions<T> instructions;

    public TreeNode(Region subtreeReadIndexes, TreeThread<T> tree, TreeNode<T> parent) {
        this.tree = tree;
        this.parent = parent;
        this.subtreeRows = subtreeReadIndexes;
        this.instructions = tree.getInstructions();
        this.nodeRows = new Region();
        this.nodeRows = this.instructions.chunker.getChunkMiddleOf(subtreeReadIndexes);
        this.maxChildCount = this.instructions.chunker.getChildCount(subtreeReadIndexes);
        if (this.maxChildCount == 0) {
            this.nodeRows = subtreeReadIndexes;
        }
    }

    private void createChildren() {
        if (this.maxChildCount >= 1 && this.left == null) {
            this.left = new TreeNode<T>(new Region(this.subtreeRows.start, this.nodeRows.start - 1L), this.tree, this);
        }
        if (this.maxChildCount == 2 && this.right == null) {
            this.right = new TreeNode<T>(new Region(this.nodeRows.end + 1L, this.subtreeRows.end), this.tree, this);
        }
    }

    private void fetchConcisedContent(AreaRequest areaRequest) {
        this.tree.createFileRequest(areaRequest, this.nodeRows, this, areaRequest.status);
    }

    public void resetRequestDistributor() {
        this.requestDistributor = false;
        if (this.left != null) {
            this.left.resetRequestDistributor();
        }
        if (this.right != null) {
            this.right.resetRequestDistributor();
        }
    }

    public void processAreaRequest(AreaRequest areaRequest) {
        if (this.nodeBpRegion != null) {
            boolean recursionNeeded;
            long nonZeroLength = Math.max(this.nodeBpRegion.getLength(), 1L);
            boolean bl = recursionNeeded = areaRequest.getLength() / 256L < this.getSubtreeBpLengthApproximation();
            if (this.nodeBpRegion.intercepts(areaRequest)) {
                if (areaRequest.status.concise) {
                    this.createConcisedResult(areaRequest.status);
                } else {
                    this.tree.createFileRequest(areaRequest, this.nodeRows, this, areaRequest.status);
                }
            }
            if (recursionNeeded) {
                if (this.maxChildCount > 0 && this.left == null) {
                    this.createChildren();
                }
                if (this.left != null && areaRequest.start <= this.nodeBpRegion.start) {
                    this.left.processAreaRequest(areaRequest);
                }
                if (this.right != null && areaRequest.end >= this.nodeBpRegion.start) {
                    this.right.processAreaRequest(areaRequest);
                }
            }
        } else {
            this.fetchConcisedContent(areaRequest);
        }
    }

    private void createConcisedResult(FsfStatus status) {
        this.tree.createAreaResult(new AreaResult<RegionContent>(status, new RegionContent(this.nodeBpRegion, this.concisedValue)));
    }

    private long getSubtreeBpLengthApproximation() {
        if (this.parent != null && this.parent.nodeBpRegion != null && this.nodeBpRegion != null) {
            return Math.abs(this.parent.nodeBpRegion.start - this.nodeBpRegion.start) * 2L;
        }
        return Long.MAX_VALUE;
    }

    public void processFileResult(FileResult fileResult) {
        if (this.concisedValue == null || this.nodeBpRegion == null) {
            ChunkParser parser = this.instructions.getParser();
            parser.setChunk(fileResult.chunk);
            this.concisedValue = this.instructions.conciser.concise(fileResult.chunk, parser);
            this.nodeBpRegion = new Region(parser.getLong(fileResult.chunk.readIndex, Content.BP_START), parser.getLong(fileResult.chunk.readIndex + parser.getReadCount() - 1L, Content.BP_START));
            if (fileResult.request.areaRequest != null) {
                this.processAreaRequest(fileResult.request.areaRequest);
            }
        }
        if (this.nodeBpRegion.intercepts(fileResult.request.areaRequest)) {
            if (fileResult.status.concise) {
                this.createConcisedResult(fileResult.status);
            } else {
                this.createReads(fileResult.chunk, fileResult.request.areaRequest, fileResult.status);
            }
        }
    }

    public void createReads(ByteChunk chunk, AreaRequest areaRequest, FsfStatus status) {
        ChunkParser parser = this.instructions.getParser();
        parser.setChunk(chunk);
        int i = 0;
        while ((long)i < parser.getReadCount()) {
            Region readReg = this.instructions.conciser.getRegion(parser, (long)i + chunk.readIndex);
            Map<Content, Object> values = parser.getValues((long)i + chunk.readIndex, areaRequest.requestedContents);
            values.put(Content.FILE_INDEX, (long)i + chunk.readIndex);
            this.tree.createAreaResult(new AreaResult<RegionContent>(status, new RegionContent(readReg, values)));
            ++i;
        }
    }
}

