/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import java.util.Queue;
import javax.swing.SwingUtilities;

public abstract class AreaRequestHandler
extends Thread {
    private Queue<AreaRequest> areaRequestQueue;
    private AreaResultListener areaResultListener;

    public AreaRequestHandler(Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener) {
        this.areaRequestQueue = areaRequestQueue;
        this.areaResultListener = areaResultListener;
        this.setDaemon(true);
    }

    @Override
    public synchronized void run() {
        while (true) {
            AreaRequest areaRequest;
            if ((areaRequest = this.areaRequestQueue.poll()) != null) {
                areaRequest.status.areaRequestCount = this.areaRequestQueue.size();
                this.processAreaRequest(areaRequest);
            }
            boolean isWorkToDo = this.checkOtherQueues();
            if (areaRequest != null || isWorkToDo) continue;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected boolean checkOtherQueues() {
        return false;
    }

    public synchronized void notifyTree() {
        this.notifyAll();
    }

    protected abstract void processAreaRequest(AreaRequest var1);

    public void createAreaResult(final AreaResult areaResult) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AreaRequestHandler.this.areaResultListener.processAreaResult(areaResult);
            }
        });
    }
}

