/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.GenomeBrowser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.TextDrawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class HorizontalView
extends View {
    public HorizontalView(GenomeBrowser parent, boolean movable, boolean zoomable, boolean selectable) {
        super(parent, movable, zoomable, selectable);
    }

    @Override
    protected void drawView(Graphics2D g, boolean isAnimation) {
        super.drawView(g, isAnimation);
        if (this.highlight != null) {
            g.setPaint(new Color(0, 0, 0, 64));
            Rectangle rect = g.getClip().getBounds();
            rect.x = this.bpToTrack(this.highlight.start);
            rect.width = Math.max(1, this.bpToTrack(this.highlight.end) - rect.x);
            g.fill(rect);
        }
    }

    @Override
    protected void drawDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        g.setPaint(drawable.color);
        if (drawable instanceof TextDrawable) {
            this.drawTextDrawable(g, x, y, drawable);
        } else if (drawable instanceof RectDrawable) {
            this.drawRectDrawable(g, x, y, drawable);
        } else if (drawable instanceof LineDrawable) {
            this.drawLineDrawable(g, x, y, drawable);
        }
    }

    protected void drawTextDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        TextDrawable text = (TextDrawable)drawable;
        g.drawString(text.text, text.x + x, text.y + y);
    }

    protected void drawRectDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        RectDrawable rect = (RectDrawable)drawable;
        if (rect.color != null) {
            if (rect.lineColor == null) {
                --rect.x;
                rect.width += 2;
            }
            g.setPaint(drawable.color);
            g.fillRect(rect.x + x, rect.y + y, rect.width, rect.height);
        }
        if (drawable.color != null) {
            g.setPaint(rect.lineColor);
            g.drawRect(rect.x + x, rect.y + y, rect.width, rect.height);
        }
    }

    protected void drawLineDrawable(Graphics2D g, int x, int y, Drawable drawable) {
        LineDrawable line = (LineDrawable)drawable;
        g.drawLine(line.x + x, line.y + y, line.x2 + x, line.y2 + y);
    }

    @Override
    protected void handleDrag(Point2D start, Point2D end, boolean disableDrawing) {
        long bpMove = this.trackToBp((long)start.getX()) - this.trackToBp((long)end.getX());
        if (bpMove < 0L && this.bpRegion.start < Math.abs(bpMove)) {
            bpMove = -this.bpRegion.start.longValue();
        }
        this.bpRegion.move(bpMove);
        this.setBpRegion(this.bpRegion, disableDrawing);
        this.parentPlot.redraw();
    }
}

