/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.HorizontalView;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.RegionListener;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.StraightforwardFileParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.TreeThread;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ConstantRefGeneInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.CytobandReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ElandReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.FastaFsfReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.CytobandTrack;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.GeneTrack;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.IntensityTrack;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.RulerTrack;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.SeqBlockTrack;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.SeqTrack;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.util.ObjectUtilities;

public class GenomeBrowser
extends Plot
implements ChartMouseListener,
Cloneable,
Serializable {
    private Font descriptionFont;
    private List<View> views = new LinkedList<View>();
    private View overview = new HorizontalView(this, false, false, true);
    private BufferedImage drawBuffer;
    private int screenWidth;
    public ChartPanel chartPanel;

    public GenomeBrowser() {
        File cytobandFile = new File("cytoband_hg17_sorted.txt");
        CytobandTrack overviewCytobands = new CytobandTrack(this.overview, cytobandFile, StraightforwardFileParser.class, new CytobandReadInstructions(), false);
        this.overview.addTrack(overviewCytobands);
        overviewCytobands.initializeListener();
        this.overview.margin = 5;
        this.views.add(this.overview);
        HorizontalView dataView = null;
        dataView = new HorizontalView(this, true, true, false);
        CytobandTrack cytobands = new CytobandTrack(dataView, cytobandFile, StraightforwardFileParser.class, new CytobandReadInstructions(), true);
        dataView.addTrack(cytobands);
        cytobands.initializeListener();
        IntensityTrack annotationOverview = new IntensityTrack(dataView, new File("chr1_uscs.fsf"), TreeThread.class, new ConstantRefGeneInstructions(), GeneTrack.PartColor.CDS.c.darker(), 10000000L);
        dataView.addTrack(annotationOverview);
        annotationOverview.initializeListener();
        GeneTrack annotation = new GeneTrack(dataView, new File("chr1_uscs.fsf"), TreeThread.class, new ConstantRefGeneInstructions(), Color.DARK_GRAY, 10000000L);
        dataView.addTrack(annotation);
        annotation.initializeListener();
        dataView.addTrack(new SeparatorTrack(dataView));
        GeneTrack annotationReversed = new GeneTrack(dataView, new File("chr1_uscs.fsf"), TreeThread.class, new ConstantRefGeneInstructions(), Color.DARK_GRAY, 10000000L);
        annotationReversed.setReverseStrand(true);
        dataView.addTrack(annotationReversed);
        annotationReversed.initializeListener();
        File userData = new File("eland_export.fsf");
        ElandReadInstructions userDataInstructions = new ElandReadInstructions();
        IntensityTrack reads2 = new IntensityTrack(dataView, userData, TreeThread.class, userDataInstructions, Color.gray, 1000000L);
        dataView.addTrack(reads2);
        reads2.initializeListener();
        SeqBlockTrack reads = new SeqBlockTrack(dataView, userData, TreeThread.class, userDataInstructions, Color.RED, 0L, 1000000L);
        dataView.addTrack(reads);
        reads.initializeListener();
        dataView.addTrack(new SeparatorTrack(dataView));
        File seqFile = new File("chr1.fsf");
        SeqTrack seq = new SeqTrack(dataView, seqFile, TreeThread.class, new FastaFsfReadInstructions(), 800L);
        dataView.addTrack(seq);
        seq.initializeListener();
        dataView.addTrack(new SeparatorTrack(dataView));
        SeqBlockTrack readsReversed = new SeqBlockTrack(dataView, userData, TreeThread.class, userDataInstructions, Color.RED, 0L, 1000000L);
        readsReversed.setReverseStrand(true);
        dataView.addTrack(readsReversed);
        readsReversed.initializeListener();
        dataView.addTrack(new RulerTrack(dataView));
        this.views.add(dataView);
        dataView.addRegionListener(new RegionListener(){

            @Override
            public void RegionChanged(Region bpRegion) {
                ((GenomeBrowser)GenomeBrowser.this).overview.highlight = bpRegion;
            }
        });
    }

    public String getPlotType() {
        return "GeneBrowser";
    }

    public Font getDescriptionFont() {
        return this.descriptionFont;
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(area);
            info.setDataArea(area);
        }
        this.drawBackground(g2, area);
        this.drawOutline(g2, area);
        Shape savedClip = g2.getClip();
        g2.clip(area);
        this.drawPlot(g2, area, info);
        Rectangle viewArea = (Rectangle)area.getBounds().clone();
        float[] viewHeights = new float[]{0.2f, 0.8f};
        int origHeight = viewArea.height;
        for (int i = 0; i < this.views.size(); ++i) {
            if (i > 0) {
                viewArea.y += viewArea.height;
            }
            viewArea.height = (int)(area.getBounds().getHeight() * (double)viewHeights[i]);
            g2.setClip(viewArea);
            this.views.get(i).drawView(g2, false);
        }
        g2.setClip(savedClip);
        this.drawOutline(g2, area);
    }

    private void drawPlot(Graphics2D g2, Rectangle2D area, PlotRenderingInfo info) {
    }

    private float getScreenWidth() {
        if (this.screenWidth != 0) {
            return this.screenWidth;
        }
        return 600.0f;
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    public void chartMouseClicked(ChartMouseEvent e) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenomeBrowser)) {
            return false;
        }
        GenomeBrowser that = (GenomeBrowser)obj;
        return ObjectUtilities.equal((Object)this.descriptionFont, (Object)that.descriptionFont);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void redraw() {
        this.datasetChanged(new DatasetChangeEvent((Object)this, null));
    }

    public Collection<View> getViews() {
        return this.views;
    }
}

