/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.visualisation.AnnotateListPanel;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.threed.ColorGroupsPanel;
import fi.csc.microarray.client.visualisation.methods.threed.CoordinateArea;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.LinkUtils;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Scatterplot3DPCA
extends Scatterplot3D {
    DataBean phenoBean;
    private List<String> colorGroupList;
    private JScrollPane legendScroller;

    public Scatterplot3DPCA(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public AnnotateListPanel createListPanel() {
        return new AnnotateListPanel("Chips", false);
    }

    @Override
    protected void refreshAxisBoxes(DataBean data) {
        List<Object> phenoCols;
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        this.updateCombo(this.xBox, data);
        this.updateCombo(this.yBox, data);
        this.updateCombo(this.zBox, data);
        this.phenoBean = LinkUtils.retrieveInherited(data, DataBean.Link.ANNOTATION);
        if (this.phenoBean != null) {
            phenoCols = Arrays.asList(VisualisationUtilities.getVariablesFilteredInclusive(this.phenoBean, "", false));
        } else {
            phenoCols = new LinkedList<Visualisation.Variable>();
            phenoCols.add(new Visualisation.Variable("No phenodata", ""));
        }
        Visualisation.fillCompoBox(this.colorBox, phenoCols.toArray(new Visualisation.Variable[0]));
    }

    @Override
    protected void retrieveData(List<Visualisation.Variable> variables) throws MicroarrayException {
        Iterable<String> colorStrings;
        Iterable<String> identifier = this.data.queryFeatures("/identifier").asStrings();
        Iterable<Float> xValues = this.data.queryFeatures(variables.get(0).getExpression()).asFloats();
        Iterable<Float> yValues = this.data.queryFeatures(variables.get(1).getExpression()).asFloats();
        Iterable<Float> zValues = this.data.queryFeatures(variables.get(2).getExpression()).asFloats();
        String colorQuery = variables.get(3).getExpression();
        if (this.phenoBean != null) {
            colorStrings = this.phenoBean.queryFeatures(colorQuery).asStrings();
        } else {
            LinkedList<String> list = new LinkedList<String>();
            Iterator<Float> iter = xValues.iterator();
            while (iter.hasNext()) {
                iter.next();
                list.add("");
            }
            colorStrings = list;
        }
        TreeSet<String> groups = new TreeSet<String>();
        for (String str : colorStrings) {
            groups.add(str);
        }
        this.colorGroupList = Arrays.asList(groups.toArray(new String[0]));
        LinkedList<Float> cValues = new LinkedList<Float>();
        for (String str : colorStrings) {
            cValues.add(Float.valueOf(this.colorGroupList.indexOf(str)));
        }
        this.dataModel.setData(identifier, xValues, yValues, zValues, cValues);
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        Object value;
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        boolean isChips = false;
        Parameter pcaOn = bean.getOperation().getParameter("do.pca.on");
        if (pcaOn != null && (value = pcaOn.getValue()) != null && value.equals("chips")) {
            isChips = true;
        }
        return bean.getOperation().getDefinition().getName().equals("PCA") && isChips && isTabular && this.hasRows(bean) && bean.queryFeatures("/column/chip.*").exists();
    }

    @Override
    protected void useButtonPressed() {
        ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
        vars.add((Visualisation.Variable)this.xBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.yBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.zBox.getSelectedItem());
        vars.add((Visualisation.Variable)this.colorBox.getSelectedItem());
        this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, VisualisationMethod.SCATTERPLOT3DPCA, vars, this.getFrame().getDatas(), this.getFrame().getType(), this.getFrame()));
        this.coordinateArea.setPaintMode(CoordinateArea.PaintMode.PIXEL);
    }

    @Override
    protected JComponent getColorLabel() {
        JTextArea label = new JTextArea("Color from\nphenodata:");
        label.setOpaque(false);
        label.setEditable(false);
        return label;
    }

    @Override
    protected JComponent getColorScalePanel() {
        ColorGroupsPanel legendPanel = new ColorGroupsPanel(this.dataModel, this.colorGroupList);
        this.legendScroller = new JScrollPane(legendPanel);
        this.legendScroller.setPreferredSize(new Dimension(50, 300));
        return this.legendScroller;
    }
}

