/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.selection.RowChoiceEvent;
import fi.csc.microarray.client.selection.RowSelectionManager;
import fi.csc.microarray.client.visualisation.AnnotateListPanel;
import fi.csc.microarray.client.visualisation.ChipVisualisation;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.methods.SelectableChartPanel;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Scatterplot
extends ChipVisualisation
implements ActionListener,
PropertyChangeListener,
SelectableChartPanel.SelectionChangeListener {
    protected SelectableChartPanel selectableChartPanel;
    protected JPanel paramPanel;
    protected AnnotateListPanel list;
    protected JComboBox xBox;
    protected JComboBox yBox;
    protected Visualisation.Variable xVar;
    protected Visualisation.Variable yVar;
    protected XYPlot plot;
    protected DataBean data;
    protected JButton useButton;
    protected Set<Integer> selectedIndexes = new HashSet<Integer>();

    public Scatterplot(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.paramPanel.setLayout(new BorderLayout());
            JPanel settings = this.createSettingsPanel();
            this.list = new AnnotateListPanel();
            JTabbedPane tabPane = new JTabbedPane();
            tabPane.addTab("Settings", settings);
            tabPane.addTab("Selected", this.list);
            this.paramPanel.add((Component)tabPane, "Center");
        }
        return this.paramPanel;
    }

    public JPanel createSettingsPanel() {
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridBagLayout());
        settingsPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
        this.xBox = new JComboBox();
        this.yBox = new JComboBox();
        this.useButton = new JButton("Draw");
        this.useButton.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets.set(10, 10, 10, 10);
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        settingsPanel.add((Component)new JLabel("X-axis: "), c);
        ++c.gridy;
        settingsPanel.add((Component)this.xBox, c);
        ++c.gridy;
        settingsPanel.add((Component)new JLabel("Y-axis: "), c);
        ++c.gridy;
        settingsPanel.add((Component)this.yBox, c);
        ++c.gridy;
        settingsPanel.add((Component)this.useButton, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        settingsPanel.add((Component)new JPanel(), c);
        this.xBox.addActionListener(this);
        this.yBox.addActionListener(this);
        return settingsPanel;
    }

    protected void refreshAxisBoxes(DataBean data) {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        Visualisation.fillCompoBox(this.xBox, this.getVariablesFor(data));
        Visualisation.fillCompoBox(this.yBox, this.getVariablesFor(data));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.useButton) {
            ArrayList<Visualisation.Variable> vars = new ArrayList<Visualisation.Variable>();
            vars.add((Visualisation.Variable)this.xBox.getSelectedItem());
            vars.add((Visualisation.Variable)this.yBox.getSelectedItem());
            this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, VisualisationMethod.SCATTERPLOT, vars, this.getFrame().getDatas(), this.getFrame().getType(), this.getFrame()));
        }
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        this.data = data;
        this.refreshAxisBoxes(data);
        List<Visualisation.Variable> vars = this.getFrame().getVariables();
        if (vars == null || vars.size() < 2) {
            if (this.xBox.getItemCount() >= 1) {
                this.xBox.setSelectedIndex(0);
            }
            if (this.yBox.getItemCount() >= 2) {
                this.yBox.setSelectedIndex(1);
            } else {
                this.yBox.setSelectedIndex(0);
            }
        } else {
            this.xBox.setSelectedItem(vars.get(0));
            this.yBox.setSelectedItem(vars.get(1));
        }
        this.xVar = (Visualisation.Variable)this.xBox.getSelectedItem();
        this.yVar = (Visualisation.Variable)this.yBox.getSelectedItem();
        Visualisation.PlotDescription description = new Visualisation.PlotDescription(data.getName(), this.xVar.getName(), this.yVar.getName());
        NumberAxis domainAxis = new NumberAxis(description.xTitle);
        domainAxis.setAutoRangeIncludesZero(false);
        NumberAxis rangeAxis = new NumberAxis(description.yTitle);
        rangeAxis.setAutoRangeIncludesZero(false);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setLinesVisible(false);
        renderer.setShapesVisible(true);
        renderer.setShape((Shape)new Ellipse2D.Float(-2.0f, -2.0f, 4.0f, 4.0f));
        renderer.setSeriesPaint(1, (Paint)Color.black);
        this.plot = new XYPlot((XYDataset)new XYSeriesCollection(), (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        this.updateSelectionsFromApplication(false);
        JFreeChart chart = new JFreeChart(description.plotTitle, (Plot)this.plot);
        this.application.addPropertyChangeListener(this);
        this.selectableChartPanel = new SelectableChartPanel(chart, this);
        return this.selectableChartPanel;
    }

    protected void updateXYSerieses() throws MicroarrayException {
        Iterable<Float> xValues = this.data.queryFeatures(this.xVar.getExpression()).asFloats();
        Iterable<Float> yValues = this.data.queryFeatures(this.yVar.getExpression()).asFloats();
        XYSeries series = new XYSeries((Comparable)((Object)""));
        XYSeries selectionSeries = new XYSeries((Comparable)((Object)""));
        Iterator<Float> xIterator = xValues != null ? xValues.iterator() : null;
        int i = 0;
        for (Float y : yValues) {
            if (this.selectedIndexes.contains(i)) {
                if (xIterator != null) {
                    selectionSeries.add((Number)xIterator.next(), (Number)y);
                } else {
                    selectionSeries.add((double)i, (Number)y);
                }
            } else if (xIterator != null) {
                series.add((Number)xIterator.next(), (Number)y);
            } else {
                series.add((double)i, (Number)y);
            }
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        dataset.addSeries(selectionSeries);
        this.plot.setDataset((XYDataset)dataset);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof RowChoiceEvent && evt.getSource() != this && ((RowChoiceEvent)evt).getData() == this.data) {
            this.updateSelectionsFromApplication(false);
        }
    }

    protected void updateSelectionsFromApplication(boolean dispatchEvent) {
        RowSelectionManager manager = this.application.getSelectionManager().getRowSelectionManager(this.data);
        this.selectedIndexes.clear();
        for (int i : manager.getSelectedRows()) {
            this.selectedIndexes.add(i);
        }
        this.list.setSelectedRows(this.selectedIndexes, this, dispatchEvent, this.data);
        try {
            this.updateXYSerieses();
        }
        catch (MicroarrayException e) {
            this.application.reportException(e);
        }
    }

    @Override
    public void selectionChanged(Rectangle2D.Double newSelection) {
        if (newSelection == null) {
            this.selectedIndexes.clear();
        } else {
            try {
                Iterator<Float> xValues = this.data.queryFeatures(this.xVar.getExpression()).asFloats().iterator();
                Iterator<Float> yValues = this.data.queryFeatures(this.yVar.getExpression()).asFloats().iterator();
                int i = 0;
                while (xValues.hasNext() && yValues.hasNext()) {
                    double y;
                    double x = xValues.next().floatValue();
                    if (newSelection.contains(new Point2D.Double(x, y = (double)yValues.next().floatValue()))) {
                        if (this.selectedIndexes.contains(i)) {
                            this.selectedIndexes.remove(i);
                        } else {
                            this.selectedIndexes.add(i);
                        }
                    }
                    ++i;
                }
            }
            catch (MicroarrayException e) {
                this.application.reportException(e);
            }
        }
        this.list.setSelectedRows(this.selectedIndexes, this, true, this.data);
        try {
            this.updateXYSerieses();
        }
        catch (MicroarrayException e) {
            this.application.reportException(e);
        }
    }
}

