/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.selection.RowChoiceEvent;
import fi.csc.microarray.client.selection.RowSelectionManager;
import fi.csc.microarray.client.visualisation.ChipVisualisation;
import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.methods.SelectableChartPanel;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.QueryResult;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.exception.ErrorReportAsException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.jfree.chart.BioChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.chart.entity.HeatMapBlockEntity;
import org.jfree.chart.event.ClusteringTreeChangeEvent;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.GradientColorPalette;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.HeatMap;

public class Heatmap
extends ChipVisualisation
implements PropertyChangeListener,
SelectableChartPanel.SelectionChangeListener {
    private HCPlot hcPlot;
    protected SelectableChartPanel selectableChartPanel;
    protected Set<Integer> selected = new HashSet<Integer>();
    protected DataBean selectionBean;
    protected JPanel zoomChangerPanel;
    protected JPanel spaceFiller;
    protected JScrollPane scroller;
    protected Dimension preferredSize;
    int rowCount;
    private static final Logger logger = Logger.getLogger(Heatmap.class);

    public Heatmap(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws ErrorReportAsException {
        try {
            TableAnnotationProvider annotationProvider = new TableAnnotationProvider(data);
            QueryResult heatMapFeature = data.queryFeatures("/column/chip.*");
            Table heatMapDataIterator = heatMapFeature.asTable();
            this.rowCount = 0;
            while (heatMapDataIterator.nextRow()) {
                ++this.rowCount;
            }
            LinkedList<String> columns = new LinkedList<String>();
            for (String columnName : heatMapDataIterator.getColumnNames()) {
                columns.add(columnName);
            }
            int columnCount = columns.size();
            HeatMap heatMap = new HeatMap("Heatmap", this.rowCount, columnCount);
            Table heatMapData = data.queryFeatures("/column/*").asTable();
            int row = -1;
            while (heatMapData.nextRow()) {
                String geneName = heatMapData.getStringValue(" ");
                geneName = annotationProvider.getAnnotatedRowname(geneName);
                heatMap.setRowName(++row, geneName);
                int i = -1;
                for (String columnName : columns) {
                    heatMap.update(row, ++i, (double)heatMapData.getFloatValue(columnName));
                }
            }
            int i = -1;
            for (String columnName : columns) {
                String sampleName = columnName.substring("chip.".length());
                String realName = data.queryFeatures("/phenodata/linked/describe/" + sampleName).asString();
                heatMap.setColumnName(++i, realName);
            }
            HCDataset dataset = new HCDataset(heatMap, null, null);
            boolean tooltips = true;
            JFreeChart chart = BioChartFactory.createHCChart((String)"Hierarchical Clustering", (HCDataset)dataset, (boolean)tooltips, (boolean)false);
            if (chart.getPlot() instanceof HCPlot) {
                HCPlot hcPlot;
                this.hcPlot = hcPlot = (HCPlot)chart.getPlot();
                this.hcPlot.addChangeListener(new PlotChangeListener(){

                    public void plotChanged(PlotChangeEvent event) {
                        if (event instanceof ClusteringTreeChangeEvent) {
                            // empty if block
                        }
                    }
                });
                double min = Heatmap.getMinValue(dataset.getHeatMap());
                double max = Heatmap.getMaxValue(dataset.getHeatMap());
                GradientColorPalette colors = new GradientColorPalette(new double[]{min, max}, new Color[]{Color.BLUE, Color.BLACK, Color.RED});
                hcPlot.setColoring(colors);
            }
            chart.setTitle((TextTitle)null);
            this.selectableChartPanel = new SelectableChartPanel(chart, this, false);
            this.selectableChartPanel.getChartPanel().addChartMouseListener((ChartMouseListener)((HCPlot)chart.getPlot()));
            this.updateSelectionsFromApplication(false);
            this.application.addPropertyChangeListener(this);
            int blockSize = 10;
            int width = (int)((double)(heatMap.getColumnsCount() * blockSize) + this.hcPlot.getRowTreeSize() + this.hcPlot.getRowNamesSize() + this.hcPlot.getLeftMarginSize() + this.hcPlot.getRightMarginSize());
            int height = (int)((double)(heatMap.getRowCount() * blockSize) + this.hcPlot.getColumnNamesSize() + this.hcPlot.getTopMarginSize() + this.hcPlot.getBottomMarginSize());
            this.preferredSize = new Dimension(width, height);
            this.zoomChangerPanel = new JPanel(new BorderLayout());
            this.spaceFiller = new JPanel();
            ((FlowLayout)this.spaceFiller.getLayout()).setAlignment(0);
            this.spaceFiller.setBackground(Color.white);
            this.scroller = new JScrollPane(this.spaceFiller);
            this.setScaledMode(false);
            return this.zoomChangerPanel;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ErrorReportAsException("Hierarchical clustering cannot be shown.", "The problem is probably caused by unsupported data, such as gene names that have illegal characters in them.", e);
        }
    }

    protected void updateSelectionsFromApplication(boolean dispatchEvent) {
        RowSelectionManager manager = this.application.getSelectionManager().getRowSelectionManager(this.selectionBean);
        this.selected.clear();
        for (int i : manager.getSelectedRows()) {
            this.selected.add(i);
        }
        this.showSelection(dispatchEvent);
    }

    public static Double getMinValue(HeatMap heatmap) {
        Double min = null;
        for (int row = 0; row < heatmap.getRowCount(); ++row) {
            for (int column = 0; column < heatmap.getColumnsCount(); ++column) {
                Double value = heatmap.get(row, column);
                if (min != null && !(value < min)) continue;
                min = value;
            }
        }
        return min;
    }

    public static Double getMaxValue(HeatMap heatmap) {
        Double max = null;
        for (int row = 0; row < heatmap.getRowCount(); ++row) {
            for (int column = 0; column < heatmap.getColumnsCount(); ++column) {
                Double value = heatmap.get(row, column);
                if (max != null && !(value > max)) continue;
                max = value;
            }
        }
        return max;
    }

    protected void showSelection(boolean dispatchEvent) {
        Object[] detailedSelection = new HCPlot.Selection[this.rowCount];
        Arrays.fill(detailedSelection, HCPlot.Selection.NO);
        this.hcPlot.showSelection((HCPlot.Selection[])detailedSelection, true);
    }

    public void setScaledMode(boolean scaled) {
        if (scaled) {
            this.spaceFiller.remove(this.selectableChartPanel);
            this.zoomChangerPanel.remove(this.scroller);
            this.zoomChangerPanel.add((Component)this.selectableChartPanel, "Center");
            this.selectableChartPanel.setPreferredSize(null);
        } else {
            this.spaceFiller.add(this.selectableChartPanel);
            this.zoomChangerPanel.remove(this.selectableChartPanel);
            this.zoomChangerPanel.add((Component)this.scroller, "Center");
            this.selectableChartPanel.setPreferredSize(this.preferredSize);
        }
        this.zoomChangerPanel.validate();
        this.zoomChangerPanel.repaint();
    }

    @Override
    public void selectionChanged(Rectangle2D.Double selectionRect) {
        if (selectionRect == null) {
            this.selected.clear();
        } else {
            ChartRenderingInfo info = this.selectableChartPanel.getChartPanel().getChartRenderingInfo();
            EntityCollection entities = info.getEntityCollection();
            HashSet newSelection = new HashSet();
            for (Object obj : entities.getEntities()) {
                HCTreeNodeEntity entity;
                if (obj instanceof HCTreeNodeEntity && (entity = (HCTreeNodeEntity)obj).getArea().intersects(selectionRect)) {
                    return;
                }
                if (obj instanceof HeatMapBlockEntity && !(entity = (HeatMapBlockEntity)obj).getArea().intersects(selectionRect)) continue;
            }
            for (Integer row : newSelection) {
                if (this.selected.contains(row)) {
                    this.selected.remove(row);
                    continue;
                }
                this.selected.add(row);
            }
            this.showSelection(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof RowChoiceEvent && evt.getSource() != this && ((RowChoiceEvent)evt).getData() == this.selectionBean) {
            this.updateSelectionsFromApplication(false);
        }
    }
}

