/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.ExternalVisualisationFrame;
import fi.csc.microarray.client.visualisation.InternalVisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.client.visualisation.VisualisationTaskManager;
import fi.csc.microarray.client.visualisation.VisualisationToolBar;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class VisualisationFrameManager
implements PropertyChangeListener {
    private VisualisationTaskManager visualisationTaskManager = new VisualisationTaskManager(this);
    private InternalVisualisationFrame mainFrame = new InternalVisualisationFrame(FrameType.MAIN);
    private InternalVisualisationFrame sideFrame = new InternalVisualisationFrame(FrameType.SIDE);
    private List<ExternalVisualisationFrame> windows = new ArrayList<ExternalVisualisationFrame>();
    private JSplitPane split;
    private boolean twinView;
    private SimpleInternalFrame frameComponent;
    private VisualisationToolBar toolBar;

    public VisualisationFrameManager() {
        Session.getSession().getApplication().addPropertyChangeListener(this);
        this.toolBar = new VisualisationToolBar();
    }

    public JPanel getFramesPanel() {
        if (this.frameComponent == null) {
            this.frameComponent = new SimpleInternalFrame("Visualisation");
            this.frameComponent.setToolBar(this.toolBar);
            this.split = new JSplitPane();
            this.split.setDividerLocation(0.5);
            this.split.setResizeWeight(0.5);
            this.updateInternalContent();
        }
        return this.frameComponent;
    }

    public VisualisationToolBar getVisualisationToolBar() {
        return this.toolBar;
    }

    public Vector<Component> getFocusComponents() {
        Vector<Component> order = new Vector<Component>();
        order.addAll(this.toolBar.getFocusComponents());
        return order;
    }

    private void updateInternalContent() {
        int splitLocation = this.split.getWidth() / 2;
        if (this.twinView) {
            splitLocation = this.split.getDividerLocation();
            this.split.setLeftComponent(this.mainFrame.getFrameComponent());
            this.split.setRightComponent(this.sideFrame.getFrameComponent());
            this.frameComponent.setContent(this.split);
        } else {
            this.frameComponent.setContent(this.mainFrame.getFrameComponent());
        }
        if (this.split.getWidth() > 0) {
            this.split.setDividerLocation(splitLocation);
        } else {
            this.split.setDividerLocation(0.5);
        }
    }

    public void closeAllByType(FrameType type) {
        switch (type) {
            case SIDE: {
                this.twinView = false;
                this.updateInternalContent();
                break;
            }
            case WINDOW: {
                for (ExternalVisualisationFrame window : this.windows) {
                    window.getFrameComponent().dispose();
                }
                this.windows.clear();
                break;
            }
            case MAIN: {
                throw new IllegalArgumentException("Main visualisation frame can't be closed");
            }
        }
    }

    public boolean isTwinView() {
        return this.twinView;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event instanceof VisualisationMethodChangedEvent) {
            VisualisationMethodChangedEvent e = (VisualisationMethodChangedEvent)event;
            if (((VisualisationMethodChangedEvent)event).getNewMethod() != VisualisationMethod.NONE) {
                this.showWaitPanel(e.getTarget());
            }
            this.visualisationTaskManager.visualise(e);
        }
    }

    public void showWaitPanel(FrameType frameType) {
        switch (frameType) {
            case MAIN: {
                this.mainFrame.showWaitPanel();
                this.updateInternalContent();
                break;
            }
            case SIDE: {
                this.sideFrame.showWaitPanel();
                this.twinView = true;
                this.updateInternalContent();
                break;
            }
        }
    }

    public void showVisualisationComponent(JComponent visualisation, VisualisationMethodChangedEvent e) {
        switch (e.getTarget()) {
            case MAIN: {
                this.mainFrame.showVisualisationComponent(visualisation);
                this.updateInternalContent();
                break;
            }
            case SIDE: {
                this.twinView = true;
                this.sideFrame.showVisualisationComponent(visualisation);
                this.updateInternalContent();
                break;
            }
            case WINDOW: {
                e.getTargetFrameInstance().showVisualisationComponent(visualisation);
            }
        }
    }

    public JComponent createVisualisation(VisualisationMethodChangedEvent e) {
        switch (e.getTarget()) {
            case MAIN: {
                return this.mainFrame.createVisualisation(e);
            }
            case SIDE: {
                return this.sideFrame.createVisualisation(e);
            }
            case WINDOW: {
                ExternalVisualisationFrame window;
                if (e.getTargetFrameInstance() == null || !this.windows.contains(e.getTargetFrameInstance())) {
                    window = new ExternalVisualisationFrame();
                    e.setTargetFrameInstance(window);
                    this.windows.add(window);
                } else {
                    window = (ExternalVisualisationFrame)e.getTargetFrameInstance();
                }
                JComponent visualisation = window.createVisualisation(e);
                return visualisation;
            }
        }
        return null;
    }

    public VisualisationFrame getFrame(FrameType target) {
        switch (target) {
            case MAIN: {
                return this.mainFrame;
            }
            case SIDE: {
                return this.sideFrame;
            }
            case WINDOW: {
                return this.windows.get(0);
            }
        }
        return null;
    }

    public static enum FrameType {
        MAIN,
        SIDE,
        WINDOW;

    }
}

