/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.selection;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.selection.RowSelectionManager;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataSelectionManager {
    private static final Logger logger = Logger.getLogger(DataSelectionManager.class);
    private ClientApplication client;
    private LinkedList<DataItem> selectedDatas = new LinkedList();
    private Map<DataItem, RowSelectionManager> rowSelectionManagers = new HashMap<DataItem, RowSelectionManager>();

    public DataSelectionManager(ClientApplication client) {
        this.client = client;
        this.clearAll(true, this);
    }

    public RowSelectionManager getRowSelectionManager(DataBean data) {
        RowSelectionManager manager = this.rowSelectionManagers.get(data);
        if (manager == null) {
            manager = new RowSelectionManager(this.client, data);
            this.rowSelectionManagers.put(data, manager);
        }
        return manager;
    }

    public DataItem getSelectedItem() {
        return this.selectedDatas.isEmpty() ? null : this.selectedDatas.getLast();
    }

    public DataBean getSelectedDataBean() {
        DataItem selectedItem = this.getSelectedItem();
        if (selectedItem instanceof DataFolder) {
            return null;
        }
        return (DataBean)selectedItem;
    }

    public DataBean[] getSelectedDatasAsArray() {
        LinkedList<DataBean> beans = new LinkedList<DataBean>();
        for (DataBean bean : this.getSelectedDataBeans()) {
            beans.add(bean);
        }
        return beans.toArray(new DataBean[0]);
    }

    public List<DataBean> getSelectedDataBeans() {
        LinkedList<DataBean> list = new LinkedList<DataBean>();
        for (DataItem item : this.selectedDatas) {
            if (!(item instanceof DataBean)) continue;
            list.add((DataBean)item);
        }
        return list;
    }

    public List<DataItem> getSelectedDataItems() {
        LinkedList<DataItem> newList = new LinkedList<DataItem>();
        newList.addAll(this.selectedDatas);
        return newList;
    }

    public void selectSingle(DataItem dataItem, Object source) {
        this.selectedDatas.clear();
        this.selectMultiple(dataItem, source);
    }

    public void selectMultiple(DataItem selectedItem, Object source) {
        LinkedList<DataItem> itemCollection = new LinkedList<DataItem>();
        itemCollection.add(selectedItem);
        this.selectMultiple(itemCollection, source);
    }

    public void selectMultiple(Iterable<DataItem> items, Object source) {
        boolean realChange = false;
        for (DataItem item : items) {
            if (this.selectedDatas.contains(item)) continue;
            this.selectedDatas.add(item);
            realChange = true;
        }
        if (realChange) {
            this.client.dispatchEvent(new DatasetChoiceEvent(source));
        }
    }

    public void deselectMultiple(DataItem selectedItem, Object source) {
        if (this.selectedDatas.contains(selectedItem)) {
            this.selectedDatas.remove(selectedItem);
            this.client.dispatchEvent(new DatasetChoiceEvent(source));
        }
        if (logger.isDebugEnabled()) {
            String s = "selection contains:";
            for (DataItem item : this.selectedDatas) {
                s = s + " " + item.getName();
            }
            logger.debug((Object)s);
        }
    }

    public void clearAll(boolean dispatchEvent, Object source) {
        this.selectedDatas.clear();
        if (dispatchEvent) {
            this.client.dispatchEvent(new DatasetChoiceEvent(source));
        }
    }

    public boolean isSelected(DataItem data) {
        return this.selectedDatas.contains(data);
    }
}

