/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationPanel;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ToolParameterPanel
extends ParameterPanel {
    private JScrollPane scroller;
    private static final int LEFT_MARGIN = 10;
    private static final int TOP_MARGIN = 2;
    private OperationPanel parent;

    public ToolParameterPanel(Operation operation, OperationPanel parent) throws MicroarrayException {
        super(operation, new BorderLayout());
        this.parent = parent;
        JPanel paramPane = new JPanel(new GridBagLayout());
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 1;
        con.weightx = 1.0;
        con.weighty = 0.0;
        con.anchor = 17;
        this.paramMap = new HashMap();
        for (Parameter param : operation.getParameters()) {
            ParameterInputComponent component = this.createInputComponent(param);
            this.paramMap.put(param, component);
            con.gridx = 0;
            ++con.gridy;
            con.insets.top = 2;
            con.insets.left = 10;
            con.fill = 2;
            paramPane.add((Component)component.getLabel(), con);
            con.gridx = 1;
            con.anchor = 13;
            con.fill = 0;
            paramPane.add((Component)component, con);
        }
        con.weighty = 1.0;
        con.weightx = 0.0;
        con.gridx = 0;
        ++con.gridy;
        con.gridwidth = 2;
        con.fill = 1;
        paramPane.add((Component)new JPanel(), con);
        this.scroller = new JScrollPane(paramPane);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.scroller.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, VisualConstants.OPERATION_LIST_BORDER_COLOR));
        this.add((Component)this.scroller, "Center");
    }

    @Override
    public void setMessage(String message, Color color) {
        this.parent.setInfoText(message, color, true);
    }
}

