/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.parameter.Parameter;

public class DecimalParameter
extends Parameter {
    private float minValue;
    private float maxValue;
    private float value;

    public DecimalParameter(String name, String description, float minValue, float maxValue, float initValue) throws IllegalArgumentException {
        super(name, description);
        this.minValue = minValue;
        if (maxValue < minValue) {
            throw new IllegalArgumentException("Minimum value for decimal parameter " + this.getName() + " cannot be bigger than the maximum value.");
        }
        this.maxValue = maxValue;
        if (initValue < minValue || initValue > maxValue) {
            throw new IllegalArgumentException("Initial value for decimal parameter " + this.getName() + " must be inside given limits.");
        }
        this.value = initValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getDecimalValue() {
        return this.value;
    }

    @Override
    public Object getValue() {
        return Float.valueOf(this.value);
    }

    public void setMinValue(float newMinValue) throws IllegalArgumentException {
        if (newMinValue > this.maxValue) {
            throw new IllegalArgumentException("New minimum value for " + this.getName() + " cannot exceed current maximum value.");
        }
        this.minValue = newMinValue;
        if (this.value < this.minValue) {
            this.value = this.minValue;
        }
    }

    public void setMaxValue(float newMaxValue) throws IllegalArgumentException {
        if (newMaxValue < this.minValue) {
            throw new IllegalArgumentException("New maximum value for " + this.getName() + " cannot fall below current minimum value.");
        }
        this.maxValue = newMaxValue;
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        }
    }

    public void setDecimalValue(float newValue) throws IllegalArgumentException {
        if (newValue < this.minValue || newValue > this.maxValue) {
            throw new IllegalArgumentException("New value for decimal parameter " + this.getName() + " must be inside given limits.");
        }
        this.value = newValue;
    }

    @Override
    public void setValue(Object newValue) {
        if (newValue instanceof Float) {
            this.value = ((Float)newValue).floatValue();
        }
        if (!(newValue instanceof Double)) {
            throw new IllegalArgumentException(newValue + " is an illegal " + "value for decimal parameter " + this.getName() + ".");
        }
        double doubleValue = (Double)newValue;
        this.value = (float)doubleValue;
    }

    @Override
    public boolean checkValidityOf(Object valueObject) {
        double doubleValue;
        float floatValue;
        if (valueObject instanceof Float && (floatValue = ((Float)valueObject).floatValue()) >= this.minValue && floatValue <= this.maxValue) {
            return true;
        }
        return valueObject instanceof Double && (doubleValue = ((Double)valueObject).doubleValue()) >= (double)this.minValue && doubleValue <= (double)this.maxValue;
    }

    @Override
    public String toString() {
        return this.getName() + ": " + this.value;
    }

    @Override
    public String getValueAsJava() {
        return "" + this.value;
    }

    @Override
    public void parseValue(String stringValue) throws IllegalArgumentException {
        try {
            this.setValue(Double.parseDouble(stringValue));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("cannot parse String value \"" + stringValue + "\"");
        }
    }
}

