/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.description.ParsedVVSADL;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OperationGenerator {
    private static final Logger logger = Logger.getLogger(OperationGenerator.class);

    public Map<String, OperationCategory> generate(List<ParsedVVSADL> descriptions) {
        logger.debug((Object)("generating operations from " + descriptions.size() + " descriptions"));
        LinkedHashMap<String, OperationCategory> parsedCategories = new LinkedHashMap<String, OperationCategory>();
        for (ParsedVVSADL description : descriptions) {
            logger.debug((Object)("processing " + description.getName()));
            if (parsedCategories.get(description.getPackageName()) == null) {
                OperationCategory op = new OperationCategory(description.getPackageName());
                if (parsedCategories.size() + 1 < VisualConstants.CATEGORY_COLORS.length) {
                    op.setColor(VisualConstants.CATEGORY_COLORS[parsedCategories.size() + 1]);
                } else {
                    float[] hsb = new float[]{0.0f, 0.5f, 0.8f};
                    hsb[0] = (float)parsedCategories.size() * 0.15f / 1.0f;
                    op.setColor(new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2])));
                }
                parsedCategories.put(op.getName(), op);
                logger.debug((Object)("added category " + op.getName()));
            }
            OperationDefinition newDefinition = new OperationDefinition(description.getName(), parsedCategories.get(description.getPackageName()), description.getComment(), true);
            logger.debug((Object)("added operation " + newDefinition.getName() + " to " + newDefinition.getCategoryName()));
            for (ParsedVVSADL.Input input : description.inputs()) {
                if (input.isInputSet()) {
                    newDefinition.addInput(input.getPrefix(), input.getPostfix(), input.getType());
                    continue;
                }
                newDefinition.addInput(input.getName(), input.getType());
            }
            logger.debug((Object)("added " + description.inputs().size() + " inputs"));
            newDefinition.setOutputCount(description.outputs().size());
            for (ParsedVVSADL.Parameter parameter : description.parameters()) {
                newDefinition.addParameter(Parameter.createInstance(parameter.getName(), parameter.getType(), parameter.getSelectionOptions(), parameter.getComment(), parameter.getFrom(), parameter.getTo(), parameter.getDefaultValue()));
            }
        }
        logger.debug((Object)"operation generation returning successfully");
        return parsedCategories;
    }
}

