/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dialog;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dataimport.ImportUtils;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.parameter.ImportParameterPanel;
import fi.csc.microarray.exception.MicroarrayException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TaskImportDialog
extends JDialog
implements ActionListener {
    private final Dimension BUTTON_SIZE = new Dimension(70, 25);
    private JLabel titleLabel;
    private JLabel descriptionLabel;
    private JLabel noteLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox folderNameCombo;
    private ClientApplication application;
    private Operation operation;

    public TaskImportDialog(SwingClientApplication application, String databaseName, Operation operation) throws MicroarrayException {
        super((Frame)application.getMainFrame(), true);
        this.application = application;
        this.operation = operation;
        this.setTitle("Import");
        this.setModal(true);
        this.setPreferredSize(new Dimension(500, 300));
        this.titleLabel = new JLabel("<html><p style=\"font-weight:bold;font-size:120%\">Import data from " + databaseName + "</p></html>");
        this.descriptionLabel = new JLabel("<html>" + operation.getDescription() + "</html>");
        this.noteLabel = new JLabel("<html><p style=\"font-style:italic\">It may take a while for the import task to finish.");
        this.folderNameCombo = new JComboBox<Object>(ImportUtils.getFolderNames(false).toArray());
        this.folderNameCombo.setEditable(true);
        this.okButton = new JButton("Import");
        this.okButton.setPreferredSize(this.BUTTON_SIZE);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(this.BUTTON_SIZE);
        this.cancelButton.addActionListener(this);
        ImportParameterPanel parameterPanel = new ImportParameterPanel(operation, null);
        JPanel keepButtonsRightPanel = new JPanel(new GridBagLayout());
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.weightx = 1.0;
        buttonConstraints.weighty = 1.0;
        buttonConstraints.anchor = 13;
        buttonConstraints.insets.set(0, 0, 0, 8);
        keepButtonsRightPanel.add((Component)this.cancelButton, buttonConstraints);
        buttonConstraints.gridx = -1;
        buttonConstraints.insets.set(0, 0, 0, 0);
        keepButtonsRightPanel.add((Component)this.okButton, buttonConstraints);
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets.set(10, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.titleLabel, c);
        ++c.gridy;
        this.add((Component)this.descriptionLabel, c);
        ++c.gridy;
        c.weighty = 120.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets.set(0, 10, 10, 10);
        this.add((Component)parameterPanel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets.set(0, 10, 10, 10);
        c.fill = 2;
        this.add((Component)this.noteLabel, c);
        c.insets.set(10, 10, 10, 10);
        c.anchor = 14;
        ++c.gridy;
        c.fill = 0;
        this.add((Component)keepButtonsRightPanel, c);
        this.pack();
        this.setLocationRelativeTo(application.getMainFrame());
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            try {
                this.application.executeOperation(this.operation);
            }
            catch (Exception me) {
                this.application.reportException(me);
            }
            finally {
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }
}

