/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client;

import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dialog.RenameDialog;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.module.chipster.ChipsterInputTypes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class ClientContextMenu
extends JPopupMenu
implements ActionListener,
PopupMenuListener {
    private static final Logger logger = Logger.getLogger(ClientContextMenu.class);
    private SwingClientApplication application;
    private DataItem selectedItem;
    private JMenuItem visualiseMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem importMenuItem;
    private JMenuItem exportMenuItem;
    private JMenuItem historyMenuItem;
    private JMenuItem saveWorkflowItem;
    private JMenu linksMenu;
    private JMenu linkToMenu;
    private JMenu unlinkMenu;
    private JMenu metadataLinkMenu;
    private Map<JMenuItem, LinkInfo> linkMap = new HashMap<JMenuItem, LinkInfo>();
    private Map<JMenuItem, LinkInfo> unlinkMap = new HashMap<JMenuItem, LinkInfo>();

    public ClientContextMenu(SwingClientApplication application) {
        this.application = application;
        this.addPopupMenuListener(this);
        this.visualiseMenuItem = new JMenuItem("Visualise");
        this.visualiseMenuItem.setFont(this.getFont().deriveFont(1));
        this.metadataLinkMenu = new JMenu("Link to phenodata");
        this.metadataLinkMenu.setIcon(VisualConstants.LINK_PHENODATA_MENUICON);
        this.linksMenu = new JMenu("Links between selected");
        this.linkToMenu = new JMenu("Link");
        this.linkToMenu.setIcon(VisualConstants.LINK_MENUICON);
        this.linksMenu.add(this.linkToMenu);
        this.unlinkMenu = new JMenu("Unlink");
        this.unlinkMenu.setIcon(VisualConstants.UNLINK_MENUICON);
        this.linksMenu.add(this.unlinkMenu);
        this.renameMenuItem = new JMenuItem("Rename");
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.setIcon(VisualConstants.DELETE_MENUICON);
        this.importMenuItem = new JMenuItem("Import files...");
        this.exportMenuItem = new JMenuItem("Export...");
        this.exportMenuItem.setIcon(VisualConstants.EXPORT_MENUICON);
        this.historyMenuItem = new JMenuItem("View history as text");
        this.historyMenuItem.setIcon(VisualConstants.GENERATE_HISTORY_ICON);
        this.saveWorkflowItem = new JMenuItem("Save workflow");
        this.visualiseMenuItem.addActionListener(this);
        this.renameMenuItem.addActionListener(this);
        this.deleteMenuItem.addActionListener(this);
        this.importMenuItem.addActionListener(this);
        this.exportMenuItem.addActionListener(this);
        this.historyMenuItem.addActionListener(this);
        this.saveWorkflowItem.addActionListener(this);
    }

    public void setOptionsFor(List<DataItem> items) {
        boolean multipleSelected;
        while (items.contains(null)) {
            items.remove(null);
        }
        boolean bl = multipleSelected = items.size() > 1;
        if (items != null && items.size() > 0) {
            this.selectedItem = items.get(0);
        }
        this.removeAll();
        if (items != null && items.size() > 0) {
            this.add(this.visualiseMenuItem);
            this.addSeparator();
            this.add(this.metadataLinkMenu);
            this.add(this.linksMenu);
            this.addSeparator();
            this.add(this.renameMenuItem);
            this.add(this.deleteMenuItem);
            this.addSeparator();
            this.add(this.saveWorkflowItem);
            this.addSeparator();
            this.add(this.exportMenuItem);
            this.add(this.historyMenuItem);
            if (multipleSelected) {
                this.visualiseMenuItem.setEnabled(this.application.isSelectedDataVisualisable());
                this.renameMenuItem.setEnabled(false);
                this.exportMenuItem.setEnabled(true);
                this.historyMenuItem.setEnabled(false);
                this.saveWorkflowItem.setEnabled(false);
            } else if (this.selectedItem instanceof DataBean) {
                this.visualiseMenuItem.setEnabled(true);
                this.renameMenuItem.setEnabled(true);
                this.exportMenuItem.setEnabled(true);
                this.historyMenuItem.setEnabled(true);
                boolean normalisedDataSelected = ChipsterInputTypes.GENE_EXPRS.isTypeOf((DataBean)this.selectedItem);
                this.saveWorkflowItem.setEnabled(normalisedDataSelected);
            } else {
                this.visualiseMenuItem.setEnabled(false);
                this.renameMenuItem.setEnabled(true);
                this.exportMenuItem.setEnabled(true);
                this.historyMenuItem.setEnabled(false);
                this.saveWorkflowItem.setEnabled(false);
            }
        } else {
            this.add(this.importMenuItem);
        }
        this.updateLinkMenus(items);
    }

    private void updateLinkMenus(List<DataItem> items) {
        if (items.size() == 2 && items.get(0) != null && items.get(0) instanceof DataBean && items.get(1) != null && items.get(1) instanceof DataBean) {
            this.metadataLinkMenu.setEnabled(false);
            this.linksMenu.setEnabled(true);
            DataBean one = (DataBean)items.get(0);
            DataBean other = (DataBean)items.get(1);
            this.linkToMenu.removeAll();
            this.createNewLinkMenu(one, other);
            this.createRemoveLinkMenu(one, other);
        } else if (items.size() == 1 && items.get(0) != null && items.get(0) instanceof DataBean) {
            this.metadataLinkMenu.setEnabled(true);
            this.linksMenu.setEnabled(false);
            int itemsCreated = 0;
            if (!((DataBean)items.get(0)).queryFeatures("/phenodata").exists()) {
                List<DataBean> allDatas = this.application.getDataManager().databeans();
                allDatas.remove(this.selectedItem);
                for (DataBean data : allDatas) {
                    if (!data.queryFeatures("/phenodata").exists()) continue;
                    JMenuItem annotateMenuItem = new JMenuItem(this.getBeanText(data));
                    this.metadataLinkMenu.add(annotateMenuItem);
                    this.linkMap.put(annotateMenuItem, new LinkInfo((DataBean)this.selectedItem, data, DataBean.Link.ANNOTATION));
                    annotateMenuItem.addActionListener(this);
                    ++itemsCreated;
                }
            }
            if (itemsCreated == 0) {
                this.metadataLinkMenu.setEnabled(false);
            }
        } else {
            this.metadataLinkMenu.setEnabled(false);
            this.linksMenu.setEnabled(false);
        }
    }

    private void createRemoveLinkMenu(DataBean one, DataBean other) {
        this.unlinkMenu.setEnabled(false);
        for (LinkInfo link : ClientContextMenu.getSharedLinks(one, other)) {
            this.unlinkMenu.setEnabled(true);
            JMenuItem unlink = new JMenuItem(link.link.toString() + ": " + this.getLinkText(one, other, false));
            this.unlinkMap.put(unlink, link);
            this.unlinkMenu.add(unlink);
            unlink.addActionListener(this);
        }
    }

    private String getBeanText(DataBean one) {
        return one.getName();
    }

    private void createNewLinkMenu(DataBean one, DataBean other) {
        DataBean.Link[] links;
        for (DataBean.Link link : links = DataBean.Link.userEditableValues()) {
            JMenu linkMenu = new JMenu(link.toString());
            this.linkToMenu.add(linkMenu);
            JMenuItem oneMenuItem = new JMenuItem(this.getLinkText(one, other, false));
            linkMenu.add(oneMenuItem);
            this.linkMap.put(oneMenuItem, new LinkInfo(one, other, link));
            oneMenuItem.addActionListener(this);
            JMenuItem otherMenuItem = new JMenuItem(this.getLinkText(one, other, true));
            linkMenu.add(otherMenuItem);
            this.linkMap.put(otherMenuItem, new LinkInfo(other, one, link));
            otherMenuItem.addActionListener(this);
        }
    }

    private String getLinkText(DataBean one, DataBean other, boolean reversed) {
        String arrow = !reversed ? "  ->  " : "  <-  ";
        return this.getBeanText(one) + arrow + this.getBeanText(other);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.visualiseMenuItem) {
            this.application.visualiseWithBestMethod(VisualisationFrameManager.FrameType.MAIN);
        } else if (source == this.renameMenuItem) {
            new RenameDialog(this.application, this.selectedItem);
        } else if (source == this.deleteMenuItem) {
            if (this.selectedItem instanceof DataFolder) {
                this.application.deleteDatas((DataFolder)this.selectedItem);
            } else {
                this.application.deleteDatas(this.application.getSelectionManager().getSelectedDataBeans().toArray(new DataItem[0]));
            }
        } else if (source == this.importMenuItem) {
            try {
                this.application.openFileImport();
            }
            catch (Exception me) {
                this.application.reportException(me);
            }
        } else if (source == this.exportMenuItem) {
            this.application.exportSelectedItems();
        } else if (source == this.historyMenuItem) {
            if (this.selectedItem instanceof DataBean) {
                logger.debug((Object)"History activated");
                DataBean data = (DataBean)this.selectedItem;
                if (data != null) {
                    this.application.showHistoryScreenFor(data);
                }
            }
        } else if (source == this.saveWorkflowItem) {
            this.application.saveWorkflow();
        } else if (this.linkMap.keySet().contains(source)) {
            LinkInfo linkData = this.linkMap.get(source);
            this.application.createLink(linkData.getTarget(), linkData.getSource(), linkData.getLink());
        } else if (this.unlinkMap.keySet().contains(source)) {
            LinkInfo connector = this.unlinkMap.get((JMenuItem)source);
            logger.debug((Object)("Removing link from " + connector.getSource()));
            ClientContextMenu.printLinksForData((DataBean)this.selectedItem);
            this.application.removeLink(connector.getSource(), connector.getTarget(), connector.getLink());
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (this.selectedItem instanceof DataBean) {
            this.historyMenuItem.setEnabled(true);
        } else {
            this.historyMenuItem.setEnabled(false);
        }
    }

    private static List<LinkInfo> getSharedLinks(DataBean one, DataBean other) {
        ArrayList<LinkInfo> sharedLinks = new ArrayList<LinkInfo>();
        for (DataBean.Link linkType : DataBean.Link.values()) {
            for (DataBean target : one.getLinkTargets(linkType)) {
                if (other != target) continue;
                sharedLinks.add(new LinkInfo(one, target, linkType));
            }
            for (DataBean target : other.getLinkTargets(linkType)) {
                if (one != target) continue;
                sharedLinks.add(new LinkInfo(other, target, linkType));
            }
        }
        Collections.sort(sharedLinks, new Comparator<LinkInfo>(){

            @Override
            public int compare(LinkInfo o1, LinkInfo o2) {
                return o1.getLink().toString().compareTo(o2.getLink().toString());
            }
        });
        return sharedLinks;
    }

    public static void printLinksForData(DataBean data) {
        for (DataBean.Link type : DataBean.Link.values()) {
            for (DataBean source : data.getLinkSources(type)) {
                logger.debug((Object)(source.getName() + " <" + (Object)((Object)type) + "> " + data.getName()));
            }
        }
        for (DataBean.Link type : DataBean.Link.values()) {
            for (DataBean target : data.getLinkTargets(type)) {
                logger.debug((Object)(data.getName() + " <" + (Object)((Object)type) + "> " + target.getName()));
            }
        }
    }

    private static class LinkInfo {
        private DataBean source;
        private DataBean target;
        private DataBean.Link link;

        public LinkInfo(DataBean source, DataBean target, DataBean.Link link) {
            this.source = source;
            this.target = target;
            this.link = link;
        }

        public DataBean getSource() {
            return this.source;
        }

        public DataBean getTarget() {
            return this.target;
        }

        public DataBean.Link getLink() {
            return this.link;
        }
    }
}

